/*==========================================================
This class creates a buffered image of the dpanel2 in order
for it to be saved as a JPEG.

Author: Eric Fritz
===========================================================*/
import javax.swing.*;
import java.awt.*;
import java.awt.image.BufferedImage;
import javax.imageio.ImageIO;
import java.io.*;
import java.util.*;
import java.lang.*;

public class iClass2
{
	private dPanel2 dpanel2;
	private int contigNum = 0;
	private Contig[] contigArray;
	private interactiveRectangle[] rectArray;
	private String contigName;
	private BufferedImage bimage;
	private int Iwidth = 0;
	private int Iheight = 0;
	
	//This method creates the buffered image.
	public void createImage()
	{
		bimage = new BufferedImage(Iwidth,Iheight,BufferedImage.TYPE_INT_RGB);
		Graphics2D g2 = bimage.createGraphics();
		
		try
		{
			g2.setColor(Color.WHITE);
			g2.fillRect(0,0,Iwidth,Iheight);
			g2.setColor(Color.BLACK);
			g2.drawString(contigName, 40, 35);
			String backbone = contigArray[contigNum].getContigSeq();
			int BDist = 40;
			for(int i = 0; i < backbone.length(); i++)
			{
				g2.drawString(String.valueOf(backbone.charAt(i)), BDist, 60);
				BDist += 8;
			}
		
			for(int i = 0; i < rectArray.length; i++)
			{
				Double temp1 = rectArray[i].getX();
				Double temp2 = rectArray[i].getY();
				Double temp3 = temp2-5.0;
				int XDist = ((temp1.intValue()-40)*8)+40;
				g2.setColor(Color.BLACK);
				g2.drawString(rectArray[i].getContigName(), XDist, temp3.intValue());
				String rectSeq = rectArray[i].getContigSeq();
				rectSeq.toUpperCase();
				
				for(int j = 0; j < rectSeq.length(); j++)
				{
					g2.setColor(Color.BLUE);
					if(!String.valueOf(rectSeq.charAt(j)).equals(String.valueOf(backbone.charAt(j+rectArray[i].getStartOfContig()-1))))
					{g2.setColor(Color.MAGENTA);}
					g2.drawString(String.valueOf(rectSeq.charAt(j)), XDist, temp2.intValue()+7);
					XDist += 8;
				}
			}
			g2.dispose();
		}
		catch(NullPointerException npe){}
	}
	
	//This method allows for other classes to set the values needed.
	public void setValues()
	{
		contigName = contigArray[contigNum].getContigName();
		rectArray = contigArray[contigNum].getRectArray();
	}
	
	//This method is utilized when clearing the template so a new file can be uploaded.
	public void clearValues()
	{
	    contigName = "";
	    rectArray = new interactiveRectangle[0];
	}
	
	//The following methods allow for the setting and retreiving of pertinent
	//data from the class.
	public void setWidth(int w)
	{Iwidth = w;}
	public void setHeight(int h)
	{Iheight = h;}
	public int getWidth()
	{return Iwidth;}
	public int getHeight()
	{return Iheight;}
	public BufferedImage getImage()
	{return bimage;}
	public void setContigArray(Contig[] sca)
	{contigArray = sca;}
	public void setContigNum(int scn)
	{contigNum = scn;}
	
	//This method allows the image to be saved.
	public void save(File f)
	{
		try
		{
			ImageIO.write(bimage, "jpg", f);
		}
		catch(IOException ioe){}
	}
}