/*==========================================================
This class creates a buffered image of the display panel in
order for it to be saved as a JPEG.

Author: Eric Fritz
===========================================================*/
import javax.swing.*;
import java.awt.*;
import java.awt.image.BufferedImage;
import javax.imageio.ImageIO;
import java.io.*;
import java.util.*;
import java.lang.*;

public class imageClass
{
	private displayPanel displaypanel;
	private int contigNum = 0;
	private Contig[] contigArray;
	private interactiveRectangle[] rectArray;
	private Rectangle backbone;
	private String contigName;
	private BufferedImage bimage;
	private int Iwidth = 0;
	private int Iheight = 0;
	
	//This method creates the buffered image.
	public void createImage()
	{
		bimage = new BufferedImage(Iwidth,Iheight,BufferedImage.TYPE_INT_RGB);
		Graphics2D g2 = bimage.createGraphics();
		
		try
		{
			g2.setColor(Color.WHITE);
			g2.fillRect(0,0,Iwidth,Iheight);
			g2.setColor(Color.BLACK);
			g2.drawString(contigName, 40, 35);
			g2.fill(backbone);
			for(int j = 40; j < contigArray[contigNum].getContigLength()+40; j += 100)
			{
				g2.drawString(String.valueOf(j-40), j , 50);
				g2.drawLine(j, 55, j, 80);
			}
			
			for(int i = 0; i < rectArray.length; i++)
			{
				Rectangle tempRect = rectArray[i];
				g2.setColor(Color.BLUE);
				g2.fill(tempRect);
				Double temp1 = rectArray[i].getX();
				Double temp2 = rectArray[i].getY()-4.0;
				g2.setColor(Color.BLACK);
				g2.drawString(rectArray[i].getContigName(), temp1.intValue(), temp2.intValue());

			}
			g2.dispose();
		}
		catch(NullPointerException npe){}
	}
	
	//This method allows other classes to set the values needed.
	public void setValues()
	{
		backbone = new Rectangle(40, 60, contigArray[contigNum].getContigLength(), 15);
		contigName = contigArray[contigNum].getContigName();
		rectArray = contigArray[contigNum].getRectArray();
	}
	
	//This method is utilized when clearing the template so a new file can be uploaded.
	public void clearValues()
	{
	    backbone = new Rectangle(0,0,0,0);
	    contigName = "";
	    rectArray = new interactiveRectangle[0];
	}
	
	//The following methods allow for setting and retreiving pertinent info from the class.
	public void setWidth(int w)
	{Iwidth = w;}
	public void setHeight(int h)
	{Iheight = h;}
	public int getWidth()
	{return Iwidth;}
	public int getHeight()
	{return Iheight;}
	public BufferedImage getImage()
	{return bimage;}
	
	public void setContigArray(Contig[] sca)
	{contigArray = sca;}
	public void setContigNum(int scn)
	{contigNum = scn;}
	
	//This method allows the image to be saved.
	public void save(File f)
	{
		try
		{
			ImageIO.write(bimage, "jpg", f);
		}
		catch(IOException ioe){}
	}
}