/*=============================================================
This class creates the window(frame) in which the different
panels are displayed.

Author: Eric Fritz
==============================================================*/
import javax.swing.*;
import java.awt.*;
import javax.swing.border.*;
import java.awt.event.*;

public class mainWindow extends JFrame
{   
    private displayPanel displaypanel;
    private JScrollPane dpScroll;
    private JScrollPane spScroll;
    private mainWindow mainWin;
    private imageClass printImage;
    private int displayNum = 1;
    private dPanel2 dpanel2;
    private iClass2 pImage2;
    private dPanelp dpanelp;
    private fileUploadPanel uploadpanel;

    //This is the constructor.
    public mainWindow()
    {
        mainWin = this;
        mainWin.setTitle("BEAP Graphics Display");
        mainWin.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        
        printImage = new imageClass();
        pImage2 = new iClass2();
        dpanelp = new dPanelp();
        
        ReadTextFile application = new ReadTextFile();
        
        displaypanel = new displayPanel(mainWin, printImage, uploadpanel, dpanel2, pImage2, dpanelp);
        dpanel2 = new dPanel2(mainWin, displaypanel, printImage, uploadpanel, pImage2, dpanelp);
        
        if(displayNum == 1)//Dispalys the line/bar view of the displaypanel.
        {
            dpScroll = new JScrollPane(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS, JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
            dpScroll.getVerticalScrollBar().setUnitIncrement(20);
            dpScroll.getHorizontalScrollBar().setUnitIncrement(50);
            dpScroll.getViewport().add(displaypanel);
        }
        else//Displays the nucleotide view of the dpanel2.
        {
            dpScroll = new JScrollPane(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS, JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
            dpScroll.getVerticalScrollBar().setUnitIncrement(20);
            dpScroll.getHorizontalScrollBar().setUnitIncrement(50);
            dpScroll.getViewport().add(dpanel2);
        }
        uploadpanel = new fileUploadPanel(displaypanel, application,
        mainWin, printImage, dpanel2, pImage2, dpanelp);
        
        BeapMenuBar bmBar = new BeapMenuBar(displaypanel, mainWin, printImage, pImage2, dpanel2, dpanelp);
        
        mainWin.setJMenuBar(bmBar);
        mainWin.add(uploadpanel, BorderLayout.NORTH);
        mainWin.add(dpScroll, BorderLayout.CENTER);
        
        mainWin.pack();
        mainWin.setVisible(true);
    }
    
    //These methods are used when switching between the contigs being viewed. (general view)
    public void setDisplayPanel(displayPanel dp)
    {
        displaypanel = dp;      
        dpScroll.getViewport().add(displaypanel);   
    }
    public void removeDisplayPanel()
    {
        dpScroll.remove(displaypanel);
    }
    
    //These methods set and retrieve a variable used throughout different
    //classes to know which contig is being viewed.
    public void setDisplayNum(int sdn)
    {
        displayNum = sdn;
    }
    public int getDisplayNum()
    {
        return displayNum;
    }
    
    //These methods are used when switching between the contigs viewed. (nucleotide view)
    public void setDPanel2(dPanel2 dp2)
    {
        dpanel2 = dp2;
        dpScroll.getViewport().add(dpanel2);
    }
    public void removeDPanel2()
    {
        dpScroll.remove(dpanel2);
    }
}