/*=======================================================
This class creates the panel that gives the options of
printing, saving, or linking to a website in the 
seqDisplayFrame.

Author: Eric Fritz
========================================================*/
import javax.swing.*;
import java.awt.*;
import java.awt.geom.*;
import javax.swing.border.*;
import java.awt.event.*;
import java.io.*;
import java.awt.*;
import java.net.URI;
import java.net.URISyntaxException;

public class sdfPanel extends JPanel
{
    private SeqTextArea stArea;
    private sdfPanel sdfp;
    private seqDisplayFrame sdFrame;
    private seqPrintPanel seqpp;
    private String cName;
    private mainWindow mainWin;
    private displayPanel displaypanel;
    private imageClass printImage;
    private fileUploadPanel uploadpanel;
    private dPanel2 dpanel2;
    private iClass2 pImage2;
    private dPanelp dpanelp;
    private Contig[] contigArray;
    private int changeNum;
    private int contigNum;
    private int typeNum;
    private JTextArea shiftNum;
    
    //This is the constructor.
    public sdfPanel(SeqTextArea sta, seqDisplayFrame sdf, seqPrintPanel spp, mainWindow mW, displayPanel dp, imageClass iC, fileUploadPanel fup, dPanel2 dp2, iClass2 ic2, dPanelp dpp, Contig[] cA, int cN, int cnN, int tn)
    {
        stArea = sta;
        sdFrame = sdf;
        seqpp = spp;
        mainWin = mW;
        displaypanel = dp;
        printImage = iC;
        uploadpanel = fup;
        dpanel2 = dp2;
        pImage2 = ic2;
        dpanelp = dpp;
        contigArray = cA;
        changeNum = cN;
        contigNum = cnN;
        typeNum = tn;
        cName = sdFrame.getCName();
        sdfp = this;
        
        //Implements the Print button.
        JButton printOption = new JButton("Print");
        printOption.addActionListener(new printListener());
        
        //Implements the Save button.
        JButton saveOption = new JButton("Save");
        saveOption.addActionListener(new saveListener());
        
        //Implements the Remove button
        JButton removeOption = new JButton("Remove");
        removeOption.addActionListener(new removeListener());
        
        add(saveOption);
        add(printOption);
        add(removeOption);
    }
    
    //This class prints the sequence when the Print button is clicked.
    private class printListener implements ActionListener
    {
        public printListener(){}
        
        public void actionPerformed(ActionEvent e)
        {
            seqpp.createImage();
            seqpp.PrintPanel();
        }
    }
    
    //This class prompts saving the sequence as a text document when the
    //Save button is clicked.
    private class saveListener implements ActionListener
    {
        public void actionPerformed(ActionEvent e)
        {
            JFileChooser fileChoiceWindow = new JFileChooser();
            fileChoiceWindow.setCurrentDirectory(new File("."));
            
            boolean done = false;
            while (!done)
            {
                String tName = sdFrame.getCName();
                String fName = tName.replace("|"," ");
                
                File namefile = new File(fName+".txt");
                fileChoiceWindow.setSelectedFile(namefile);
        
                int choiceResult = fileChoiceWindow.showSaveDialog(sdfp);
                if (choiceResult == JFileChooser.CANCEL_OPTION)
                {
                    done = true;
                }
                if (choiceResult == JFileChooser.APPROVE_OPTION)
                {
                    File filePicked = fileChoiceWindow.getSelectedFile();
                    try
                    {
                        stArea.save(filePicked);
                        done = true;
                    }
                    catch (IOException ex)
                    {
                        JOptionPane.showMessageDialog(sdfp, "Problems with file, choose another");
                    }
                }
            }
        }
    }
    
    //This class removes the sequence from the contig when the remove button is clicked.
    private class removeListener implements ActionListener
    {
        public void actionPerformed(ActionEvent e)
        {
            interactiveRectangle[] rectArray = contigArray[contigNum].getRectArray();
            interactiveRectangle[] tempRectArray = new interactiveRectangle[rectArray.length-1];
            
            for(int i=0; i < changeNum; i++)
            {
                tempRectArray[i] = rectArray[i];
            }
            for(int j=(changeNum+1); j < rectArray.length; j++)
            {
                tempRectArray[j-1] = rectArray[j];
            }
            
            contigArray[contigNum].setRectArray(tempRectArray);
            
            displaypanel.setContigArray(contigArray);
            displaypanel.setContigNum(0);
            displaypanel.setContigValues();
            displaypanel.revalidate();
            displaypanel.repaint();
            printImage.setContigArray(contigArray);
            printImage.setContigNum(0);
            printImage.setValues();
            uploadpanel.removeComboBox();
            uploadpanel.setContigArray(contigArray);
            uploadpanel.setContigValues();
            uploadpanel.revalidate();
            dpanel2.setContigArray(contigArray);
            dpanel2.setContigNum(0);
            dpanel2.setContigValues();
            dpanel2.revalidate();
            pImage2.setContigArray(contigArray);
            pImage2.setValues();
            dpanelp.setContigArray(contigArray);
            dpanelp.setContigNum(0);
            dpanelp.setContigValues();
            
            if(typeNum == 1)
            {
                mainWin.removeDisplayPanel();
                mainWin.setDisplayPanel(displaypanel);
            }
            else
            {
                mainWin.removeDPanel2();
                mainWin.setDPanel2(dpanel2);
            }
        }
    }
}