/*========================================================
This class creates the window(frame) in which the info
is displayed when one of the lines/bars is clicked in the
displaypanel.

Author: Eric Fritz
========================================================*/
import javax.swing.*;
import java.awt.*;
import java.awt.geom.*;
import javax.swing.border.*;
import java.awt.event.*;

public class seqDisplayFrame extends JFrame
{
	private String cName, cSeq;
	private seqDisplayFrame sdFrame;
	private seqPrintPanel seqpp;
	private mainWindow mainWin;
	private displayPanel displaypanel;
	private imageClass printImage;
	private fileUploadPanel uploadpanel;
	private dPanel2 dpanel2;
	private iClass2 pImage2;
	private dPanelp dpanelp;
	private Contig[] contigArray;
	private int changeNum;
	private int contigNum;
	private int typeNum;
	
	//This is the constructor.
	public seqDisplayFrame(String cn, String cs, mainWindow mW, displayPanel dp, imageClass iC, fileUploadPanel fup, dPanel2 dp2, iClass2 ic2, dPanelp dpp, Contig[] cA, int cN, int cnN, int tn)
	{
		sdFrame = this;
		cName = cn;
		cSeq = cs;
		sdFrame.setTitle(cName);
		mainWin = mW;
		displaypanel = dp;
		printImage = iC;
		uploadpanel = fup;
		dpanel2 = dp2;
		pImage2 = ic2;
		dpanelp = dpp;
		contigArray = cA;
		changeNum = cN;
		contigNum = cnN;
		typeNum = tn;
		
		String tempString = cSeq;
 		String finalString  = ">"+cName+"\n";
		String advName = cName;
		int count = 0;
		for(int i = 0; i < tempString.length(); i++)
		{
			if(count == 49)
			{
				finalString = finalString + String.valueOf(tempString.charAt(i))+"\n";
				count = 0;
			}
			else
			{
				finalString = finalString + String.valueOf(tempString.charAt(i));
				count++;
			}
		}//Creates the string of sequence for display.
		
		SeqTextArea seqArea = new SeqTextArea(finalString);
		seqpp = new seqPrintPanel(advName, tempString);
		
		//These set the differen calues for displaying the text.
		seqArea.setEditable(false);
		seqArea.setFont(new java.awt.Font("Lucida Console", 0, 14));
		seqArea.setPreferredSize(new Dimension(605, ((tempString.length()/50)+3)*20));
		JScrollPane saScroll = new JScrollPane(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS, JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
		saScroll.getViewport().add(seqArea);
		
		sdfPanel sdfp = new sdfPanel(seqArea, sdFrame, seqpp, mainWin, displaypanel, printImage, uploadpanel, dpanel2, pImage2, dpanelp, contigArray, changeNum, contigNum, typeNum);
		
		sdFrame.add(sdfp, BorderLayout.NORTH);
		sdFrame.add(saScroll, BorderLayout.CENTER);
		sdFrame.pack();		
	}
	
	//This method retreives the BAC, etc name.
	public String getCName()
	{
		return cName;
	}
}