/*==========================================================
This class creates a buffered image and utilizes the print
methods to allow the seqDisplayFrame to print the info
displayed.

Author: Eric Fritz
==========================================================*/
import javax.swing.*;
import java.awt.*;
import java.awt.geom.*;
import java.lang.Double.*;
import java.awt.print.*;
import java.awt.image.BufferedImage;
import javax.imageio.ImageIO;

public class seqPrintPanel extends JPanel implements Printable
{
	private seqPrintPanel seqpp;
	private String contigName;
	private String sequence;
	volatile static PageFormat pf;
	private int width;
	private int height;
	private BufferedImage bimage;
	
	//This is the constructor.
	public seqPrintPanel(String cname, String seq)
	{
		contigName = cname;
		sequence = seq;
		seqpp = this;
		width = 605;
		height = (((sequence.length()/50)+3)*14);
		setPreferredSize(new Dimension(width, height));
	}
	
	//This method creates the image to be printed.
	public void createImage()
	{
		bimage = new BufferedImage(width, height, BufferedImage.TYPE_INT_RGB);
		Graphics2D g2 = bimage.createGraphics();
		
		try
		{
			g2.setColor(Color.WHITE);
			g2.fillRect(0,0,width,height);
			g2.setColor(Color.BLACK);
			g2.drawString(contigName, 20, 20);
			int count = 0;
			int xVal = 20;
			int yVal = 50;
			for(int i = 0; i < sequence.length(); i++)
			{
				if(count == 49)
				{
					g2.drawString(String.valueOf(sequence.charAt(i)), xVal, yVal);
					count = 0;
					xVal = 20;
					yVal = yVal+10;
				}
				else
				{
					g2.drawString(String.valueOf(sequence.charAt(i)), xVal, yVal);
					count++;
					xVal = xVal+8;
				}
			}
		}
		catch(NullPointerException npe){}
	}
	
	//This method sets the graphics.
	void render(Graphics2D g2, boolean printerFlag)
	{
		if(printerFlag)
			g2.drawImage(bimage, (int)pf.getImageableX(), (int)pf.getImageableY(),
			width, height, null);
		else
			g2.drawImage(bimage,0,0,width,height,null);
	}
	
	//This method makes it so the graphics can be viewed but is not utilized right now.
	public void paintComponent(Graphics g)
	{
		super.paintComponent(g);
		Graphics2D g2 = (Graphics2D)g;
		render(g2, false);
	}
	
	//The following 2 methods are used to make the graphics printable.
	public int print(Graphics g, PageFormat pageFormat, int pageIndex)
	{
		Graphics2D g2 = (Graphics2D)g;
		int retcod = Printable.PAGE_EXISTS;
		if(pageIndex == 0)
			render(g2, true);
		else
			retcod = Printable.NO_SUCH_PAGE;
			
		return retcod;
	}
	public void PrintPanel()
	{
		PrinterJob pj = PrinterJob.getPrinterJob();
		pf = pj.defaultPage();
		pj.setPrintable(seqpp);
		PageFormat pf = pj.pageDialog(pj.defaultPage());
		try
		{
			pj.print();
		}
		catch(PrinterException pe){}
	}

}