/*
 * Decompiled with CFR 0.152.
 */
package com.borland.dbswing;

import com.borland.dbswing.Platform;
import com.borland.dbswing.Res;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JButton;
import javax.swing.JPanel;

public class ButtonStrip
extends JPanel {
    private boolean isMacLAF;
    private boolean isRightToLeft;
    private static final int BUTTON_SPACING = 8;
    private static final int EDGE_SPACING = 5;
    private ButtonStripLayout layout;
    private int inset;

    public ButtonStrip() {
        this(true);
    }

    public ButtonStrip(boolean useInsets) {
        this.isRightToLeft = this.isMacLAF = Platform.isMacLAF();
        this.layout = new ButtonStripLayout();
        this.setLayout(this.layout);
        this.inset = useInsets ? 5 : 0;
    }

    public ButtonStrip(boolean useInsets, boolean rightToLeft) {
        this.isRightToLeft = this.isMacLAF = Platform.isMacLAF();
        this.layout = new ButtonStripLayout();
        this.setLayout(this.layout);
        this.inset = useInsets ? 5 : 0;
        this.isRightToLeft = rightToLeft;
    }

    public void setOrientation(int orientation) {
        this.layout.setOrientation(orientation);
    }

    public JButton createButton(String title, boolean addToStrip) {
        return this.createButton(title, '\u0000', addToStrip);
    }

    public JButton createButton(String title, char mnemonic, boolean addToStrip) {
        JButton button = new JButton(title);
        if (mnemonic != '\u0000') {
            button.setMnemonic(mnemonic);
        }
        if (addToStrip) {
            this.add(button);
        }
        return button;
    }

    public JButton createHelpButton(boolean addToStrip) {
        if (this.isMacLAF) {
            JButton helpButton = this.createButton(Res._MacHelpButton, addToStrip);
            Insets insets = helpButton.getInsets();
            FontMetrics metrics = helpButton.getFontMetrics(helpButton.getFont());
            Dimension size = helpButton.getPreferredSize();
            size.width = insets.left + insets.right + 5 + metrics.stringWidth(helpButton.getText());
            helpButton.setPreferredSize(size);
            return helpButton;
        }
        return this.createButton(Res._HelpBtn, addToStrip);
    }

    public JButton createYesButton(boolean addToStrip) {
        return this.createButton(Res._YesButton, Res._YesButtonMnemonic.charAt(0), addToStrip);
    }

    public JButton createNoButton(boolean addToStrip) {
        return this.createButton(Res._NoButton, Res._NoButtonMnemonic.charAt(0), addToStrip);
    }

    public JButton createOkButton(boolean addToStrip) {
        return this.createButton(Res._OKBtn, addToStrip);
    }

    public JButton createCancelButton(boolean addToStrip) {
        return this.createButton(Res._CancelBtn, addToStrip);
    }

    public Insets getInsets() {
        return new Insets(this.inset, this.inset, this.inset, this.inset);
    }

    static {
        BUTTON_SPACING = 8;
        EDGE_SPACING = 5;
    }

    private class ButtonStripLayout
    implements LayoutManager {
        private int orientation = 0;

        private ButtonStripLayout() {
        }

        private void setOrientation(int orientation) {
            this.orientation = orientation;
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        public Dimension preferredLayoutSize(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Insets insets = parent.getInsets();
                Dimension size = new Dimension(insets.left + insets.right, insets.top + insets.bottom);
                int count = parent.getComponentCount();
                int maxHeight = 0;
                int maxWidth = 0;
                for (int index = 0; index < count; ++index) {
                    Component component = parent.getComponent(index);
                    Dimension componentSize = component.getPreferredSize();
                    if (this.orientation == 0) {
                        if (index > 0) {
                            size.width += 8;
                        }
                        size.width += componentSize.width;
                        maxHeight = Math.max(maxHeight, componentSize.height);
                        continue;
                    }
                    if (index > 0) {
                        size.height += 8;
                    }
                    size.height += componentSize.height;
                    maxWidth = Math.max(maxWidth, componentSize.width);
                }
                size.height += maxHeight;
                size.width += maxWidth;
                Dimension dimension = size;
                return dimension;
            }
        }

        public void layoutContainer(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Insets insets = parent.getInsets();
                int count = parent.getComponentCount();
                Dimension parentSize = parent.getSize();
                if (this.orientation == 0) {
                    int y2 = insets.top;
                    int x2 = parent.getWidth() - insets.right;
                    for (int index = 0; index < count; ++index) {
                        int componentIndex = ButtonStrip.this.isRightToLeft ? index : count - index - 1;
                        Component component = parent.getComponent(componentIndex);
                        Dimension size = component.getPreferredSize();
                        component.setBounds(x2 - size.width, (parentSize.height - size.height) / 2, size.width, size.height);
                        x2 -= size.width + 8;
                    }
                } else {
                    int y3 = insets.top;
                    int width = parentSize.width - insets.left - insets.right;
                    for (int index = 0; index < count; ++index) {
                        Component component = parent.getComponent(index);
                        Dimension size = component.getPreferredSize();
                        component.setBounds(insets.left, y3, width, size.height);
                        y3 += size.height + 8;
                    }
                }
            }
        }
    }
}

