/*
 * Decompiled with CFR 0.152.
 */
package com.borland.dbswing;

import com.borland.dbswing.DBExceptionDialog;
import com.borland.dbswing.DBUtilities;
import com.borland.dbswing.Res;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.DataSetException;
import com.borland.dx.dataset.Designable;
import com.borland.dx.dataset.ExceptionEvent;
import com.borland.dx.dataset.MatrixData;
import java.awt.Component;
import java.io.Serializable;

public class DBExceptionHandler
implements Designable,
Serializable {
    static DBExceptionDialog errorDialog;
    private static DBExceptionHandler handler;
    private static boolean displayChains;
    private static boolean displayStack;
    private static boolean allowExit;
    private static boolean closeDataStores;
    private static boolean closeConnections;
    private static boolean enableSecretKey;

    public static DBExceptionHandler getInstance() {
        if (handler == null) {
            handler = new DBExceptionHandler();
        }
        return handler;
    }

    public void setDisplayChainedExceptions(boolean displayChains) {
        DBExceptionHandler.displayChains = displayChains;
    }

    public boolean isDisplayChainedExceptions() {
        return displayChains;
    }

    public void setDisplayStackTraces(boolean displayStack) {
        DBExceptionHandler.displayStack = displayStack;
    }

    public boolean isDisplayStackTraces() {
        return displayStack;
    }

    public void setAllowExit(boolean allowExit) {
        DBExceptionHandler.allowExit = allowExit;
    }

    public boolean isAllowExit() {
        return allowExit;
    }

    public void setCloseDataStoresOnExit(boolean closeDataStores) {
        DBExceptionHandler.closeDataStores = closeDataStores;
    }

    public boolean isCloseDataStoresOnExit() {
        return closeDataStores;
    }

    public void setCloseConnectionsOnExit(boolean closeConnections) {
        DBExceptionHandler.closeConnections = closeConnections;
    }

    public boolean isCloseConnectionsOnExit() {
        return closeConnections;
    }

    public void setEnableSecretDebugKey(boolean enableSecretKey) {
        DBExceptionHandler.enableSecretKey = enableSecretKey;
    }

    public boolean isEnableSecretDebugKey() {
        return enableSecretKey;
    }

    public static final void handleException(DataSet dataSet, Component component, Throwable ex, boolean modal) {
        if (DataSetException.getExceptionListeners() != null) {
            DataSetException.getExceptionListeners().dispatch(new ExceptionEvent(dataSet, component, ex));
        } else if (!(dataSet != null && !MatrixData.displayError(dataSet, ex) || errorDialog != null && errorDialog.isVisible())) {
            if (errorDialog != null) {
                errorDialog.dispose();
            }
            errorDialog = new DBExceptionDialog(component != null ? DBUtilities.getFrame(component) : null, Res._Error, ex, modal, component);
            errorDialog.setDisplayChainedExceptions(displayChains);
            errorDialog.setDisplayStackTraces(displayStack);
            errorDialog.setAllowExit(allowExit);
            errorDialog.setCloseDataStoresOnExit(closeDataStores);
            errorDialog.setCloseConnectionsOnExit(closeConnections);
            errorDialog.setEnableSecretDebugKey(enableSecretKey);
            errorDialog.show();
        }
    }

    void showDialog() {
        errorDialog.show();
    }

    public static final void handleException(DataSet dataSet, Component component, Exception ex) {
        DBExceptionHandler.handleException(dataSet, component, ex, true);
    }

    public static final void handleException(DataSet dataSet, Exception ex) {
        DBExceptionHandler.handleException(dataSet, null, ex, true);
    }

    public static final void handleException(Exception ex) {
        DBExceptionHandler.handleException(null, null, ex);
    }

    static {
        displayChains = true;
        displayStack = true;
        allowExit = false;
        closeDataStores = true;
        closeConnections = true;
        enableSecretKey = true;
    }
}

