/*
 * Decompiled with CFR 0.152.
 */
package com.borland.dbswing;

import com.borland.dbswing.DBExceptionHandler;
import com.borland.dbswing.DBTableModel;
import com.borland.dbswing.DBUtilities;
import com.borland.dbswing.Res;
import com.borland.dbswing.plaf.metal.MetalJdbComboBoxUI;
import com.borland.dbswing.plaf.motif.MotifJdbComboBoxUI;
import com.borland.dbswing.plaf.windows.WindowsJdbComboBoxUI;
import com.borland.dx.dataset.AccessEvent;
import com.borland.dx.dataset.AccessListener;
import com.borland.dx.dataset.Column;
import com.borland.dx.dataset.ColumnAware;
import com.borland.dx.dataset.DataChangeEvent;
import com.borland.dx.dataset.DataChangeListener;
import com.borland.dx.dataset.DataRow;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.DataSetException;
import com.borland.dx.dataset.DataSetView;
import com.borland.dx.dataset.NavigationEvent;
import com.borland.dx.dataset.NavigationListener;
import com.borland.dx.dataset.PickListDescriptor;
import com.borland.dx.dataset.ReadRow;
import com.borland.dx.dataset.ValidationException;
import com.borland.dx.dataset.Variant;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.plaf.UIResource;

public class JdbComboBox
extends JComboBox
implements NavigationListener,
AccessListener,
ItemListener,
PropertyChangeListener,
DataChangeListener,
ColumnAware,
Serializable,
FocusListener {
    private DataSet dataSet;
    private Column column;
    private String columnName;
    private Object[] items;
    private DBComboBoxModel dbComboBoxModel;
    private boolean ignoreModelChange;
    private boolean addNotifyCalled;
    private int dropDownWidth = -1;
    private int cellHeight = -1;
    private boolean rebindColumnProperties;
    private DataSetView pickListView;
    private String[] sourceColumns;
    private String[] targetColumns;
    private boolean rebuildPickListView = true;
    private DataRow pickListLocateRow;
    private DataRow selectionLocateRow;
    private boolean ignoreValueChange;
    private boolean dataSetEventsEnabled = true;
    private boolean pickListDataSetEventsEnabled = true;
    static /* synthetic */ Class class$javax$swing$event$ListDataListener;

    public JdbComboBox() {
        this.commonInit();
    }

    public JdbComboBox(Vector items) {
        super(items);
        this.commonInit();
    }

    public JdbComboBox(Object[] items) {
        super(items);
        this.commonInit();
    }

    public JdbComboBox(ComboBoxModel model) {
        super(model);
        this.commonInit();
    }

    protected void commonInit() {
        this.addPropertyChangeListener(this);
    }

    public void updateUI() {
        String currentLookAndFeel = UIManager.getLookAndFeel().getID();
        if (currentLookAndFeel.equals("Motif")) {
            this.setUI(MotifJdbComboBoxUI.createUI(this));
        } else if (currentLookAndFeel.equals("Metal")) {
            this.setUI(MetalJdbComboBoxUI.createUI(this));
        } else {
            this.setUI(WindowsJdbComboBoxUI.createUI(this));
        }
    }

    public synchronized void setItems(String[] items) {
        this.setItems((Object[])items);
    }

    public synchronized void setItems(Object[] items) {
        this.items = items;
        if (items == null || items.length == 0) {
            this.setModel(new DefaultComboBoxModel());
        } else {
            this.setModel(new DefaultComboBoxModel<Object>(items));
        }
        this.setSelectedItem(items == null || items.length == 0 ? null : items[0]);
    }

    public synchronized String[] getItems() {
        if (this.items == null) {
            return new String[0];
        }
        String[] stringifiedItems = new String[this.getModel().getSize()];
        for (int i2 = 0; i2 < stringifiedItems.length; ++i2) {
            Object element = this.getModel().getElementAt(i2);
            stringifiedItems[i2] = element == null ? "" : element.toString();
        }
        return stringifiedItems;
    }

    public void setSelectedIndex(int selectedIndex) {
        if (this.getModel() instanceof DBComboBoxModel) {
            ((DBComboBoxModel)this.getModel()).setSelectedIndex(selectedIndex);
        } else {
            super.setSelectedIndex(selectedIndex);
        }
    }

    public int getSelectedIndex() {
        if (this.getModel() instanceof DBComboBoxModel) {
            return ((DBComboBoxModel)this.getModel()).getSelectedIndex();
        }
        return super.getSelectedIndex();
    }

    public void setDataSet(DataSet dataSet) {
        if (this.dataSet != null) {
            this.dataSet.removeAccessListener(this);
            this.dataSet.removeDataChangeListener(this);
            this.dataSet.removeNavigationListener(this);
            this.removeItemListener(this);
            this.removeFocusListener(this);
        }
        this.dataSet = dataSet;
        if (dataSet != null) {
            dataSet.addAccessListener(this);
            dataSet.addDataChangeListener(this);
            dataSet.addNavigationListener(this);
            this.addItemListener(this);
            this.addFocusListener(this);
        }
        if (this.getModel() instanceof DBComboBoxModel) {
            ((DBComboBoxModel)this.getModel()).setDataSet(dataSet);
        }
        this.openDataSet();
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
        this.openDataSet();
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setDropDownWidth(int dropDownWidth) {
        int oldWidth = this.dropDownWidth;
        this.dropDownWidth = dropDownWidth;
        this.firePropertyChange("dropDownWidth", oldWidth, dropDownWidth);
    }

    public int getDropDownWidth() {
        return this.dropDownWidth;
    }

    public void setFixedCellHeight(int cellHeight) {
        int oldCellHeight = this.cellHeight;
        this.cellHeight = cellHeight;
        this.firePropertyChange("fixedCellHeight", oldCellHeight, cellHeight);
    }

    public int getFixedCellHeight() {
        return this.cellHeight;
    }

    public void itemStateChanged(ItemEvent e2) {
        block7: {
            Column column;
            block8: {
                if (e2.getStateChange() != 1) break block7;
                if (!(this.getModel() instanceof DBComboBoxModel)) break block8;
                this.updateSelectedItem();
                break block7;
            }
            if (this.dataSet == null || !this.dataSet.isOpen() || (column = this.dataSet.hasColumn(this.columnName)) == null) break block7;
            Object item = this.getSelectedItem();
            Variant value = new Variant();
            try {
                if (item != null) {
                    if (item instanceof String) {
                        column.getFormatter().parse((String)item, value);
                    } else {
                        value.setAsObject(item, column.getDataType());
                    }
                } else {
                    value.setAssignedNull();
                }
                if (!this.ignoreValueChange) {
                    this.dataSet.setDisplayVariant(column.getOrdinal(), value);
                }
            }
            catch (Exception ex) {
                DBExceptionHandler.handleException(this.dataSet, this, ex);
            }
        }
    }

    public void focusGained(FocusEvent e2) {
        DBUtilities.updateCurrentDataSet(this, this.dataSet);
    }

    public void focusLost(FocusEvent e2) {
    }

    public void contentsChanged(ListDataEvent e2) {
        block9: {
            block8: {
                if (!DBUtilities.islpt4()) break block8;
                super.contentsChanged(e2);
                break block9;
            }
            ComboBoxModel mod = this.getModel();
            Object newSelectedItem = mod.getSelectedItem();
            if (this.selectedItemReminder == null) {
                if (newSelectedItem != null) {
                    this.selectedItemChanged();
                }
            } else if (!this.selectedItemReminder.equals(newSelectedItem)) {
                this.selectedItemChanged();
            }
            if (this.isEditable() || newSelectedItem == null) break block9;
            boolean shouldResetSelectedItem = true;
            Object selectedItem = mod.getSelectedItem();
            int c2 = mod.getSize();
            for (int i2 = 0; i2 < c2; ++i2) {
                Object o2 = mod.getElementAt(i2);
                if (o2 == null || !o2.equals(selectedItem)) continue;
                shouldResetSelectedItem = false;
                break;
            }
            if (shouldResetSelectedItem) {
                if (mod.getSize() > 0) {
                    this.setSelectedIndex(0);
                } else {
                    this.setSelectedItem(null);
                }
            }
        }
    }

    public void addNotify() {
        super.addNotify();
        if (!this.addNotifyCalled) {
            this.addNotifyCalled = true;
            this.openDataSet();
        }
    }

    private void openDataSet() {
        if (this.addNotifyCalled && this.dataSet != null && this.columnName != null) {
            if (!this.dataSet.isOpen()) {
                try {
                    this.dataSet.open();
                }
                catch (DataSetException ex) {
                    DBExceptionHandler.handleException(this.dataSet, this, ex);
                    return;
                }
            } else {
                this.bindColumnProperties();
            }
        }
    }

    public void accessChange(AccessEvent event) {
        if (event.getSource() == this.dataSet) {
            if (event.getID() == 2) {
                if (event.getReason() == 8) {
                    this.dataSetEventsEnabled = false;
                    return;
                }
                if (event.getReason() == 9) {
                    this.rebindColumnProperties = true;
                }
            } else {
                this.dataSetEventsEnabled = true;
                if (event.getReason() == 1 || this.rebindColumnProperties || event.getReason() == 2) {
                    this.bindColumnProperties();
                }
            }
        } else if (event.getSource() == this.pickListView) {
            if (event.getID() == 2) {
                this.rebuildPickListView = true;
                if (event.getReason() == 9) {
                    this.rebuildPickListView = false;
                }
                if (event.getReason() == 8) {
                    this.pickListDataSetEventsEnabled = false;
                    return;
                }
            } else {
                this.pickListDataSetEventsEnabled = true;
                if (this.rebuildPickListView) {
                    this.rebuildPickListView = false;
                    this.ignoreValueChange = true;
                    this.setPickListModel(this.pickListView);
                    this.ignoreValueChange = false;
                }
            }
        }
    }

    private boolean isDefaultProperty(Object property) {
        return property == null || property instanceof UIResource;
    }

    private void bindColumnProperties() {
        if (this.isDisplayable()) {
            if (this.dataSet != null && this.dataSet.isOpen() && (this.column = this.dataSet.hasColumn(this.columnName)) != null) {
                if (this.isDefaultProperty(this.getBackground()) && this.column.getBackground() != null) {
                    this.setBackground(this.column.getBackground());
                }
                if (this.isDefaultProperty(this.getForeground()) && this.column.getForeground() != null) {
                    this.setForeground(this.column.getForeground());
                }
                if (this.isDefaultProperty(this.getFont()) && this.column.getFont() != null) {
                    this.setFont(this.column.getFont());
                }
                PickListDescriptor pickList = this.column.getPickList();
                if (this.items == null && pickList != null) {
                    DataSet pickListDataSet = pickList.getPickListDataSet();
                    if (pickListDataSet != null) {
                        try {
                            if (!pickListDataSet.isOpen()) {
                                pickListDataSet.open();
                            }
                            this.ignoreValueChange = true;
                            this.setPickListModel(pickListDataSet.cloneDataSetView());
                            this.ignoreValueChange = false;
                        }
                        catch (DataSetException e2) {
                            DBExceptionHandler.handleException(pickListDataSet, this, e2);
                            this.setPickListModel(null);
                        }
                    }
                } else if (this.cellHeight == -1 && this.column.getDataType() == 16) {
                    FontMetrics fontMetrics = this.getGraphics().getFontMetrics(this.getFont());
                    this.setFixedCellHeight(fontMetrics.getHeight());
                }
                if (this.isEnabled() && !this.column.isEditable()) {
                    this.setEnabled(false);
                }
                this.rebindColumnProperties = false;
            }
            this.updateSelectedItem();
        }
    }

    private void setPickListModel(DataSetView pickListView) {
        block11: {
            Graphics g2;
            PickListDescriptor pickList;
            Column pickListColumn;
            if (this.pickListView != null) {
                this.pickListView.removeAccessListener(this);
                if (this.pickListView != pickListView) {
                    try {
                        this.pickListView.close();
                    }
                    catch (DataSetException e2) {
                        DBExceptionHandler.handleException(this.pickListView, this, e2);
                    }
                }
                if (this.dbComboBoxModel != null) {
                    this.dbComboBoxModel.setDataSet(null);
                    this.dbComboBoxModel.setPickListDescriptor(null);
                    this.pickListLocateRow = null;
                    this.selectionLocateRow = null;
                }
            }
            this.pickListView = pickListView;
            if (this.dataSet == null || !this.dataSet.isOpen() || (pickListColumn = this.dataSet.hasColumn(this.columnName)) == null || pickListColumn == null || (pickList = pickListColumn.getPickList()) == null || pickListView == null) break block11;
            pickListView.addAccessListener(this);
            this.dbComboBoxModel = new DBComboBoxModel();
            this.dbComboBoxModel.setDataSet(pickListView);
            this.dbComboBoxModel.setPickListDescriptor(pickList);
            String[] displayColumns = pickList.getPickListDisplayColumns();
            this.sourceColumns = pickList.getPickListColumns();
            this.targetColumns = pickList.getDestinationColumns();
            String lookupColumnName = pickList.getLookupDisplayColumn();
            Column lookupColumn = null;
            if (lookupColumnName != null && (lookupColumn = pickListView.hasColumn(lookupColumnName)) != null) {
                int modelIndex = -1;
                int maxCols = this.dbComboBoxModel.getColumnCount();
                for (int colNo = 0; colNo < maxCols; ++colNo) {
                    if (!this.dbComboBoxModel.getColumn(colNo).getColumnName().equalsIgnoreCase(lookupColumnName)) continue;
                    modelIndex = colNo;
                    break;
                }
                this.dbComboBoxModel.setModelColumnIndex(modelIndex);
            } else if (this.sourceColumns.length > 0 && (this.column = pickListView.hasColumn(this.sourceColumns[0])) != null) {
                this.dbComboBoxModel.setModelColumnIndex(this.column.getOrdinal());
            }
            if (lookupColumn == null) {
                lookupColumn = this.column;
            }
            if (this.cellHeight == -1 && lookupColumn.getDataType() == 16 && (g2 = this.getGraphics()) != null) {
                FontMetrics fontMetrics = g2.getFontMetrics(this.getFont());
                this.setFixedCellHeight(fontMetrics.getHeight());
            }
            this.ignoreModelChange = true;
            this.setModel(this.dbComboBoxModel);
            this.ignoreModelChange = false;
        }
    }

    public void navigated(NavigationEvent e2) {
        if (!this.dataSetEventsEnabled) {
            return;
        }
        this.updateSelectedItem();
    }

    protected void updateSelectedItem() {
        Variant value;
        int newIndex = -1;
        this.ignoreValueChange = true;
        if (this.getModel() instanceof DBComboBoxModel) {
            try {
                if (this.pickListLocateRow == null) {
                    this.pickListLocateRow = new DataRow((DataSet)this.pickListView, this.sourceColumns);
                }
                ReadRow.copyTo(this.targetColumns, this.dataSet, this.sourceColumns, this.pickListLocateRow);
                if (this.pickListView.locate(this.pickListLocateRow, 32)) {
                    newIndex = this.pickListView.getRow();
                }
            }
            catch (DataSetException ex) {
                DBExceptionHandler.handleException(this.pickListView, ex);
            }
        } else {
            int lastRow = this.getModel().getSize();
            value = new Variant();
            try {
                this.dataSet.getVariant(this.columnName, this.dataSet.getRow(), value);
            }
            catch (DataSetException ex) {
                DBExceptionHandler.handleException(this.pickListView, ex);
            }
            Object locateValue = value.getAsObject();
            for (int index = 0; index < lastRow; ++index) {
                if (!this.getModel().getElementAt(index).equals(locateValue)) continue;
                newIndex = index;
                break;
            }
        }
        this.ignoreValueChange = true;
        if (newIndex == -1) {
            Column column = this.dataSet.hasColumn(this.columnName);
            if (column != null) {
                value = new Variant();
                try {
                    this.dataSet.getDisplayVariant(column.getOrdinal(), this.dataSet.getRow(), value);
                }
                catch (DataSetException ex) {
                    DBExceptionHandler.handleException(this.dataSet, ex);
                }
                this.setSelectedItem(value.getAsObject());
            } else {
                this.setSelectedItem(null);
            }
        } else {
            this.setSelectedIndex(newIndex);
        }
        this.ignoreValueChange = false;
    }

    public void dataChanged(DataChangeEvent event) {
        int affectedRow;
        if (!this.dataSetEventsEnabled) {
            return;
        }
        int currentRow = this.dataSet.getRow();
        if (currentRow == (affectedRow = event.getRowAffected())) {
            this.updateSelectedItem();
        }
    }

    public void postRow(DataChangeEvent event) throws Exception {
    }

    public void propertyChange(PropertyChangeEvent e2) {
        if (e2.getPropertyName().equals("model") && !this.ignoreModelChange && e2.getOldValue() != null && e2.getOldValue() instanceof DBComboBoxModel) {
            this.setPickListModel(null);
        }
    }

    static Class class$(String x$0) {
        try {
            return Class.forName(x$0);
        }
        catch (ClassNotFoundException x$02) {
            throw new NoClassDefFoundError(x$02.getMessage());
        }
    }

    public class DBComboBoxModel
    extends DBTableModel
    implements ComboBoxModel {
        protected EventListenerList listenerList = new EventListenerList();
        private Object selectedItem;
        private int selectedIndex = -1;
        private int modelColumnIndex = -1;
        private PickListDescriptor pickListDescriptor;

        public DBComboBoxModel() {
        }

        public DBComboBoxModel(DataSet dataSet) {
            super(dataSet);
        }

        public void setSelectedItem(Object selectedItem) {
            this.selectedItem = selectedItem;
            this.selectedIndex = -1;
            if (selectedItem != null && this.isValidDataSetState()) {
                Variant selectedVariantItem = null;
                if (selectedItem instanceof Variant) {
                    selectedVariantItem = (Variant)selectedItem;
                } else {
                    Variant variant = new Variant();
                    try {
                        if (selectedItem instanceof String) {
                            variant.setFromString(this.getColumn(this.modelColumnIndex).getDataType(), (String)selectedItem);
                        } else {
                            variant.setAsObject(selectedItem, this.getColumn(this.modelColumnIndex).getDataType());
                        }
                    }
                    catch (Exception e2) {
                        try {
                            ValidationException.invalidFormat(e2, this.getColumn(this.modelColumnIndex).getColumnName(), Res._InvalidSelectedItem);
                        }
                        catch (ValidationException ex) {
                            DBExceptionHandler.handleException(this.dataSet, ex);
                            return;
                        }
                    }
                    selectedVariantItem = variant;
                }
                try {
                    if (JdbComboBox.this.selectionLocateRow == null) {
                        JdbComboBox.this.selectionLocateRow = new DataRow(this.dataSet, this.getColumn(this.modelColumnIndex).getColumnName());
                    }
                    JdbComboBox.this.selectionLocateRow.setVariant(this.getColumn(this.modelColumnIndex).getColumnName(), selectedVariantItem);
                    if (!this.dataSet.locate(JdbComboBox.this.selectionLocateRow, 32)) {
                        this.selectedIndex = -1;
                        JOptionPane.showMessageDialog(null, Res._NavLocateFailed, null, 1);
                        return;
                    }
                    this.selectedIndex = this.dataSet.getRow();
                    if (!JdbComboBox.this.ignoreValueChange) {
                        ReadRow.copyTo(JdbComboBox.this.sourceColumns, JdbComboBox.this.pickListView, JdbComboBox.this.targetColumns, JdbComboBox.this.dataSet);
                    }
                }
                catch (DataSetException e3) {
                    DBExceptionHandler.handleException(this.dataSet, e3);
                }
            }
            this.fireContentsChanged(this, -1, -1);
        }

        public Object getSelectedItem() {
            return this.selectedItem;
        }

        public void setSelectedIndex(int selectedIndex) {
            this.selectedItem = null;
            this.selectedIndex = selectedIndex;
            if (this.isValidDataSetState()) {
                block6: {
                    if (selectedIndex == -1) {
                        return;
                    }
                    try {
                        if (this.dataSet.goToRow(selectedIndex)) {
                            if (!JdbComboBox.this.ignoreValueChange) {
                                this.selectedItem = this.getElementAt(selectedIndex);
                                ReadRow.copyTo(JdbComboBox.this.sourceColumns, JdbComboBox.this.pickListView, JdbComboBox.this.targetColumns, JdbComboBox.this.dataSet);
                            }
                            break block6;
                        }
                        this.selectedIndex = -1;
                        JOptionPane.showMessageDialog(null, Res._PickListGoToFailed, null, 1);
                        return;
                    }
                    catch (DataSetException e2) {
                        this.selectedIndex = -1;
                        this.selectedItem = null;
                        DBExceptionHandler.handleException(this.dataSet, e2);
                        return;
                    }
                }
                this.selectedItem = this.getElementAt(selectedIndex);
            }
            this.fireContentsChanged(this, -1, -1);
        }

        public int getSelectedIndex() {
            return this.selectedIndex;
        }

        public int getSize() {
            return this.getRowCount();
        }

        public Object getElementAt(int index) {
            if (this.modelColumnIndex == -1) {
                Variant value = new Variant();
                try {
                    JdbComboBox.this.dataSet.getDisplayVariant(JdbComboBox.this.column.getOrdinal(), JdbComboBox.this.dataSet.getRow(), value);
                    Object object = value.getAsObject();
                    return object;
                }
                catch (DataSetException ex) {
                    DBExceptionHandler.handleException(JdbComboBox.this.dataSet, ex);
                    return null;
                }
            }
            return this.getValueAt(index, this.modelColumnIndex);
        }

        public void setModelColumnIndex(int modelColumnIndex) {
            this.modelColumnIndex = modelColumnIndex;
        }

        public int getModelColumnIndex() {
            return this.modelColumnIndex;
        }

        public Column getColumn(int columnIndex) {
            if (columnIndex == -1) {
                return JdbComboBox.this.column;
            }
            return super.getColumn(columnIndex);
        }

        public void setPickListDescriptor(PickListDescriptor pickListDescriptor) {
            this.pickListDescriptor = pickListDescriptor;
        }

        public PickListDescriptor getPickListDescriptor() {
            return this.pickListDescriptor;
        }

        public void accessChange(AccessEvent event) {
            super.accessChange(event);
            if (event.getID() == 1) {
                JdbComboBox.this.pickListDataSetEventsEnabled = true;
                Object oldSelectedItem = this.selectedItem;
                int oldIndex = this.selectedIndex;
                this.setSelectedItem(null);
                this.fireContentsChanged(this, 0, this.getSize() - 1);
                if (oldSelectedItem != null && oldIndex == -1) {
                    this.setSelectedItem(oldSelectedItem);
                } else if (oldSelectedItem == null && oldIndex != -1) {
                    this.setSelectedIndex(oldIndex);
                }
            } else {
                if (event.getReason() == 8) {
                    JdbComboBox.this.pickListDataSetEventsEnabled = false;
                    return;
                }
                if (event.getReason() != 9) {
                    this.setSelectedItem(null);
                    this.fireContentsChanged(this, 0, this.getSize() - 1);
                }
            }
        }

        public void dataChanged(DataChangeEvent e2) {
            if (!JdbComboBox.this.pickListDataSetEventsEnabled) {
                return;
            }
            JdbComboBox.this.ignoreValueChange = true;
            super.dataChanged(e2);
            if (e2.multiRowChange()) {
                this.fireContentsChanged(this, 0, this.getSize() - 1);
            } else {
                int row = e2.getRowAffected();
                switch (e2.getID()) {
                    case 1: {
                        this.fireIntervalAdded(this, row, row);
                        break;
                    }
                    case 2: {
                        this.fireIntervalRemoved(this, row, row);
                        break;
                    }
                    case 3: {
                        this.fireContentsChanged(this, row, row);
                        break;
                    }
                    default: {
                        this.fireContentsChanged(this, 0, this.getSize() - 1);
                    }
                }
            }
            JdbComboBox.this.ignoreValueChange = false;
        }

        public void addListDataListener(ListDataListener l2) {
            this.listenerList.add(class$javax$swing$event$ListDataListener == null ? (class$javax$swing$event$ListDataListener = JdbComboBox.class$("javax.swing.event.ListDataListener")) : class$javax$swing$event$ListDataListener, l2);
        }

        public void removeListDataListener(ListDataListener l2) {
            this.listenerList.remove(class$javax$swing$event$ListDataListener == null ? (class$javax$swing$event$ListDataListener = JdbComboBox.class$("javax.swing.event.ListDataListener")) : class$javax$swing$event$ListDataListener, l2);
        }

        protected void fireContentsChanged(Object source, int index0, int index1) {
            Object[] listeners = this.listenerList.getListenerList();
            ListDataEvent e2 = null;
            for (int i2 = listeners.length - 2; i2 >= 0; i2 -= 2) {
                if (listeners[i2] != (class$javax$swing$event$ListDataListener == null ? JdbComboBox.class$("javax.swing.event.ListDataListener") : class$javax$swing$event$ListDataListener)) continue;
                if (e2 == null) {
                    e2 = new ListDataEvent(this, 0, index0, index1);
                }
                ((ListDataListener)listeners[i2 + 1]).contentsChanged(e2);
            }
        }

        protected void fireIntervalAdded(Object source, int index0, int index1) {
            Object[] listeners = this.listenerList.getListenerList();
            ListDataEvent e2 = null;
            for (int i2 = listeners.length - 2; i2 >= 0; i2 -= 2) {
                if (listeners[i2] != (class$javax$swing$event$ListDataListener == null ? JdbComboBox.class$("javax.swing.event.ListDataListener") : class$javax$swing$event$ListDataListener)) continue;
                if (e2 == null) {
                    e2 = new ListDataEvent(this, 1, index0, index1);
                }
                ((ListDataListener)listeners[i2 + 1]).intervalAdded(e2);
            }
        }

        protected void fireIntervalRemoved(Object source, int index0, int index1) {
            Object[] listeners = this.listenerList.getListenerList();
            ListDataEvent e2 = null;
            for (int i2 = listeners.length - 2; i2 >= 0; i2 -= 2) {
                if (listeners[i2] != (class$javax$swing$event$ListDataListener == null ? JdbComboBox.class$("javax.swing.event.ListDataListener") : class$javax$swing$event$ListDataListener)) continue;
                if (e2 == null) {
                    e2 = new ListDataEvent(this, 2, index0, index1);
                }
                ((ListDataListener)listeners[i2 + 1]).intervalRemoved(e2);
            }
        }
    }
}

