/*
 * Decompiled with CFR 0.152.
 */
package edu.iastate.anthill.indus.tree;

import edu.iastate.anthill.indus.tree.TypedNode;
import edu.iastate.anthill.indus.tree.TypedTree;
import edu.iastate.utils.undo.EditingAction;

public class TreeNodeMoveEditing
extends EditingAction {
    TypedTree tree;
    TypedNode oldParent;
    TypedNode newParent;

    public TreeNodeMoveEditing(TypedTree tree, TypedNode location, TypedNode oldParent, TypedNode newParent) {
        this.tree = tree;
        this.location = location;
        this.oldParent = oldParent;
        this.newParent = newParent;
        this.summary = "Move node '" + location + "' from '" + oldParent + "' to '" + newParent + "'";
    }

    public void undo() {
        if (this.newParent.isNodeChild((TypedNode)this.location)) {
            this.tree.getModel().removeNodeFromParent((TypedNode)this.location);
        }
        this.tree.getModel().insertNodeInto((TypedNode)this.location, this.oldParent, this.oldParent.getChildCount());
        this.tree.expandNode((TypedNode)this.location);
    }

    public void redo() {
        if (this.oldParent.isNodeChild((TypedNode)this.location)) {
            this.tree.getModel().removeNodeFromParent((TypedNode)this.location);
        }
        this.tree.getModel().insertNodeInto((TypedNode)this.location, this.newParent, this.newParent.getChildCount());
        this.tree.expandNode((TypedNode)this.location);
    }
}

