/*
 * Decompiled with CFR 0.152.
 */
package edu.iastate.anthill.indus.tree;

import edu.iastate.anthill.indus.tree.TypedNode;
import edu.iastate.anthill.indus.tree.TypedTree;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.tree.TreePath;

public abstract class TreePopupMenuListener
extends MouseAdapter {
    public JPanel fatherPanel;
    public JPopupMenu popup = new JPopupMenu();
    public TypedTree tree;

    protected void addMenuItem(String text, Icon icon, ActionListener listener, JPopupMenu menu, String shortKey) {
        JMenuItem jMenuItem = icon == null ? new JMenuItem(text) : new JMenuItem(text, icon);
        jMenuItem.addActionListener(listener);
        if (shortKey != null) {
            jMenuItem.setAccelerator(KeyStroke.getKeyStroke(shortKey));
        }
        menu.add(jMenuItem);
    }

    protected void addMenuItem(String text, ActionListener listener) {
        this.addMenuItem(text, null, listener, this.popup, null);
    }

    protected void addMenuItem(String text, Icon icon, ActionListener listener) {
        this.addMenuItem(text, icon, listener, this.popup, null);
    }

    public void mouseReleased(MouseEvent e2) {
        this.showMenu(e2);
    }

    public void showMenu(MouseEvent e2) {
        TreePath selPath = this.tree.getPathForLocation(e2.getX(), e2.getY());
        if (e2.isPopupTrigger() && selPath != null) {
            this.tree.setSelectionPath(selPath);
            TypedNode selectedNode = (TypedNode)selPath.getLastPathComponent();
            boolean showpopup = false;
            this.popup = new JPopupMenu();
            this.buildContextMenu(selectedNode);
            showpopup = true;
            if (showpopup) {
                this.popup.show(e2.getComponent(), e2.getX(), e2.getY());
            }
        }
    }

    protected abstract void buildContextMenu(TypedNode var1);
}

