/*
 * Decompiled with CFR 0.152.
 */
package edu.iastate.anthill.indus.tree;

import edu.iastate.anthill.indus.tree.TypedNode;
import edu.iastate.utils.gui.JTreeEx;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

public class TypedTree
extends JTreeEx {
    public TypedTree(DefaultTreeModel model) {
        super(model);
    }

    public TypedTree() {
    }

    public TypedTree(TypedNode top) {
        super(top);
        this.setTop(top);
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean toHTML) {
        String crlf;
        String endline = "|---";
        String line = toHTML ? "|&nbsp;&nbsp;&nbsp;" : "|   ";
        String string = crlf = toHTML ? "<BR></BR>" : "\n";
        if (this.getTop() == null) {
            return "";
        }
        String toPrint = "";
        Enumeration<TreeNode> e2 = this.getTop().preorderEnumeration();
        while (e2.hasMoreElements()) {
            DefaultMutableTreeNode nn = (DefaultMutableTreeNode)e2.nextElement();
            String leading = line;
            if (nn.getLevel() == 0) {
                leading = "";
            } else if (nn.getLevel() == 1) {
                leading = endline;
            } else {
                leading = endline;
                for (int i2 = 0; i2 < nn.getLevel() - 1; ++i2) {
                    leading = line + leading;
                }
            }
            toPrint = toPrint + leading + nn + crlf;
        }
        if (toHTML) {
            return toPrint;
        }
        return toPrint;
    }

    public void setTop(TypedNode top) {
        this.getModel().setRoot(top);
    }

    public TypedNode getTop() {
        return (TypedNode)this.getModel().getRoot();
    }

    public void buildSampleTree() {
        TypedNode top = new TypedNode("http://semanticWWW.com/indus.owl#USA");
        TypedNode iowa = new TypedNode("http://semanticWWW.com/indus.owl#Iowa");
        top.add(iowa);
        iowa.add(new TypedNode("http://semanticWWW.com/indus.owl#Ames"));
        iowa.add(new TypedNode("http://semanticWWW.com/indus.owl#DesMoines"));
        TypedNode va = new TypedNode("http://semanticWWW.com/indus.owl#Virginia");
        top.add(va);
        va.add(new TypedNode("http://semanticWWW.com/indus.owl#Richmond"));
        va.add(new TypedNode("http://semanticWWW.com/indus.owl#Petersberg"));
        this.setTop(top);
    }

    public static TypedNode amendNode(TypedTree tree, TypedNode node, TypedNode newNode) {
        try {
            DefaultTreeModel model = tree.getModel();
            Vector<Object> oldSons = new Vector<Object>();
            int oldSonCount = node.getChildCount();
            for (int j2 = 0; j2 < oldSonCount; ++j2) {
                TypedNode son = (TypedNode)node.getChildAt(j2);
                oldSons.add(son.getUserObject());
            }
            Vector<TreeNode> newSons = new Vector<TreeNode>();
            Enumeration<TreeNode> e2 = newNode.children();
            while (e2.hasMoreElements()) {
                newSons.add(e2.nextElement());
            }
            e2 = newSons.elements();
            while (e2.hasMoreElements()) {
                TypedNode kid = (TypedNode)e2.nextElement();
                System.out.println(kid);
                if (oldSons.contains(kid.getUserObject())) continue;
                model.insertNodeInto(kid, node, node.getChildCount());
            }
            node.setUserObject(newNode.getUserObject());
            node.setComment(newNode.getComment());
            return node;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) {
        TypedTree t2 = new TypedTree();
        t2.buildSampleTree();
        JFrame frame = new JFrame();
        frame.setSize(800, 600);
        JEditorPane pane = new JEditorPane();
        frame.getContentPane().add(new JScrollPane(pane));
        pane.setContentType("text/html");
        pane.setText(t2.toString(true));
        frame.setVisible(true);
    }
}

