/*
 * Decompiled with CFR 0.152.
 */
package edu.iastate.anthill.indus.tree;

import edu.iastate.anthill.indus.tree.TreeNodeCommentEditing;
import edu.iastate.anthill.indus.tree.TreeNodeDeleteEditing;
import edu.iastate.anthill.indus.tree.TreeNodeInsertEditing;
import edu.iastate.anthill.indus.tree.TreeNodeMoveEditing;
import edu.iastate.anthill.indus.tree.TreeNodeRenameEditing;
import edu.iastate.anthill.indus.tree.TreePopupMenuListener;
import edu.iastate.anthill.indus.tree.TypedNode;
import edu.iastate.anthill.indus.tree.TypedTree;
import edu.iastate.utils.undo.BulkEditingAction;
import edu.iastate.utils.undo.EditingAction;
import edu.iastate.utils.undo.UndoRedoStack;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultTreeModel;

public abstract class TypedTreeEditor
extends TreePopupMenuListener {
    public UndoRedoStack history = new UndoRedoStack();

    protected void updateTree() {
        this.tree.repaint();
    }

    protected abstract void changed(TypedNode var1);

    protected void deleteAllChildren(TypedNode theNode) {
        DefaultTreeModel model = this.tree.getModel();
        int child = theNode.getChildCount();
        BulkEditingAction bulk = new BulkEditingAction(theNode);
        bulk.summary = "Delete all children of '" + theNode + "'";
        for (int i2 = 0; i2 < child; ++i2) {
            TypedNode kid = (TypedNode)theNode.getChildAt(0);
            model.removeNodeFromParent(kid);
            TreeNodeDeleteEditing action = new TreeNodeDeleteEditing(this.tree, kid, theNode);
            bulk.addAction(action);
        }
        this.history.addAction(bulk);
        this.changed(theNode);
    }

    protected void delete(TypedNode theNode) {
        TypedNode parent = (TypedNode)theNode.getParent();
        if (parent != null) {
            this.tree.getModel().removeNodeFromParent(theNode);
            this.changed(theNode);
            this.changed(parent);
            TreeNodeDeleteEditing action = new TreeNodeDeleteEditing(this.tree, theNode, parent);
            this.history.addAction(action);
        }
    }

    public void undo() {
        if (this.history.canUndo()) {
            EditingAction action = this.history.undo();
            this.changed((TypedNode)action.location);
        }
    }

    public void redo() {
        if (this.history.canRedo()) {
            EditingAction action = this.history.redo();
            this.changed((TypedNode)action.location);
        }
    }

    public void addHistory(EditingAction action) {
        this.history.addAction(action);
    }

    protected abstract class DeafultCreateSubValueAction
    implements ActionListener {
        public TypedNode parent;

        public DeafultCreateSubValueAction(TypedNode parent) {
            this.parent = parent;
        }

        public void actionPerformed(ActionEvent e2) {
            TypedNode newNode = this.getNewNode();
            if (newNode != null) {
                TypedTreeEditor.this.tree.getModel().insertNodeInto(newNode, this.parent, this.parent.getChildCount());
                TypedTreeEditor.this.tree.expandPath(newNode);
                TypedTree cfr_ignored_0 = TypedTreeEditor.this.tree;
                TypedTreeEditor.this.tree.setSelectionPath(TypedTree.getPath(newNode));
                TypedTreeEditor.this.changed(newNode);
                TreeNodeInsertEditing action = new TreeNodeInsertEditing(TypedTreeEditor.this.tree, newNode, this.parent);
                TypedTreeEditor.this.history.addAction(action);
            }
        }

        protected abstract TypedNode getNewNode();
    }

    public class DefaultRedoAction
    implements ActionListener {
        public void actionPerformed(ActionEvent e2) {
            TypedTreeEditor.this.redo();
        }
    }

    public class DefaultUndoAction
    implements ActionListener {
        public void actionPerformed(ActionEvent e2) {
            TypedTreeEditor.this.undo();
        }
    }

    protected abstract class DefaultRenameAction
    implements ActionListener {
        public TypedNode theNode;

        public DefaultRenameAction(TypedNode theNode) {
            this.theNode = theNode;
        }

        public void actionPerformed(ActionEvent e2) {
            Object oldName = this.theNode.getUserObject();
            Object newName = this.getNewUserObject();
            if (newName != null) {
                this.theNode.setUserObject(newName);
                TypedTreeEditor.this.changed(this.theNode);
                TreeNodeRenameEditing action = new TreeNodeRenameEditing(this.theNode, oldName, newName);
                TypedTreeEditor.this.history.addAction(action);
            }
        }

        protected abstract Object getNewUserObject();
    }

    protected abstract class DefaultInsertParentAction
    implements ActionListener {
        public TypedNode theNode;

        public DefaultInsertParentAction(TypedNode theNode) {
            this.theNode = theNode;
        }

        public void actionPerformed(ActionEvent e2) {
            TypedNode parent = (TypedNode)this.theNode.getParent();
            if (parent != null) {
                TypedNode newNode = this.getNewNode();
                if (newNode == null) {
                    return;
                }
                DefaultTreeModel model = TypedTreeEditor.this.tree.getModel();
                model.insertNodeInto(newNode, parent, parent.getChildCount());
                BulkEditingAction bulk = new BulkEditingAction(this.theNode);
                bulk.summary = "Insert parent '" + newNode + "' on '" + this.theNode + "'";
                EditingAction action = new TreeNodeInsertEditing(TypedTreeEditor.this.tree, newNode, parent);
                bulk.addAction(action);
                model.removeNodeFromParent(this.theNode);
                action = new TreeNodeDeleteEditing(TypedTreeEditor.this.tree, this.theNode, parent);
                bulk.addAction(action);
                model.insertNodeInto(this.theNode, newNode, 0);
                action = new TreeNodeInsertEditing(TypedTreeEditor.this.tree, this.theNode, newNode);
                bulk.addAction(action);
                TypedTreeEditor.this.history.addAction(bulk);
                TypedTreeEditor.this.changed(this.theNode);
            }
        }

        protected abstract TypedNode getNewNode();
    }

    protected class DefaultDeleteAction
    implements ActionListener {
        TypedNode theNode;

        public DefaultDeleteAction(TypedNode theNode) {
            this.theNode = theNode;
        }

        public void actionPerformed(ActionEvent e2) {
            TypedTreeEditor.this.delete(this.theNode);
        }

        public DefaultDeleteAction() {
        }
    }

    protected class DefaultEditCommentsAction
    implements ActionListener {
        TypedNode theNode;

        public DefaultEditCommentsAction(TypedNode theNode) {
            this.theNode = theNode;
        }

        public void actionPerformed(ActionEvent e2) {
            String oldComments = (String)this.theNode.getComment();
            String newComments = JOptionPane.showInputDialog("Give comment for the node", (Object)oldComments);
            if (newComments == null) {
                return;
            }
            this.theNode.setComment(newComments);
            TypedTreeEditor.this.changed(this.theNode);
            TreeNodeCommentEditing action = new TreeNodeCommentEditing(this.theNode, oldComments, newComments);
            TypedTreeEditor.this.history.addAction(action);
        }
    }

    protected class DefaultDeleteButKeepChildrenAction
    implements ActionListener {
        TypedNode theNode;

        public DefaultDeleteButKeepChildrenAction(TypedNode theNode) {
            this.theNode = theNode;
        }

        public void actionPerformed(ActionEvent e2) {
            DefaultTreeModel model = TypedTreeEditor.this.tree.getModel();
            TypedNode parent = (TypedNode)this.theNode.getParent();
            int child = this.theNode.getChildCount();
            BulkEditingAction bulk = new BulkEditingAction(parent);
            bulk.summary = "Delete '" + this.theNode + "' and keep its children";
            for (int i2 = 0; i2 < child; ++i2) {
                TypedNode kid = (TypedNode)this.theNode.getChildAt(0);
                model.insertNodeInto(kid, parent, parent.getChildCount());
                TreeNodeMoveEditing action = new TreeNodeMoveEditing(TypedTreeEditor.this.tree, kid, this.theNode, parent);
                bulk.addAction(action);
            }
            model.removeNodeFromParent(this.theNode);
            TreeNodeDeleteEditing action = new TreeNodeDeleteEditing(TypedTreeEditor.this.tree, this.theNode, parent);
            bulk.addAction(action);
            TypedTreeEditor.this.history.addAction(bulk);
            TypedTreeEditor.this.changed(this.theNode);
            TypedTreeEditor.this.changed(parent);
        }
    }

    protected class DefaultDeleteAllChildrenAction
    implements ActionListener {
        TypedNode theNode;

        public DefaultDeleteAllChildrenAction(TypedNode theNode) {
            this.theNode = theNode;
        }

        public void actionPerformed(ActionEvent e2) {
            TypedTreeEditor.this.deleteAllChildren(this.theNode);
        }
    }
}

