/*
 * Decompiled with CFR 0.152.
 */
package edu.iastate.anthill.indus.tree;

import edu.iastate.anthill.indus.IndusConstants;
import edu.iastate.anthill.indus.tree.TypedNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;

public class TypedTreeRender
extends JLabel
implements TreeCellRenderer {
    public static Map<String, Icon> icons = new HashMap<String, Icon>();
    protected static final Color SelectedBackgroundColor = Color.yellow;
    protected boolean selected;

    public TypedTreeRender() {
        icons.put("0", IndusConstants.iconRoot);
        icons.put("7", IndusConstants.iconPackage);
        icons.put("4", IndusConstants.iconClass);
        icons.put("5", IndusConstants.iconProperty);
        icons.put("6", IndusConstants.iconInstance);
        icons.put("1", IndusConstants.iconAllClasses);
        icons.put("2", IndusConstants.iconAllProperties);
        icons.put("3", IndusConstants.iconAllInstances);
        icons.put("9", IndusConstants.iconSchema);
        icons.put("10", IndusConstants.iconAVHValue);
        icons.put("11", IndusConstants.iconDB);
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        String stringValue = tree.convertValueToText(value, selected, expanded, leaf, row, hasFocus);
        this.setText(stringValue);
        this.setToolTipText(stringValue);
        if (value instanceof TypedNode) {
            TypedNode theNode = (TypedNode)value;
            Icon icon = theNode.getIcon();
            if (icon != null) {
                this.setIcon(icon);
            } else {
                this.setIcon(icons.get(theNode.getType() + ""));
            }
            Color color = theNode.getColor();
            if (color != null) {
                this.setForeground(color);
            } else {
                this.setForeground(Color.black);
            }
        }
        this.selected = selected;
        return this;
    }

    public void paint(Graphics g2) {
        Icon currentI = this.getIcon();
        Color bColor = this.selected ? SelectedBackgroundColor : (this.getParent() != null ? this.getParent().getBackground() : this.getBackground());
        g2.setColor(bColor);
        if (currentI != null && this.getText() != null) {
            int offset = currentI.getIconWidth() + this.getIconTextGap();
            if (this.getComponentOrientation().isLeftToRight()) {
                g2.fillRect(offset, 0, this.getWidth() - 1 - offset, this.getHeight() - 1);
            } else {
                g2.fillRect(0, 0, this.getWidth() - 1 - offset, this.getHeight() - 1);
            }
        } else {
            g2.fillRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        }
        super.paint(g2);
    }
}

