/*
 * Decompiled with CFR 0.152.
 */
package edu.iastate.ato.agent;

import edu.iastate.ato.agent.Buddy;
import edu.iastate.ato.agent.MoAgent;
import edu.iastate.utils.lang.MessageHandler;
import edu.iastate.utils.lang.MessageMap;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class ChatPanel
extends JPanel
implements MessageHandler {
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanel2 = new JPanel();
    BorderLayout borderLayout2 = new BorderLayout();
    JTextField textMsg = new JTextField();
    JButton btnSend = new JButton();
    JScrollPane jScrollPane1 = new JScrollPane();
    JTextArea chatHistory = new JTextArea();
    Buddy theBuddy;
    JFrame frame;
    public static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public ChatPanel(Buddy b2) {
        try {
            this.theBuddy = b2;
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void showMe() {
        this.frame.setVisible(true);
    }

    private void jbInit() throws Exception {
        this.messageMap();
        this.setLayout(this.borderLayout1);
        this.jPanel2.setLayout(this.borderLayout2);
        this.textMsg.setText("");
        this.btnSend.setText("Send");
        this.btnSend.setMnemonic(10);
        this.btnSend.setToolTipText("Alt+Enter");
        this.chatHistory.setBackground(Color.orange);
        this.chatHistory.setEditable(false);
        this.chatHistory.setLineWrap(true);
        this.add((Component)this.jPanel2, "South");
        this.jPanel2.add((Component)this.btnSend, "East");
        this.jPanel2.add((Component)this.textMsg, "Center");
        this.add((Component)this.jScrollPane1, "Center");
        this.jScrollPane1.getViewport().add(this.chatHistory);
        this.frame = new JFrame();
        this.frame.setSize(200, 400);
        this.frame.setContentPane(this);
        this.frame.setTitle("Chat with " + this.theBuddy.name);
        this.frame.setDefaultCloseOperation(1);
    }

    public static String getTime() {
        return dateFormat.format(new Date());
    }

    public void onSend(ActionEvent actionEvent) {
        final String msg = this.textMsg.getText();
        if (msg.length() == 0) {
            return;
        }
        this.textMsg.setText("");
        new Thread(){

            public void run() {
                String res = MoAgent.sendMessage(msg, ChatPanel.this.theBuddy);
                ChatPanel.this.chatHistory.append("You said (" + ChatPanel.getTime() + ")\n" + msg + "[" + res + "]\n");
            }
        }.start();
    }

    public void messageMap() {
        try {
            MessageMap.mapAction(this.btnSend, this, "onSend");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void append(String client_user, String content) {
        this.chatHistory.append(client_user + " said (" + ChatPanel.getTime() + ")\n" + content + "\n");
    }
}

