/*
 * Decompiled with CFR 0.152.
 */
package edu.iastate.ato.gui;

import edu.iastate.anthill.indus.AboutBoxDialog;
import edu.iastate.anthill.indus.tree.TypedTree;
import edu.iastate.ato.gui.MOEditorBasis;
import edu.iastate.ato.gui.MOEditorGui;
import edu.iastate.ato.gui.OntologyServerInfo;
import edu.iastate.ato.gui.dialog.LoginPanel;
import edu.iastate.ato.gui.dialog.OnlineBuddyPanel;
import edu.iastate.ato.gui.dialog.SchemaPanel;
import edu.iastate.ato.gui.dialog.SettingPanel;
import edu.iastate.ato.gui.dialog.UserManagementCenter;
import edu.iastate.ato.gui.packageview.PackageTree;
import edu.iastate.ato.gui.packageview.PackageView2Db;
import edu.iastate.ato.gui.wizard.SeverBuilder;
import edu.iastate.ato.po.DB2OBO;
import edu.iastate.ato.po.DB2OWL;
import edu.iastate.ato.po.OBO2DB;
import edu.iastate.ato.po.OntologyServerBuilder;
import edu.iastate.ato.po.User;
import edu.iastate.ato.po.UserManager;
import edu.iastate.ato.tree.ATOTreeNode;
import edu.iastate.ato.tree.PackageNode;
import edu.iastate.utils.Debug;
import edu.iastate.utils.gui.GUIUtils;
import edu.iastate.utils.io.FileUtils;
import edu.iastate.utils.lang.MessageHandler;
import edu.iastate.utils.lang.MessageMap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;

public class MOEditor
extends MOEditorGui
implements MessageHandler {
    public static MOEditor theInstance;
    private boolean canClose = true;
    String searchTerm = null;
    Enumeration enumSearch = null;

    public MOEditor() {
        try {
            theInstance = this;
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void main(String[] args) {
        MOEditor atoeditor = new MOEditor();
        atoeditor.mainFrame.getContentPane().add(atoeditor);
        GUIUtils.maximize(atoeditor.mainFrame);
        atoeditor.jSplitPane1.setDividerLocation(600);
        atoeditor.mainFrame.setDefaultCloseOperation(3);
        atoeditor.mainFrame.setVisible(true);
    }

    public void updateTitle() {
        String str = "Indus DAG editor, Current Ontology: ";
        if (this.selectedServer == null) {
            str = str + "<none>";
        } else {
            str = str + this.selectedServer.name;
            if (!this.selectedServer.loaded) {
                str = str + " (not loaded) ";
            }
            str = str + ", User: " + user;
        }
        this.mainFrame.setTitle(str);
    }

    private void jbInit() throws Exception {
        this.messageMap();
        this.messenger.start();
        this.config.load(this);
        if (this.selectedServer != null) {
            this.load(this.selectedServer);
        }
        this.updateTitle();
    }

    public void updateUser(User newUser) {
        if (user == newUser) {
            return;
        }
        if (user != null) {
            UserManager.cancelAllEditing(this.conn.db, MOEditor.user.name);
            UserManager.logout(this.conn.db, MOEditor.user.name, this.messenger.getIp(), "" + this.messenger.getPort());
            this.messenger.myName = "guest";
        }
        if (newUser != null) {
            UserManager.cancelAllEditing(this.conn.db, newUser.name);
            UserManager.login(this.conn.db, newUser.name, this.messenger.getIp(), "" + this.messenger.getPort());
            this.messenger.myName = newUser.name;
        }
        user = newUser;
    }

    public User askForUserName() {
        LoginPanel p2 = new LoginPanel(this.conn.db, user);
        p2.showDlg();
        if (p2.ok) {
            if (user != null && p2.getUser().equals(MOEditor.user.name)) {
                return user;
            }
            User newUser = new User(this.conn.db, p2.getUser());
            return newUser;
        }
        return null;
    }

    public void onCancalAllEditing(ActionEvent e2) {
        Vector package_oid = UserManager.getEditingPackages(this.conn.db, MOEditor.user.name, true);
        Vector package_pid = UserManager.getEditingPackages(this.conn.db, MOEditor.user.name, false);
        if (package_oid.size() == 0) {
            Debug.trace("There is no package edited by " + user);
        } else {
            UserManager.cancelAllEditing(this.conn.db, MOEditor.user.name);
            this.getPackageTree().cancelEditing(package_oid);
            Debug.trace("You cancel the editing privilege for following packages:\n " + package_pid);
        }
    }

    public void onAbout(ActionEvent e2) {
        String infoAbout = "<html><font color=\"#FF0099\"><b>Indus DAG editor</b></font><br>Version 2.0<br><br><b>Jie Bao</b><br>July 2005<br>Iowa State University<br><a href=\"mailto:baojie@iastate.edu\">baojie@iastate.edu</a><br><a href=\"http://www.cs.iastate.edu/~baojie\">http://www.cs.iastate.edu/~baojie</a><br></html>";
        AboutBoxDialog dlg = new AboutBoxDialog(infoAbout, "About ATO Editor");
        dlg.showAboutBox();
    }

    public void onHelp(ActionEvent e2) {
        Icon hogIcon = GUIUtils.loadIcon("images/hog.jpg");
        JLabel hog = new JLabel(hogIcon);
        JDialog dlg = new JDialog((Frame)this.mainFrame, true);
        dlg.getContentPane().setLayout(new BorderLayout());
        dlg.getContentPane().add((Component)hog, "North");
        JEditorPane editorPane = new JEditorPane();
        editorPane.setEditable(false);
        editorPane.setContentType("text/html");
        String info = "Indus DAG editor<br>Jie Bao, Aug 2005";
        try {
            info = FileUtils.readFile("atohelp.html");
        }
        catch (IOException ex) {
            // empty catch block
        }
        editorPane.setText(info);
        JScrollPane jsp = new JScrollPane(editorPane);
        dlg.getContentPane().add((Component)jsp, "Center");
        dlg.setTitle("Help on ATO Editor");
        dlg.setSize(400, 400);
        GUIUtils.centerWithinScreen(dlg);
        dlg.setVisible(true);
    }

    public void onExit() {
        this.updateUser(null);
        this.closeOntology(this.selectedServer);
        this.config.save(this);
        this.setVisible(false);
        this.mainFrame.dispose();
        System.exit(0);
    }

    public void onLoad(ActionEvent e2) {
        if (this.selectedServer != null) {
            this.load(this.selectedServer);
        } else {
            Debug.trace("No ontology is connected");
        }
    }

    public void onConfig(ActionEvent e2) {
        SettingPanel p2 = new SettingPanel(this.serverList, this.selectedServer);
        JDialog dlg = new JDialog((Frame)this.mainFrame, true);
        dlg.getContentPane().add(p2);
        dlg.setTitle("Ontology Server Setting");
        dlg.setSize(500, 330);
        dlg.setDefaultCloseOperation(2);
        GUIUtils.centerWithinParent(dlg);
        dlg.setVisible(true);
        this.serverList = p2.getOntologyConfigs();
        if (p2.selectedOnt != this.selectedServer) {
            this.load(p2.selectedOnt);
        }
    }

    public void onClose(ActionEvent e2) {
        if (this.selectedServer != null) {
            this.closeOntology(this.selectedServer);
        } else {
            Debug.trace("No ontology is connected");
        }
    }

    public void closeOntology(OntologyServerInfo info) {
        if (!this.canClose) {
            Debug.trace("Close is forbidden, long task is running");
            return;
        }
        if (info != null && this.conn != null) {
            this.paneMain.close();
            this.paneDetails.close();
            this.mainFrame.setJMenuBar(this.makeSmallMenuBar());
            this.jToolBar1.setVisible(false);
            info.loaded = false;
            this.conn.disconnect();
            this.conn = null;
            this.updateTitle();
        }
    }

    public boolean load(OntologyServerInfo info) {
        if (info.loaded) {
            Debug.trace("Ontology '" + info.name + "' is already loaded");
            return false;
        }
        int answer = JOptionPane.showConfirmDialog(null, "Load ontology '" + info.name + "'?");
        if (answer != 0) {
            return false;
        }
        this.closeOntology(this.selectedServer);
        this.selectedServer = null;
        this.updateTitle();
        this.conn = MOEditor.getConnection(info);
        if (this.conn == null) {
            Debug.trace("Cannot connect to the server");
            return false;
        }
        User newUser = this.askForUserName();
        if (newUser == null) {
            return false;
        }
        this.updateUser(newUser);
        this.prepareNamingPolicy(this.conn.db);
        this.paneMain.rebuild(this.conn.db);
        this.paneDetails.rebuild(this.conn.db);
        this.mainFrame.setJMenuBar(this.makeFullMenuBar());
        this.jToolBar1.setVisible(true);
        this.selectedServer = info;
        this.selectedServer.loaded = true;
        this.updateTitle();
        return true;
    }

    public void onOntologySchema(ActionEvent e2) {
        SchemaPanel p2 = new SchemaPanel(this.conn.db);
        JDialog dlg = new JDialog(GUIUtils.getRootFrame(this));
        dlg.getContentPane().add(p2);
        dlg.setTitle("Ontology Schema");
        dlg.setSize(480, 360);
        dlg.setDefaultCloseOperation(2);
        GUIUtils.centerWithinParent(dlg);
        dlg.setVisible(true);
    }

    public void onFindNext(ActionEvent ae) {
        if (this.searchTerm == null) {
            String newTerm = JOptionPane.showInputDialog("Search node on the ontology", (Object)this.searchTerm);
            if (newTerm == null) {
                return;
            }
            this.searchTerm = newTerm;
        }
        this.find();
    }

    public void onFind(ActionEvent ae) {
        String newTerm = JOptionPane.showInputDialog("Search node on the ontology", (Object)this.searchTerm);
        if (newTerm == null) {
            return;
        }
        this.searchTerm = newTerm;
        this.find();
    }

    private void find() {
        PackageTree tree = this.getPackageTree();
        if (this.enumSearch == null || !this.enumSearch.hasMoreElements()) {
            ATOTreeNode root = (ATOTreeNode)tree.getModel().getRoot();
            this.enumSearch = root.preorderEnumeration();
        }
        while (this.enumSearch.hasMoreElements()) {
            ATOTreeNode node = (ATOTreeNode)this.enumSearch.nextElement();
            if (node.getComment() != null && node.getComment().toString().indexOf(this.searchTerm) >= 0) {
                tree.expandNode(node);
                tree.setSelectionPath(TypedTree.getPath(node));
                return;
            }
            if (node.getUserObject() == null || !node.getUserObject().equals(this.searchTerm)) continue;
            tree.expandNode(node);
            tree.setSelectionPath(TypedTree.getPath(node));
            return;
        }
        Debug.trace(this.searchTerm + " has no (more) occurrence");
    }

    public void onSubmit(ActionEvent e2) {
        PackageView2Db tree2db = new PackageView2Db(this.conn.db, this.getPackageTree());
        tree2db.saveTree();
    }

    public void onExpand(ActionEvent e2) {
        this.paneMain.getSelectedPanel().onExpand();
    }

    public void onExportOWL(ActionEvent e2) {
        String title = "Export to OWL";
        String extension = "owl";
        String description = "OWL Documents";
        String fileName = this.getFileName("Export to OWL", "owl", "OWL Documents", true);
        if (fileName != null) {
            DB2OWL.exportOWL(this.conn.db, fileName);
        }
    }

    public void onExportOBO(ActionEvent e2) {
        String title = "Export to OBO";
        String extension = "obo";
        String description = "OBO Documents";
        String fileName = this.getFileName("Export to OBO", "obo", "OBO Documents", true);
        if (fileName != null) {
            DB2OBO exporter = new DB2OBO();
            exporter.exportOBO(this.conn.db, fileName, MOEditor.user.name, true);
        }
    }

    public void messageMap() {
        try {
            MessageMap.mapAction(this.btnUndo, this, "onUndo");
            MessageMap.mapAction(this.menuUndo, this, "onUndo");
            MessageMap.mapAction(this.btnRedo, this, "onRedo");
            MessageMap.mapAction(this.menuRedo, this, "onRedo");
            MessageMap.mapAction(this.btnConfig, this, "onConfig");
            MessageMap.mapAction(this.btnSubmit, this, "onSubmit");
            MessageMap.mapAction(this.btnAbout, this, "onAbout");
            MessageMap.mapAction(this.menuAbout, this, "onAbout");
            MessageMap.mapAction(this.btnExpand, this, "onExpand");
            MessageMap.mapAction(this.menuExpand, this, "onExpand");
            MessageMap.mapAction(this.menuExpandAll, this, "onExpandAll");
            MessageMap.mapAction(this.btnHelp, this, "onHelp");
            MessageMap.mapAction(this.menuHelp, this, "onHelp");
            MessageMap.mapAction(this.btnReload, this, "onReload");
            MessageMap.mapAction(this.btnFind, this, "onFind");
            MessageMap.mapAction(this.menuFind, this, "onFind");
            MessageMap.mapAction(this.menuFindNext, this, "onFindNext");
            MessageMap.mapAction(this.menuOntologySchema, this, "onOntologySchema");
            MessageMap.mapAction(this.menuConfig, this, "onConfig");
            MessageMap.mapAction(this.menuCancalAllEditing, this, "onCancalAllEditing");
            MessageMap.mapAction(this.menuExportOWL, this, "onExportOWL");
            MessageMap.mapAction(this.menuExportOBO, this, "onExportOBO");
            MessageMap.mapAction(this.menuLoad, this, "onLoad");
            MessageMap.mapAction(this.menuClose, this, "onClose");
            MessageMap.mapAction(this.menuLogin, this, "onLogin");
            MessageMap.mapAction(this.menuLogout, this, "onLogout");
            MessageMap.mapAction(this.menuSetServer, this, "onSetServer");
            MessageMap.mapAction(this.menuClear, this, "onClear");
            MessageMap.mapAction(this.menuImportOBO, this, "onImportOBO");
            MessageMap.mapAction(this.menuUserMgmt, this, "onUserMgmt");
            MessageMap.mapAction(this.btnBuddy, this, "onBuddy");
            this.mainFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent evt) {
                    MOEditor.this.onExit();
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onBuddy(ActionEvent e2) {
        OnlineBuddyPanel buddyList = new OnlineBuddyPanel(this.mainFrame, this.selectedServer);
        GUIUtils.centerWithinParent(buddyList);
        buddyList.setVisible(true);
    }

    public void onUserMgmt(ActionEvent e2) {
        if (user.isAdmin()) {
            UserManagementCenter dlg = new UserManagementCenter(this.mainFrame, this.selectedServer);
            GUIUtils.centerWithinParent(dlg);
            dlg.setVisible(true);
        } else {
            Debug.trace("You should have admin privilege");
        }
    }

    public void onReload(ActionEvent e2) {
        this.paneMain.rebuild(this.conn.db);
        this.paneDetails.rebuild(this.conn.db);
    }

    public void onImportOBO(ActionEvent e2) {
        if (!user.isAdmin()) {
            JOptionPane.showMessageDialog(this, "You must be admin to import an ontology");
            return;
        }
        String title = "Import OBO Ontology";
        String extension = "obo";
        String description = "OBO Documents";
        final String fileName = this.getFileName("Import OBO Ontology", "obo", "OBO Documents", true);
        if (fileName != null) {
            Debug.trace("Please don't close the ontology during importing");
            Thread t2 = new Thread(){

                public void run() {
                    int pb = MOEditor.this.statusBar.addProgressBar(true, 0, 0);
                    MOEditor.this.statusBar.updateProgressBar(pb, "Importing " + fileName);
                    try {
                        OBO2DB loader = new OBO2DB(MOEditor.this.conn.db, MOEditorBasis.user.name);
                        loader.setProgress(MOEditor.this.statusBar.getProgressBar(pb));
                        boolean suc = loader.importOBO(fileName, true);
                        Debug.trace(suc);
                        MOEditor.this.paneMain.rebuild(MOEditor.this.conn.db);
                        MOEditor.this.paneDetails.rebuild(MOEditor.this.conn.db);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    MOEditor.this.statusBar.removeProgressBar(pb);
                }
            };
            t2.start();
        }
    }

    public void onClear(ActionEvent e2) {
        if (!user.isAdmin()) {
            JOptionPane.showMessageDialog(this, "You must be admin to clear the ontology");
            return;
        }
        int answer = JOptionPane.showConfirmDialog(null, "Are you sure to delete all content in the database?\nYou will also delete all non-admin acounts\nThe deletion can NOT be undone.");
        if (answer == 0) {
            String msg = OntologyServerBuilder.clearDatabase(this.conn.db, false);
            System.out.println(msg);
            this.paneMain.rebuild(this.conn.db);
            this.paneDetails.rebuild(this.conn.db);
        }
    }

    public void onSetServer(ActionEvent e2) {
        SeverBuilder builder = new SeverBuilder();
    }

    public void onLogin(ActionEvent e2) {
        User newUser = this.askForUserName();
        if (newUser != null) {
            if (newUser != user) {
                this.logout();
                this.updateUser(newUser);
                this.updateTitle();
            }
        }
    }

    public void logout() {
        UserManager.cancelAllEditing(this.conn.db, MOEditor.user.name);
        Vector<PackageNode> pkgs = this.getPackageTree().getAllPackage();
        Iterator<PackageNode> i$ = pkgs.iterator();
        while (i$.hasNext()) {
            PackageNode pkg = i$.next();
            pkg.setReadOnly(true);
        }
    }

    public void onLogout(ActionEvent e2) {
        if (user.isGuest()) {
            return;
        }
        this.logout();
        this.updateUser(User.getGuest());
        this.updateTitle();
    }
}

