/*
 * Decompiled with CFR 0.152.
 */
package edu.iastate.ato.gui;

import edu.iastate.ato.agent.MoAgent;
import edu.iastate.ato.gui.MOEditorConfig;
import edu.iastate.ato.gui.OntologyServerInfo;
import edu.iastate.ato.po.OntologySchema;
import edu.iastate.ato.po.User;
import edu.iastate.ato.po.naming.BasicNamingPolicy;
import edu.iastate.ato.po.naming.NamingPolicy;
import edu.iastate.ato.po.naming.NamingPolicyFactory;
import edu.iastate.utils.gui.FileFilterEx;
import edu.iastate.utils.io.FileUtils;
import edu.iastate.utils.sql.LocalDBConnection;
import java.sql.Connection;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;

public class MOEditorBasis
extends JPanel {
    public JFrame mainFrame = new JFrame();
    protected LocalDBConnection conn;
    public MoAgent messenger = new MoAgent("guest");
    public NamingPolicy selectedNamingPolicy;
    protected MOEditorConfig config = new MOEditorConfig("onteditor.xml");
    public Set<OntologyServerInfo> serverList = new HashSet<OntologyServerInfo>();
    public OntologyServerInfo selectedServer = null;
    public static User user;

    public static LocalDBConnection getConnection(OntologyServerInfo info) {
        LocalDBConnection ds = new LocalDBConnection();
        ds.setUrl(info.url);
        ds.setUser(info.user);
        ds.setPassword(info.password);
        ds.setDriver(info.driver);
        if (!ds.connect()) {
            return null;
        }
        return ds;
    }

    protected void prepareNamingPolicy(Connection db2) {
        this.selectedNamingPolicy = new BasicNamingPolicy();
        String policy = OntologySchema.getNamingPolicy(this.conn.db);
        if (policy != null) {
            this.selectedNamingPolicy = NamingPolicyFactory.buildPolicyFromName(policy, db2);
        }
    }

    protected String getFileName(String title, String extension, String description, boolean isSave) {
        JFileChooser saveDialog = new JFileChooser();
        int mode = isSave ? 1 : 0;
        saveDialog.setDialogType(mode);
        saveDialog.setDialogTitle(title);
        FileFilterEx firstFilter = new FileFilterEx(extension, description);
        saveDialog.addChoosableFileFilter(firstFilter);
        FileFilter all = saveDialog.getAcceptAllFileFilter();
        saveDialog.removeChoosableFileFilter(all);
        saveDialog.addChoosableFileFilter(all);
        saveDialog.setFileFilter(firstFilter);
        int returnVal = saveDialog.showSaveDialog(this.mainFrame);
        if (returnVal == 0) {
            String newfile = saveDialog.getSelectedFile().getPath();
            if (isSave && FileUtils.findExtension(newfile) == "") {
                newfile = newfile + "." + extension;
            }
            return newfile;
        }
        return null;
    }
}

