/*
 * Decompiled with CFR 0.152.
 */
package edu.iastate.ato.gui.dialog;

import edu.iastate.ato.po.User;
import edu.iastate.ato.po.UserManager;
import edu.iastate.utils.Debug;
import edu.iastate.utils.gui.GUIUtils;
import edu.iastate.utils.gui.LabelledItemPanel;
import edu.iastate.utils.gui.StandardDialog;
import edu.iastate.utils.lang.MessageHandler;
import edu.iastate.utils.lang.MessageMap;
import edu.iastate.utils.string.Validator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.sql.Connection;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class LoginPanel
extends JPanel
implements MessageHandler {
    BorderLayout borderLayout1 = new BorderLayout();
    JButton btnOK = new JButton();
    JPanel buttonPane = new JPanel();
    JButton btnCancel = new JButton();
    JDialog dlg = new JDialog((Frame)GUIUtils.getRootFrame(this), true);
    public boolean ok;
    String asUser = null;
    Connection db;
    private JTextField userTxt = new JTextField();
    private JPasswordField passTxt = new JPasswordField();
    JButton btnGuest = new JButton();
    JButton btnRegister = new JButton();

    public String getUser() {
        return this.userTxt.getText().trim();
    }

    public LoginPanel(Connection db2, User u2) {
        try {
            this.db = db2;
            if (u2 != null) {
                this.userTxt.setText(u2.name);
                this.passTxt.setText(u2.pass);
            }
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.messageMap();
        this.setLayout(this.borderLayout1);
        LabelledItemPanel myContentPane = new LabelledItemPanel();
        myContentPane.setBorder(BorderFactory.createEtchedBorder());
        myContentPane.addItem("User", (JComponent)this.userTxt);
        myContentPane.addItem("Password", (JComponent)this.passTxt);
        this.btnOK.setText("OK");
        this.btnOK.setMnemonic(10);
        this.btnOK.setToolTipText("Alt+Enter");
        this.btnCancel.setText("Cancel");
        this.btnGuest.setText("As Guest");
        this.btnGuest.setMnemonic(71);
        this.btnRegister.setText("Register...");
        this.btnRegister.setMnemonic(82);
        this.add((Component)myContentPane, "Center");
        this.add((Component)this.buttonPane, "South");
        this.buttonPane.add(this.btnOK);
        this.buttonPane.add(this.btnGuest);
        this.buttonPane.add(this.btnRegister);
        this.buttonPane.add(this.btnCancel);
        this.dlg.getContentPane().add(this);
        this.dlg.setTitle("User Setting");
        this.dlg.setSize(400, 150);
        this.dlg.setDefaultCloseOperation(2);
        GUIUtils.centerWithinParent(this.dlg);
    }

    public void showDlg() {
        this.dlg.setVisible(true);
    }

    public void onOK(ActionEvent e2) {
        this.ok = UserManager.rightUser(this.db, this.userTxt.getText().trim(), new String(this.passTxt.getPassword()).trim());
        if (!this.ok) {
            Debug.trace("incorrect user or password");
            return;
        }
        this.dlg.setVisible(false);
        this.dlg.dispose();
    }

    public void onCancel(ActionEvent e2) {
        this.ok = false;
        this.dlg.setVisible(false);
        this.dlg.dispose();
    }

    public void onGuest(ActionEvent e2) {
        this.userTxt.setText("guest");
        this.passTxt.setText("guest");
        this.onOK(e2);
    }

    public void onRegister(ActionEvent e2) {
        StandardDialog dlg = new StandardDialog();
        LabelledItemPanel myContentPane = new LabelledItemPanel();
        myContentPane.setBorder(BorderFactory.createEtchedBorder());
        JTextField testUser = new JTextField();
        myContentPane.addItem("User id (required)", (JComponent)testUser);
        JPasswordField testPassword = new JPasswordField();
        myContentPane.addItem("Password (required)", (JComponent)testPassword);
        JPasswordField testPasswordRetype = new JPasswordField();
        myContentPane.addItem("Password Retype(required)", (JComponent)testPasswordRetype);
        JTextField testEmail = new JTextField();
        myContentPane.addItem("Email (required)", (JComponent)testEmail);
        JTextField textName = new JTextField();
        myContentPane.addItem("Name ", (JComponent)textName);
        JTextField textInstitution = new JTextField();
        myContentPane.addItem("Institution ", (JComponent)textInstitution);
        dlg.setContentPane(myContentPane);
        dlg.setTitle("Register as editor");
        dlg.setSize(400, 300);
        dlg.setVisible(true);
        GUIUtils.centerWithinScreen(dlg);
        if (!dlg.hasUserCancelled()) {
            boolean isSame;
            String id = testUser.getText().trim();
            boolean userExists = UserManager.ifUserExist(this.db, id);
            boolean isUserIDValid = id != null && id.length() > 0;
            String email = testEmail.getText().trim();
            boolean isEmailValid = Validator.isEmailAddress(email);
            String pass = new String(testPassword.getPassword()).trim();
            boolean isPasswordValid = pass != null && pass.length() > 0;
            String passRetype = new String(testPasswordRetype.getPassword()).trim();
            boolean bl = isSame = pass != null && passRetype != null && pass.equals(passRetype);
            if (!(!userExists && isUserIDValid && isEmailValid && isPasswordValid && isSame)) {
                String info = "Error!\n\n";
                if (!isUserIDValid) {
                    info = info + "* Name is null\n";
                }
                if (userExists) {
                    info = info + "* The name '" + id + "' has already been used\n";
                }
                if (!isEmailValid) {
                    info = info + "* Email address is not valid\n";
                }
                if (!isPasswordValid) {
                    info = info + "* Password is null";
                }
                if (!isSame) {
                    info = info + "* Password and its retype don't match\n";
                }
                Debug.trace(info);
                return;
            }
            String name = testEmail.getText();
            String institution = textInstitution.getText();
            boolean suc = UserManager.applyForID(this.db, id, pass, email, name, institution, "pkgadmin");
            String good = "User is successfully applied";
            String bad = "Application failed, please tery again later";
            Debug.trace(suc ? good : bad);
            if (suc) {
                this.userTxt.setText(id);
                this.passTxt.setText(pass);
            }
        }
    }

    public void messageMap() {
        try {
            MessageMap.mapAction(this.btnGuest, this, "onGuest");
            MessageMap.mapAction(this.btnRegister, this, "onRegister");
            MessageMap.mapAction(this.btnCancel, this, "onCancel");
            MessageMap.mapAction(this.btnOK, this, "onOK");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

