/*
 * Decompiled with CFR 0.152.
 */
package edu.iastate.ato.gui.dialog;

import edu.iastate.ato.agent.ChatPanel;
import edu.iastate.ato.agent.MoAgent;
import edu.iastate.ato.gui.MOEditor;
import edu.iastate.ato.gui.OntologyServerInfo;
import edu.iastate.ato.po.UserManager;
import edu.iastate.utils.Debug;
import edu.iastate.utils.lang.MessageHandler;
import edu.iastate.utils.lang.MessageMap;
import edu.iastate.utils.net.EmailTools;
import edu.iastate.utils.sql.DBViewer;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.table.TableColumnModel;

public class OnlineBuddyPanel
extends DBViewer
implements MessageHandler {
    JButton btnReload = new JButton("Reload");
    JButton btnEmail = new JButton("Send Email");
    JButton btnMessage = new JButton("Send Message");
    JButton btnClear = new JButton("Clear Inactive");
    int idxHost;
    int idxPort;

    public OnlineBuddyPanel(JFrame parent, OntologyServerInfo info) {
        super(parent, false, "Who is online?", info.url, info.user, info.password, false, info.driver);
        this.setModal(false);
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.messageMap();
        this.setDefaultCloseOperation(2);
        this.toolbar.add((Component)this.btnReload, null);
        this.toolbar.add((Component)this.btnEmail, null);
        this.toolbar.add((Component)this.btnMessage, null);
        if (MOEditor.user.isAdmin()) {
            this.btnClear.setToolTipText("Delete users that already get off line");
            this.toolbar.add((Component)this.btnClear, null);
        }
        this.datasourceList.setVisible(false);
        this.dbNavToolbar.setVisible(false);
        String sql = " SELECT online.user_id, users.role, users.name, users.email,  users.institution, online.login_time, host, port  FROM online, users  WHERE online.user_id = users.id";
        this.setSQL(sql);
        this.dataTable.setEditable(false);
        this.dataTable.setToolTipText("Double click to see details");
        this.dataTable.setSelectionMode(0);
        this.dataTable.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                    OnlineBuddyPanel.this.onTableMouseClick(evt);
                }
            }
        });
    }

    public void setVisible(boolean v2) {
        super.setVisible(v2);
        if (v2) {
            this.refresh();
            this.dataTable.getTableHeader().setReorderingAllowed(false);
            this.dataTable.setAutoResizeMode(4);
            TableColumnModel t2 = this.dataTable.getColumnModel();
            System.out.println(this.dataTable.getColumnName(0));
            this.idxHost = t2.getColumnIndex("host");
            this.idxPort = t2.getColumnIndex("port");
            this.dataTable.setHiddenColumns(new int[]{this.idxHost, this.idxPort});
        }
    }

    private void onTableMouseClick(MouseEvent evt) {
        int row = this.dataTable.rowAtPoint(evt.getPoint());
        int col = this.dataTable.getColumnModel().getColumnIndex("user_id");
        String user_id = (String)this.dataTable.getValueAt(row, col);
        Vector allPackages = UserManager.getEditingPackages(this.CacheDB.getJdbcConnection(), user_id, false);
        String str = "User '" + user_id + "' is editing following package(s): \n";
        if (allPackages.size() == 0) {
            str = str + "<none>";
        } else {
            Iterator i$ = allPackages.iterator();
            while (i$.hasNext()) {
                String pkg = (String)i$.next();
                str = str + pkg + "\n";
            }
        }
        Debug.trace(null, str);
    }

    public void messageMap() {
        try {
            MessageMap.mapAction(this.btnReload, this, "onReload");
            MessageMap.mapAction(this.btnEmail, this, "onEmail");
            MessageMap.mapAction(this.btnMessage, this, "onMessage");
            MessageMap.mapAction(this.btnClear, this, "onClear");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onClear(ActionEvent e2) {
        if (!MOEditor.user.isAdmin()) {
            Debug.trace("You have no right to delete online information");
        }
        int colUser = this.dataTable.getColumnModel().getColumnIndex("user_id");
        int count = this.dataTable.getRowCount();
        for (int row = 0; row < count; ++row) {
            String host = (String)this.dataTable.getModel().getValueAt(row, this.idxHost);
            String port = (String)this.dataTable.getModel().getValueAt(row, this.idxPort);
            String user_id = (String)this.dataTable.getModel().getValueAt(row, colUser);
            if (user_id == null || host == null || port == null) continue;
            boolean suc = false;
            try {
                suc = MoAgent.isServerOn(host, port);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            System.out.println(user_id + "@" + host + ":" + port + " - " + suc);
            if (suc) continue;
            UserManager.logout(this.CacheDB.getJdbcConnection(), user_id, host, port);
        }
        this.refresh();
    }

    public void onEmail(ActionEvent e2) {
        if (MOEditor.user.isGuest()) {
            Debug.trace("Guest cannot send email");
            return;
        }
        int row = this.dataTable.getSelectedRow();
        if (row != -1) {
            String body;
            int col = this.dataTable.getColumnModel().getColumnIndex("email");
            String email = (String)this.dataTable.getValueAt(row, col);
            String ont = MOEditor.theInstance.selectedServer.name;
            String subject = "\"On Ontology Editing - " + ont + "\"";
            boolean suc = EmailTools.sendWindowsEmail(email, subject, body = "\"From editor " + MOEditor.user.name + "\"");
            if (!suc) {
                Debug.trace("Cannot send email to " + email);
            }
        }
    }

    public void onMessage(ActionEvent e2) {
        if (MOEditor.user.isGuest()) {
            Debug.trace("Guest cannot send message");
            return;
        }
        int row = this.dataTable.getSelectedRow();
        if (row != -1) {
            String host = (String)this.dataTable.getModel().getValueAt(row, this.idxHost);
            String port = (String)this.dataTable.getModel().getValueAt(row, this.idxPort);
            int col = this.dataTable.getColumnModel().getColumnIndex("user_id");
            String user = (String)this.dataTable.getModel().getValueAt(row, col);
            if (host != null && port != null) {
                MoAgent myServer = MOEditor.theInstance.messenger;
                ChatPanel window = myServer.startChat(user, host, port);
                if (window == null) {
                    Debug.trace("Connot connect to selected user");
                } else {
                    window.showMe();
                }
            }
        }
    }

    public void onReload(ActionEvent e2) {
        this.refresh();
    }
}

