/*
 * Decompiled with CFR 0.152.
 */
package edu.iastate.ato.gui.dialog;

import edu.iastate.ato.gui.MOEditor;
import edu.iastate.ato.po.OntologySchema;
import edu.iastate.ato.po.naming.BasicNamingPolicy;
import edu.iastate.ato.po.naming.NamingPolicy;
import edu.iastate.ato.po.naming.NamingPolicyFactory;
import edu.iastate.utils.Debug;
import edu.iastate.utils.gui.LabelledItemPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SchemaPanel
extends JPanel {
    Connection db;
    JTextArea textRelation = new JTextArea();
    JTextArea textProperty = new JTextArea();
    JTextArea textPolicyDetails = new JTextArea();
    JButton btnSave = new JButton();
    DefaultListModel lstNamingPolicyModel = new DefaultListModel();
    JList lstNamingPolicy = new JList(this.lstNamingPolicyModel);
    JPanel buttonPane = new JPanel();
    JTabbedPane contentPane = new JTabbedPane();
    JPanel relationPane = new JPanel();
    JPanel propertyPane = new JPanel();
    JPanel namingPane = new JPanel();
    LabelledItemPanel otherPane = new LabelledItemPanel();
    JTextArea prefix = new JTextArea();
    JButton btnImportOBO = new JButton();

    public SchemaPanel(Connection db2) {
        try {
            this.db = db2;
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        JScrollPane jScrollPane1 = new JScrollPane();
        JScrollPane jScrollPane2 = new JScrollPane();
        JScrollPane jScrollPane3 = new JScrollPane();
        JScrollPane jScrollPane4 = new JScrollPane();
        JLabel jLabel1 = new JLabel();
        JLabel jLabel2 = new JLabel();
        JLabel jLabel3 = new JLabel();
        JPanel jPanel7 = new JPanel();
        this.setLayout(new BorderLayout());
        jLabel1.setToolTipText("");
        jLabel1.setText("Possible relations in the hierarchy (one per line)");
        jLabel2.setText("Possible properties for terms (one per line)");
        this.relationPane.setLayout(new BorderLayout());
        this.textRelation.setText("");
        this.propertyPane.setLayout(new BorderLayout());
        this.textProperty.setText("");
        this.btnSave.setText("Save");
        this.btnSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                SchemaPanel.this.onSave(e2);
            }
        });
        this.namingPane.setLayout(new BorderLayout());
        jLabel3.setText("Choose Naming Policy");
        jPanel7.setLayout(new GridLayout());
        this.textPolicyDetails.setEditable(false);
        this.textPolicyDetails.setText("");
        this.btnImportOBO.setText("Import OBO Properties");
        this.btnImportOBO.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SchemaPanel.this.onImportOBO(actionEvent);
            }
        });
        this.relationPane.add((Component)jLabel1, "North");
        this.relationPane.add((Component)jScrollPane1, "Center");
        jScrollPane1.getViewport().add(this.textRelation);
        this.buttonPane.add(this.btnSave);
        this.buttonPane.add(this.btnImportOBO);
        this.propertyPane.add((Component)jScrollPane2, "Center");
        this.propertyPane.add((Component)jLabel2, "North");
        jScrollPane2.getViewport().add(this.textProperty);
        this.add((Component)this.buttonPane, "South");
        this.namingPane.add((Component)jLabel3, "North");
        this.namingPane.add((Component)jPanel7, "Center");
        jPanel7.add(jScrollPane3);
        jPanel7.add(jScrollPane4);
        jScrollPane4.getViewport().add(this.textPolicyDetails);
        jScrollPane3.getViewport().add(this.lstNamingPolicy);
        this.add((Component)this.contentPane, "Center");
        this.contentPane.add((Component)this.namingPane, "Name Policy");
        this.contentPane.add((Component)this.propertyPane, "Term Properties");
        this.contentPane.add((Component)this.relationPane, "Relations");
        this.contentPane.add((Component)this.otherPane, "Other");
        this.otherPane.addItem("Ontology prefix", (JComponent)this.prefix);
        Iterator<NamingPolicy> i$ = NamingPolicyFactory.getAllNamingPolicy(this.db).iterator();
        while (i$.hasNext()) {
            NamingPolicy policy = i$.next();
            this.lstNamingPolicyModel.addElement(policy);
        }
        this.lstNamingPolicy.addListSelectionListener(new MyListSelectionListener());
        this.onLoad(null);
    }

    public void onLoad(ActionEvent e2) {
        this.prefix.setText(OntologySchema.getPrefix(this.db));
        Vector po = OntologySchema.getPredicate(this.db, OntologySchema.PARTIAL_ORDER);
        String str = "";
        Iterator i$ = po.iterator();
        while (i$.hasNext()) {
            String po_str = (String)i$.next();
            str = str + po_str + "\n";
        }
        this.textRelation.setText(str);
        Vector tp = OntologySchema.getPredicate(this.db, OntologySchema.TERM_PROPERTY);
        str = "";
        Iterator i$2 = tp.iterator();
        while (i$2.hasNext()) {
            String tp_str = (String)i$2.next();
            str = str + tp_str + "\n";
        }
        this.textProperty.setText(str);
        String policy = OntologySchema.getNamingPolicy(this.db);
        System.out.println(policy);
        if (policy == null) {
            policy = BasicNamingPolicy.policyName;
        }
        int size = this.lstNamingPolicyModel.getSize();
        System.out.println(size);
        for (int i2 = 0; i2 < size; ++i2) {
            NamingPolicy item = (NamingPolicy)this.lstNamingPolicyModel.getElementAt(i2);
            System.out.println(item);
            if (!item.getPolicyName().trim().equals(policy)) continue;
            this.lstNamingPolicy.setSelectedIndex(i2);
            break;
        }
    }

    public void onSave(ActionEvent e2) {
        if (!MOEditor.user.isAdmin()) {
            Debug.trace("You should be admin to change the schema");
            return;
        }
        String pre = this.prefix.getText();
        if (pre == null || pre.trim().length() == 0) {
            pre = "";
        }
        OntologySchema.setPrefix(this.db, pre);
        OntologySchema.clear(this.db, OntologySchema.PARTIAL_ORDER);
        String[] po = this.textRelation.getText().split("\n");
        for (int i2 = 0; i2 < po.length; ++i2) {
            if (po[i2].trim().length() <= 0) continue;
            OntologySchema.addPredicate(this.db, OntologySchema.PARTIAL_ORDER, po[i2]);
        }
        OntologySchema.clear(this.db, OntologySchema.TERM_PROPERTY);
        String[] tp = this.textProperty.getText().split("\n");
        for (int i3 = 0; i3 < tp.length; ++i3) {
            if (tp[i3].trim().length() <= 0) continue;
            OntologySchema.addPredicate(this.db, OntologySchema.TERM_PROPERTY, tp[i3]);
        }
        OntologySchema.clear(this.db, OntologySchema.NAMING_POLICY);
        NamingPolicy p2 = (NamingPolicy)this.lstNamingPolicy.getSelectedValue();
        String selectedPolicy = p2.getPolicyName();
        MOEditor.theInstance.selectedNamingPolicy = p2;
        OntologySchema.addPredicate(this.db, OntologySchema.NAMING_POLICY, selectedPolicy);
    }

    public void onImportOBO(ActionEvent actionEvent) {
        int i2;
        String[] current = this.textProperty.getText().split("\n");
        String[] obo = OntologySchema.obo_properties;
        TreeSet<String> all = new TreeSet<String>();
        for (i2 = 0; i2 < current.length; ++i2) {
            all.add(current[i2]);
        }
        for (i2 = 0; i2 < obo.length; ++i2) {
            all.add(obo[i2]);
        }
        String str = "";
        Iterator i$ = all.iterator();
        while (i$.hasNext()) {
            String tp = (String)i$.next();
            if (tp.trim().length() <= 0) continue;
            str = str + tp + "\n";
        }
        this.textProperty.setText(str);
    }

    class MyListSelectionListener
    implements ListSelectionListener {
        MyListSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent evt) {
            if (!evt.getValueIsAdjusting()) {
                JList list = (JList)evt.getSource();
                NamingPolicy policy = (NamingPolicy)list.getSelectedValue();
                SchemaPanel.this.textPolicyDetails.setText(policy.getExplanation());
            }
        }
    }
}

