/*
 * Decompiled with CFR 0.152.
 */
package edu.iastate.ato.gui.packageview;

import edu.iastate.anthill.indus.tree.TypedTree;
import edu.iastate.ato.gui.MOEditor;
import edu.iastate.ato.gui.OntologyServerInfo;
import edu.iastate.ato.gui.packageview.PackageTree;
import edu.iastate.ato.po.DbPackage;
import edu.iastate.ato.po.OntologyQuerier;
import edu.iastate.ato.po.OntologySchema;
import edu.iastate.ato.tree.PackageNode;
import edu.iastate.utils.Debug;
import edu.iastate.utils.sql.LocalDBConnection;
import java.sql.Connection;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JScrollPane;

public class Package2Tree {
    String defaultRelation;
    protected Connection db;

    public Package2Tree(Connection db2) {
        this.db = db2;
        this.defaultRelation = "is_a";
        Vector v2 = OntologySchema.getPartialOrders(db2);
        if (v2.size() > 1) {
            this.defaultRelation = (String)v2.elementAt(0);
        }
    }

    public String getRootOid() {
        return OntologyQuerier.getPackageOid(this.db, "Global");
    }

    public PackageNode createNode(String oid) {
        DbPackage thePackage = DbPackage.read(this.db, oid);
        PackageNode n2 = new PackageNode(thePackage);
        n2.updateTermNumber(this.db);
        n2.setViewMode(this.defaultRelation);
        return n2;
    }

    protected void buildTree(TypedTree tree, int cutoff, PackageNode from) {
        if (from == null) {
            return;
        }
        if (cutoff != 0) {
            String ids = from.getOid();
            Vector children = OntologyQuerier.getChildrenPackage(this.db, ids);
            System.out.println(ids + " -> " + children);
            for (int i2 = 0; i2 < children.size(); ++i2) {
                String kid = (String)children.elementAt(i2);
                PackageNode node = this.createNode(kid);
                from.add(node);
                this.buildTree(tree, cutoff - 1, node);
            }
        }
    }

    public PackageTree getTree(String from_oid, int cutoff) {
        if (from_oid == null) {
            from_oid = this.getRootOid();
        }
        PackageTree tree = new PackageTree(this.db);
        PackageNode node = this.createNode(from_oid);
        this.buildTree(tree, cutoff, node);
        tree.setTop(node);
        return tree;
    }

    public static void main(String[] args) {
        LocalDBConnection conn = MOEditor.getConnection(OntologyServerInfo.getAtoOntology());
        if (conn.connect()) {
            Package2Tree mm = new Package2Tree(conn.db);
            PackageTree t2 = mm.getTree(null, -1);
            conn.disconnect();
            JFrame frame = new JFrame();
            frame.setSize(800, 600);
            JScrollPane scr = new JScrollPane(t2);
            frame.getContentPane().add(scr);
            frame.setVisible(true);
            System.out.print(t2);
        } else {
            Debug.trace("Cannot connect to database");
        }
    }
}

