/*
 * Decompiled with CFR 0.152.
 */
package edu.iastate.ato.gui.packageview;

import edu.iastate.anthill.indus.datasource.type.DataType;
import edu.iastate.anthill.indus.tree.TypedNode;
import edu.iastate.anthill.indus.tree.TypedTreeEditor;
import edu.iastate.ato.agent.ChatPanel;
import edu.iastate.ato.agent.MoAgent;
import edu.iastate.ato.gui.MOEditor;
import edu.iastate.ato.gui.dialog.PrivilegeEditor;
import edu.iastate.ato.gui.packageview.PackageTree;
import edu.iastate.ato.gui.packageview.PackageTreeEditorBasis;
import edu.iastate.ato.po.DbTerm;
import edu.iastate.ato.po.OnlineInfo;
import edu.iastate.ato.po.OntologyEdit;
import edu.iastate.ato.po.OntologyQuerier;
import edu.iastate.ato.po.OntologySchema;
import edu.iastate.ato.po.UserManager;
import edu.iastate.ato.shared.IconLib;
import edu.iastate.ato.tree.ATOTreeNode;
import edu.iastate.ato.tree.DBTermCloneNode;
import edu.iastate.ato.tree.DbTermNode;
import edu.iastate.ato.tree.PackageNode;
import edu.iastate.utils.Debug;
import edu.iastate.utils.gui.GUIUtils;
import edu.iastate.utils.net.EmailTools;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;

public class PackageTreeEditor
extends PackageTreeEditorBasis {
    PackageTree thisTree;

    public PackageTreeEditor(PackageTree tree, Connection db2) {
        this.tree = tree;
        this.thisTree = tree;
        this.db = db2;
    }

    protected void buildContextMenu(TypedNode selectedNode) {
        boolean isLeaf;
        ATOTreeNode theNode = (ATOTreeNode)selectedNode;
        boolean isRoot = theNode.getParent() == null;
        boolean isTerm = theNode instanceof DbTermNode;
        boolean isPackage = theNode instanceof PackageNode;
        boolean isCloned = theNode instanceof DBTermCloneNode;
        boolean isDeleted = theNode.isDeleted();
        boolean bl = isLeaf = theNode.getChildCount() == 0;
        if (theNode instanceof DbTermNode) {
            isLeaf = isLeaf && !((DbTermNode)theNode).hasMore;
        }
        boolean isTopLevel = theNode.getParent() instanceof PackageNode;
        boolean isMerged = theNode.status == 4;
        boolean readOnly = theNode.isReadOnly();
        boolean isGuest = MOEditor.user.isGuest();
        boolean isAdmin = MOEditor.user.isAdmin();
        boolean enableRename = MOEditor.theInstance.selectedNamingPolicy.enableRename;
        if (isPackage) {
            PackageNode thePackage = (PackageNode)theNode;
            boolean hasWriteRights = this.hasPrivilege(MOEditor.user.name, thePackage);
            if (readOnly && hasWriteRights) {
                this.addMenuItem("Edit the package", IconLib.iconStartPackage, new EditPackageAction(thePackage));
            }
            if (!readOnly) {
                this.addMenuItem("Quit editing", IconLib.iconCancalPackage, new QuitEditingAction(thePackage));
            }
            if (hasWriteRights) {
                this.addMenuItem("Package Editors...", IconLib.iconEditor, new AddEditorAction(thePackage));
            }
            if (!(hasWriteRights || isGuest || isAdmin)) {
                this.addMenuItem("Apply for Editor", IconLib.iconAddme, new ApplyEditorAction(thePackage));
            }
            this.popup.add(new JSeparator());
            if (!isDeleted) {
                this.addMenuItem("Reload Package", IconLib.iconReloadPackage, new ReloadAction(thePackage));
                this.addMenuItem("Change Package View Mode", IconLib.iconVisibility, new ChangeViewModeAction(thePackage));
                this.popup.add(new JSeparator());
            }
            if (!isRoot && !readOnly && !isDeleted && hasWriteRights) {
                this.addMenuItem("Change Package ID", IconLib.iconRename, new RenameAction(theNode));
                this.addMenuItem("Comments", IconLib.iconComment, new TypedTreeEditor.DefaultEditCommentsAction(theNode));
                this.popup.add(new JSeparator());
            }
            if (!isDeleted && !isGuest) {
                this.addMenuItem("Add Sub Package", IconLib.iconAddSubPackage, new CreateSubPackageAction(thePackage));
                if (!readOnly && hasWriteRights && !isRoot && this.enableInsertParent) {
                    this.addMenuItem("Add Super Package", IconLib.iconAddSuperPackage, new CreateSuperPackageAction(thePackage));
                }
            }
            if (!readOnly && !isDeleted && hasWriteRights && !isRoot && thePackage.expanded) {
                this.addMenuItem("Delete Package", IconLib.iconDelete, new DeletePackageAction(thePackage));
                String info = "Drag the package and drop it on the package to be merged";
                this.addMenuItem("Merge Into...", IconLib.iconMerge, new DoNothingAction(thePackage, info));
            }
            if (isDeleted && hasWriteRights) {
                this.addMenuItem("Undelete Package", IconLib.iconUndelete, new UndeletePackageAction(thePackage));
            }
            if (!readOnly && !isDeleted && hasWriteRights) {
                this.popup.add(new JSeparator());
                this.addMenuItem("Add Term", IconLib.iconAddTerm, new CreateSubTermAction((TypedNode)thePackage));
            }
        } else if (isTerm) {
            DbTermNode theTerm = (DbTermNode)theNode;
            PackageNode hp = theTerm.getHomePackageNode();
            boolean isObsolete = theTerm.isObsolete();
            if (!(isRoot || isCloned || readOnly || isMerged || isDeleted)) {
                if (enableRename) {
                    this.addMenuItem("Change Primary ID", IconLib.iconRename, new RenameAction(theNode));
                }
                this.addMenuItem("Change Term Secondary Name", IconLib.iconRenameTerm, new TypedTreeEditor.DefaultEditCommentsAction(theNode));
                this.addMenuItem("Change Visiblity", IconLib.iconLock, new ChangeSLMAction(theTerm));
                this.popup.add(new JSeparator());
            }
            if (isObsolete) {
                this.addMenuItem("Destroy Term", IconLib.iconDestroyTerm, new DestroyTermAction(theTerm));
            } else if (isDeleted && !hp.isDeleted()) {
                if (theTerm.status == 3) {
                    this.addMenuItem("Undelete Relation", IconLib.iconUndeleteRelation, new UndeleteTermRelationAction(theTerm));
                } else if (theTerm.status == 2) {
                    this.addMenuItem("Undelete Term", IconLib.iconUndelete, new UndeleteTermAction(theTerm));
                }
            } else if (!(readOnly || isDeleted || isMerged)) {
                if (!isCloned) {
                    this.addMenuItem("Clone Term", IconLib.iconCloneTerm, new CloneTermAction(theTerm));
                    this.addMenuItem("Insert Sub Term", IconLib.iconAddSub, new CreateSubTermAction((TypedNode)theTerm));
                    this.addMenuItem("Insert Super Term", IconLib.iconAddSup, new CreateSuperTermAction((TypedNode)theTerm));
                    this.addMenuItem("Split Branch as Package", IconLib.iconSplit, new SplitPackageAction(theTerm));
                    this.popup.add(new JSeparator());
                }
                if (!isTopLevel && !isMerged) {
                    this.addMenuItem("Delete This Relation", IconLib.iconDeleteRelation, new DeleteTermRelationAction(theTerm));
                }
                if (isLeaf && !isMerged && !isCloned) {
                    this.addMenuItem("Delete Term", IconLib.iconDelete, new DeleteTermAction(theTerm));
                    String info = "Drag the term and drop it on the term to be merged";
                    this.addMenuItem("Merge Term with...", IconLib.iconMergeTerm, new DoNothingAction(theTerm, info));
                }
            }
        }
    }

    public void quitEditing(PackageNode thePackageNode) {
        UserManager.cancelEditing(this.db, thePackageNode.getOid(), MOEditor.user.name);
        thePackageNode.setReadOnly(true);
        MOEditor.theInstance.paneDetails.switchPropertyEditor(thePackageNode);
    }

    public void editPackage(PackageNode node) {
        String editor = UserManager.getEditor(this.db, node.getOid());
        if (editor != null) {
            Debug.trace("Requested package '" + node.getLocalName() + "' is edited by user '" + editor + "'");
            return;
        }
        boolean suc = UserManager.beginEditing(this.db, node.getOid(), MOEditor.user.name);
        if (suc) {
            Debug.trace("You can edit terms in package '" + node.getLocalName() + "'");
            node.setReadOnly(false);
            if (!node.expanded) {
                this.expandPackage(node);
            }
        } else {
            Debug.trace("Editing request failed - Unable access the database");
        }
    }

    class ReloadAction
    implements ActionListener {
        PackageNode theNode;

        public ReloadAction(PackageNode theNode) {
            this.theNode = theNode;
        }

        public void actionPerformed(ActionEvent e2) {
            PackageTreeEditor.this.expandPackage(this.theNode);
        }
    }

    class RenameAction
    implements ActionListener {
        public ATOTreeNode theNode;

        public RenameAction(ATOTreeNode theNode) {
            this.theNode = theNode;
        }

        public void actionPerformed(ActionEvent e2) {
            String newName = this.getNewUserObject();
            if (newName != null) {
                this.theNode.rename(newName.toString());
                PackageTreeEditor.this.tree.getModel().reload(this.theNode);
            }
        }

        protected String getNewUserObject() throws HeadlessException {
            String oldName = (String)this.theNode.getUserObject();
            String newName = JOptionPane.showInputDialog("Give the new name of the object", (Object)oldName);
            if (newName == null || oldName.equals(newName)) {
                return null;
            }
            if (!DataType.isLegalName(newName) || "Global".equals(newName)) {
                JOptionPane.showMessageDialog(null, "Name is not legal!");
                return null;
            }
            if (!PackageTreeEditor.this.checkDuplicateName(newName)) {
                return null;
            }
            return newName;
        }
    }

    class CreateSubTermAction
    extends TypedTreeEditor.DeafultCreateSubValueAction {
        public CreateSubTermAction(TypedNode parent) {
            super(parent);
        }

        protected TypedNode getNewNode() {
            return PackageTreeEditor.this.makeNewTermNode(this.parent);
        }
    }

    class CreateSuperTermAction
    extends TypedTreeEditor.DefaultInsertParentAction {
        public CreateSuperTermAction(TypedNode theNode) {
            super(theNode);
        }

        protected TypedNode getNewNode() {
            return PackageTreeEditor.this.makeNewTermNode(this.theNode);
        }
    }

    class ChangeSLMAction
    implements ActionListener {
        public DbTermNode theNode;

        public ChangeSLMAction(DbTermNode theNode) {
            this.theNode = theNode;
        }

        public void actionPerformed(ActionEvent e2) {
            short type = this.theNode.getType();
            Object[] data = new String[]{"public", "protected", "private"};
            String slm = (String)JOptionPane.showInputDialog(null, "Choose one", "Input", 1, null, data, ATOTreeNode.type2slm(type));
            if (slm == null) {
                return;
            }
            if (ATOTreeNode.slm2type(slm) == type) {
                return;
            }
            this.theNode.setType(ATOTreeNode.slm2type(slm));
            PackageTreeEditor.this.changed(this.theNode);
        }
    }

    class ChangeViewModeAction
    implements ActionListener {
        public PackageNode theNode;

        public ChangeViewModeAction(PackageNode theNode) {
            this.theNode = theNode;
        }

        public void actionPerformed(ActionEvent e2) {
            Vector po = OntologySchema.getPartialOrders(PackageTreeEditor.this.db);
            Object[] data = po.toArray();
            String newView = (String)JOptionPane.showInputDialog(null, "Choose one", "Input", 1, null, data, this.theNode.getViewMode());
            if (newView == null || this.theNode.getViewMode().equals(newView)) {
                return;
            }
            this.theNode.setViewMode(newView);
            PackageTreeEditor.this.expandPackage(this.theNode);
        }
    }

    class CreateSubPackageAction
    extends TypedTreeEditor.DeafultCreateSubValueAction {
        public CreateSubPackageAction(PackageNode parent) {
            super(parent);
        }

        protected TypedNode getNewNode() {
            return PackageTreeEditor.this.makeNewPackageNode((PackageNode)this.parent, null);
        }
    }

    class CreateSuperPackageAction
    extends TypedTreeEditor.DefaultInsertParentAction {
        public CreateSuperPackageAction(PackageNode theNode) {
            super(theNode);
        }

        protected TypedNode getNewNode() {
            return PackageTreeEditor.this.makeNewPackageNode((PackageNode)this.theNode, null);
        }
    }

    class DeletePackageAction
    extends TypedTreeEditor.DefaultDeleteAction {
        PackageNode theNode;

        public DeletePackageAction(PackageNode theNode) {
            this.theNode = theNode;
        }

        public void actionPerformed(ActionEvent e2) {
            if (this.theNode.hasSubPackage()) {
                Debug.trace("Cannot delete a package with sub packages. \nPlease delete all sub packages and try again");
                return;
            }
            int answer = JOptionPane.showConfirmDialog(null, "Are you sure to delete (obsolete) all terms(inclued unexpanded) in the package? \nThe package itself will be deleted only if it has no term (including obsoleted terms)");
            if (answer == 0) {
                this.theNode.markDeleted();
                PackageTreeEditor.this.tree.getModel().reload(this.theNode.getParent());
            }
        }
    }

    class DeleteTermRelationAction
    extends TypedTreeEditor.DefaultDeleteAction {
        DbTermNode theNode;

        public DeleteTermRelationAction(DbTermNode theNode) {
            this.theNode = theNode;
        }

        public void actionPerformed(ActionEvent e2) {
            this.theNode.status = (short)3;
            PackageTreeEditor.this.tree.getModel().reload(this.theNode);
        }
    }

    class DeleteTermAction
    extends TypedTreeEditor.DefaultDeleteAction {
        DbTermNode theNode;

        public DeleteTermAction(DbTermNode theNode) {
            this.theNode = theNode;
        }

        public void actionPerformed(ActionEvent e2) {
            this.theNode.markDeleted();
            PackageTreeEditor.this.tree.getModel().reload(this.theNode);
        }
    }

    class EditPackageAction
    implements ActionListener {
        PackageNode theNode;

        public EditPackageAction(PackageNode theNode) {
            this.theNode = theNode;
        }

        public void actionPerformed(ActionEvent e2) {
            PackageTreeEditor.this.editPackage(this.theNode);
        }
    }

    class QuitEditingAction
    implements ActionListener {
        PackageNode thePackageNode;

        public QuitEditingAction(PackageNode theNode) {
            this.thePackageNode = theNode;
        }

        public void actionPerformed(ActionEvent e2) {
            PackageTreeEditor.this.quitEditing(this.thePackageNode);
        }
    }

    class SplitPackageAction
    extends TypedTreeEditor.DeafultCreateSubValueAction {
        DbTermNode theNode;

        public SplitPackageAction(DbTermNode theNode) {
            super(theNode.getHomePackageNode());
            this.theNode = theNode;
        }

        protected TypedNode getNewNode() {
            int answer = JOptionPane.showConfirmDialog(null, "Do you want to make the branch as a new package? ");
            if (answer == 0) {
                PackageNode newPackage = PackageTreeEditor.this.makeNewPackageNode((PackageNode)this.parent, this.theNode.getLocalName() + "Terms");
                if (newPackage != null) {
                    try {
                        PackageTreeEditor.this.editPackage(newPackage);
                        ((PackageTree)PackageTreeEditor.this.tree).moveBranch(this.theNode, newPackage);
                        PackageTreeEditor.this.tree.getModel().reload(newPackage);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                return newPackage;
            }
            return null;
        }
    }

    class DoNothingAction
    implements ActionListener {
        TypedNode theNode;
        String info;

        public DoNothingAction(TypedNode theNode, String info) {
            this.theNode = theNode;
            this.info = info;
        }

        public void actionPerformed(ActionEvent e2) {
            Debug.trace(this.info);
        }
    }

    class CloneTermAction
    implements ActionListener {
        DbTermNode theNode;

        public CloneTermAction(DbTermNode theNode) {
            this.theNode = theNode;
        }

        public void actionPerformed(ActionEvent e2) {
            DbTerm oldTerm = this.theNode.getThisTerm();
            DbTerm newTerm = new DbTerm(null, "copy of " + oldTerm.id, oldTerm.name, oldTerm.package_oid, oldTerm.slm, MOEditor.user.name, null, "false");
            DbTermNode newNode = new DbTermNode(newTerm, this.theNode.getHomePackageNode());
            TypedNode n2 = (TypedNode)this.theNode.getParent();
            n2.add(newNode);
            PackageTreeEditor.this.tree.getModel().reload(n2);
            newNode.status = 1;
        }
    }

    class UndeleteTermRelationAction
    implements ActionListener {
        DbTermNode theNode;

        public UndeleteTermRelationAction(DbTermNode theNode) {
            this.theNode = theNode;
        }

        public void actionPerformed(ActionEvent e2) {
            this.theNode.status = 1;
        }
    }

    class UndeleteTermAction
    implements ActionListener {
        DbTermNode theNode;

        public UndeleteTermAction(DbTermNode theNode) {
            this.theNode = theNode;
        }

        public void actionPerformed(ActionEvent e2) {
            this.theNode.status = 1;
        }
    }

    class UndeletePackageAction
    implements ActionListener {
        PackageNode theNode;

        public UndeletePackageAction(PackageNode theNode) {
            this.theNode = theNode;
        }

        public void actionPerformed(ActionEvent e2) {
            this.theNode.status = 1;
            PackageTree cfr_ignored_0 = PackageTreeEditor.this.thisTree;
            Vector<DbTermNode> terms = PackageTree.getTermsInPackage(this.theNode);
            Iterator<DbTermNode> i$ = terms.iterator();
            while (i$.hasNext()) {
                DbTermNode term = i$.next();
                term.status = 1;
            }
        }
    }

    class DestroyTermAction
    implements ActionListener {
        DbTermNode theNode;

        public DestroyTermAction(DbTermNode theNode) {
            this.theNode = theNode;
        }

        public void actionPerformed(ActionEvent e2) {
            boolean suc;
            int answer = JOptionPane.showConfirmDialog(null, "Are you sure to delete the term permanently ? ");
            if (answer == 0 && (suc = OntologyEdit.destroyTerm(PackageTreeEditor.this.db, this.theNode.getOid()))) {
                PackageTreeEditor.this.tree.delete(this.theNode);
            }
        }
    }

    class ApplyEditorAction
    implements ActionListener {
        PackageNode theNode;

        public ApplyEditorAction(PackageNode theNode) {
            this.theNode = theNode;
        }

        public void actionPerformed(ActionEvent e2) {
            String package_oid = this.theNode.getOid();
            String author = this.theNode.getThisPackage().author;
            String email = OntologyQuerier.getAuthorEmail(PackageTreeEditor.this.db, package_oid);
            OnlineInfo info = UserManager.getOnlineInfo(PackageTreeEditor.this.db, author);
            if (info != null) {
                MoAgent myServer = MOEditor.theInstance.messenger;
                ChatPanel window = myServer.startChat(author, info.host, info.port);
                if (window == null) {
                    Debug.trace("Connot connect to selected user");
                } else {
                    window.showMe();
                    return;
                }
            }
            if (email != null) {
                String body;
                String ontologyName = MOEditor.theInstance.selectedServer.name;
                String userName = MOEditor.user.name;
                String packageName = this.theNode.getLocalName();
                String subject = "\"Apply for editor of ontology '" + ontologyName + "', package '" + packageName + "' from user '" + userName + "'\"";
                boolean suc = EmailTools.sendWindowsEmail(email, subject, body = "From Indus DAG editor");
                if (!suc) {
                    Debug.trace("Failed to send email to " + author + "<" + email + ">");
                }
            }
        }
    }

    class AddEditorAction
    implements ActionListener {
        PackageNode theNode;

        public AddEditorAction(PackageNode theNode) {
            this.theNode = theNode;
        }

        public void actionPerformed(ActionEvent e2) {
            PrivilegeEditor dlg = new PrivilegeEditor(MOEditor.theInstance.mainFrame, MOEditor.theInstance.selectedServer, this.theNode.getOid(), this.theNode.getLocalName());
            GUIUtils.centerWithinParent(dlg);
            dlg.setVisible(true);
        }
    }
}

