/*
 * Decompiled with CFR 0.152.
 */
package edu.iastate.ato.gui.packageview;

import edu.iastate.anthill.indus.datasource.type.DataType;
import edu.iastate.anthill.indus.tree.TypedNode;
import edu.iastate.anthill.indus.tree.TypedTreeEditor;
import edu.iastate.ato.gui.MOEditor;
import edu.iastate.ato.po.DbPackage;
import edu.iastate.ato.po.DbTerm;
import edu.iastate.ato.po.OntologyEdit;
import edu.iastate.ato.po.UserManager;
import edu.iastate.ato.tree.ATOTreeNode;
import edu.iastate.ato.tree.DbTermNode;
import edu.iastate.ato.tree.PackageNode;
import edu.iastate.utils.gui.JStatusBar;
import java.awt.HeadlessException;
import java.sql.Connection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.tree.TreeNode;

public abstract class PackageTreeEditorBasis
extends TypedTreeEditor {
    protected Connection db;
    protected Map<String, Map> privilegeCache = new HashMap<String, Map>();
    public boolean enableInsertParent = true;

    protected String makeDefaultName(TypedNode selected) {
        return MOEditor.theInstance.selectedNamingPolicy.makeNameWhenCreating(selected.getLocalName());
    }

    protected PackageNode makeNewPackageNode(PackageNode selected, String defaultName) {
        String newName;
        if (defaultName == null) {
            defaultName = this.makeDefaultName(selected);
        }
        if ((newName = JOptionPane.showInputDialog("Give the name for new node", (Object)defaultName)) == null) {
            return null;
        }
        if (!DataType.isLegalName(newName) || "Global".equals(newName)) {
            JOptionPane.showMessageDialog(null, "Name is not legal!");
            return null;
        }
        if (this.checkDuplicateName(newName)) {
            DbPackage newPkg = new DbPackage(null, newName, null, MOEditor.user.name, null);
            PackageNode newNode = new PackageNode(newPkg);
            newNode.status = 1;
            newNode.setViewMode(selected.getViewMode());
            newNode.save(this.db);
            OntologyEdit.addPackageNesting(this.db, newNode.getOid(), selected.getOid(), MOEditor.user.name);
            if (MOEditor.user.isNormalRole()) {
                UserManager.addPrivilege(this.db, MOEditor.user.name, newNode.getOid(), "rw");
            }
            return newNode;
        }
        return null;
    }

    protected boolean checkDuplicateName(String newName) {
        TypedNode n2 = (TypedNode)this.tree.getModel().getRoot();
        Enumeration<TreeNode> ee = n2.depthFirstEnumeration();
        while (ee.hasMoreElements()) {
            TypedNode node = (TypedNode)ee.nextElement();
            String name = node.toString();
            if (!name.equals(newName)) continue;
            JOptionPane.showMessageDialog(null, "'" + newName + "' is used, please try again");
            return false;
        }
        return true;
    }

    public void expandPackage(final PackageNode thePackage) {
        final JStatusBar statusBar = MOEditor.theInstance.statusBar;
        Thread t2 = new Thread(){

            public void run() {
                int pb = statusBar.addProgressBar(true, 0, 0);
                statusBar.updateProgressBar(pb, "Load Package " + thePackage.getLocalName());
                try {
                    thePackage.expand(PackageTreeEditorBasis.this.db, statusBar.getProgressBar(pb));
                    PackageTreeEditorBasis.this.tree.getModel().reload(thePackage);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                statusBar.removeProgressBar(pb);
            }
        };
        t2.start();
    }

    protected boolean hasPrivilege(String user, PackageNode pkg) {
        Map editable = this.privilegeCache.get(user);
        if (editable == null) {
            this.privilegeCache.put(user, new HashMap());
        }
        Map editableTable = this.privilegeCache.get(user);
        if (pkg.getOid() == null) {
            editableTable.put(pkg, new Boolean(true));
            return true;
        }
        if (editableTable.get(pkg) != null) {
            return (Boolean)editableTable.get(pkg);
        }
        boolean mayI = UserManager.hasWritePrivilege(this.db, user, pkg.getOid());
        editableTable.put(pkg, new Boolean(mayI));
        return mayI;
    }

    protected void changed(TypedNode theNode) {
        this.tree.getModel().reload(theNode);
        this.tree.expandNode(theNode);
        ((ATOTreeNode)theNode).status = 1;
    }

    protected TypedNode makeNewTermNode(TypedNode selected) throws HeadlessException {
        String defaultName = this.makeDefaultName(selected);
        String newName = JOptionPane.showInputDialog("Give the name for new node", (Object)defaultName);
        if (newName == null) {
            return null;
        }
        if (!MOEditor.theInstance.selectedNamingPolicy.isNameValid(newName)) {
            JOptionPane.showMessageDialog(null, "Name is not legal!");
            return null;
        }
        if (!this.checkDuplicateName(newName)) {
            return null;
        }
        short type = 1006;
        PackageNode home = null;
        if (selected instanceof PackageNode) {
            home = (PackageNode)selected;
        } else if (selected instanceof DbTermNode) {
            home = ((DbTermNode)selected).getHomePackageNode();
        }
        DbTerm t2 = new DbTerm(null, newName, newName, home.getOid(), ATOTreeNode.type2slm(type), MOEditor.user.name, null, "false");
        DbTermNode newNode = new DbTermNode(t2, home);
        newNode.status = 1;
        return newNode;
    }
}

