/*
 * Decompiled with CFR 0.152.
 */
package edu.iastate.ato.gui.packageview;

import edu.iastate.anthill.indus.tree.TypedNode;
import edu.iastate.ato.gui.MOEditor;
import edu.iastate.ato.gui.packageview.PackageTree;
import edu.iastate.ato.po.OntologyEdit;
import edu.iastate.ato.tree.ATOTreeNode;
import edu.iastate.ato.tree.DBTermCloneNode;
import edu.iastate.ato.tree.DbTermNode;
import edu.iastate.ato.tree.PackageNode;
import java.sql.Connection;
import java.util.Iterator;
import java.util.Vector;

public class PackageView2Db {
    Connection db;
    PackageTree tree;

    public PackageView2Db(Connection db2, PackageTree tree) {
        this.db = db2;
        this.tree = tree;
    }

    private void saveNode(TypedNode node) {
        ATOTreeNode atoNode = (ATOTreeNode)node;
        if (atoNode.isReadOnly() || !atoNode.isChanged()) {
            return;
        }
        if (atoNode.status == 1 || atoNode.status == 4) {
            if (atoNode instanceof PackageNode) {
                this.savePackage((PackageNode)node);
            } else if (node instanceof DbTermNode) {
                this.saveTerm((DbTermNode)node);
            }
        }
    }

    private void saveEdge(TypedNode node) {
        ATOTreeNode atoNode = (ATOTreeNode)node;
        if (atoNode.isReadOnly() || !atoNode.isChanged()) {
            return;
        }
        if (atoNode.status == 1) {
            if (atoNode instanceof PackageNode) {
                this.savePackageEdge((PackageNode)node);
            } else if (node instanceof DbTermNode) {
                this.saveTermEdge((DbTermNode)node);
            }
        } else if (atoNode.status == 2) {
            this.deleteNode((ATOTreeNode)node);
        } else if (atoNode.status == 3) {
            this.deleteUpEdge(atoNode);
        }
    }

    private void deleteNode(ATOTreeNode node) {
        ATOTreeNode atoNode = node;
        if (atoNode.isReadOnly() || !atoNode.isChanged()) {
            return;
        }
        if (atoNode.status == 2) {
            if (atoNode instanceof PackageNode) {
                String pkg_oid = ((PackageNode)node).getOid();
                boolean deleted = OntologyEdit.deletePackage(this.db, pkg_oid, MOEditor.user.name);
                if (deleted) {
                    this.tree.delete(node);
                }
            } else if (node instanceof DBTermCloneNode) {
                this.tree.delete(node);
            } else if (node instanceof DbTermNode) {
                DbTermNode theTerm = (DbTermNode)node;
                PackageNode hp = theTerm.getHomePackageNode();
                if (hp.status != 2) {
                    String term_oid = theTerm.getOid();
                    OntologyEdit.obsoleteTerm(this.db, term_oid, MOEditor.user.name);
                }
                theTerm.thisTerm.is_obsolete = "true";
                this.tree.moveNode(node, hp.obsoleteNodes);
                this.tree.getModel().reload(hp.obsoleteNodes);
            }
        }
    }

    private void deleteUpEdge(ATOTreeNode atoNode) {
        ATOTreeNode p2 = (ATOTreeNode)atoNode.getParent();
        if (p2 != null && p2 instanceof DbTermNode) {
            DbTermNode thisTerm = (DbTermNode)atoNode;
            String oid = thisTerm.getOid();
            String parent_oid = ((DbTermNode)p2).getOid();
            String relation = thisTerm.getViewMode();
            OntologyEdit.deleteTermRelation(this.db, oid, parent_oid, relation);
            this.tree.getModel().removeNodeFromParent(atoNode);
            if (thisTerm.cloned.size() == 0 && !(thisTerm instanceof DBTermCloneNode)) {
                this.tree.moveNode(thisTerm, thisTerm.getHomePackageNode());
            } else {
                Iterator<DBTermCloneNode> i$ = thisTerm.cloned.iterator();
                while (i$.hasNext()) {
                    DBTermCloneNode c2 = i$.next();
                    if (c2.isDeleted()) continue;
                    TypedNode ppp = (TypedNode)c2.getParent();
                    this.tree.getModel().removeNodeFromParent(c2);
                    this.tree.moveNode(thisTerm, ppp);
                    this.tree.getModel().reload(c2.getParent());
                    break;
                }
            }
        }
    }

    private void saveTerm(DbTermNode node) {
        if (!(node instanceof DBTermCloneNode)) {
            node.getThisTerm().print();
            node.save(this.db);
        }
    }

    private void saveTermEdge(DbTermNode node) {
        TypedNode parent = (TypedNode)node.getParent();
        if (parent != null && parent instanceof DbTermNode) {
            String parent_oid = ((DbTermNode)parent).getOid();
            OntologyEdit.addTermRelation(this.db, node.getOid(), node.getViewMode(), parent_oid, MOEditor.user.name);
        }
    }

    private void savePackage(PackageNode node) {
        node.save(this.db);
    }

    private void savePackageEdge(PackageNode node) {
        PackageNode parent = (PackageNode)node.getParent();
        if (parent != null) {
            String parent_oid = parent.getOid();
            OntologyEdit.addPackageNesting(this.db, node.getOid(), parent_oid, MOEditor.user.name);
        }
    }

    public void saveTree() {
        Vector<PackageNode> allPackages = this.tree.getAllPackage();
        Iterator<PackageNode> i$ = allPackages.iterator();
        while (i$.hasNext()) {
            PackageNode pkg = i$.next();
            this.saveNode(pkg);
            Vector<DbTermNode> terms = PackageTree.getTermsInPackage(pkg);
            Iterator<DbTermNode> i$2 = terms.iterator();
            while (i$2.hasNext()) {
                DbTermNode term = i$2.next();
                this.saveNode(term);
            }
        }
        Vector<DbTermNode> allMerged = new Vector<DbTermNode>();
        Iterator<PackageNode> i$3 = allPackages.iterator();
        while (i$3.hasNext()) {
            PackageNode pkg = i$3.next();
            this.saveEdge(pkg);
            Vector<DbTermNode> terms = PackageTree.getTermsInPackage(pkg);
            Iterator<DbTermNode> i$4 = terms.iterator();
            while (i$4.hasNext()) {
                DbTermNode term = i$4.next();
                if (term.isMerged()) {
                    allMerged.add(term);
                }
                this.saveEdge(term);
                if (term.isMerged() || !term.isChanged()) continue;
                term.status = 0;
                this.tree.getModel().reload(term);
            }
            pkg.status = 0;
        }
        i$3 = allMerged.iterator();
        while (i$3.hasNext()) {
            DbTermNode mergedNode = (DbTermNode)((Object)i$3.next());
            mergedNode.merge(this.db);
            mergedNode.status = 0;
            this.tree.getModel().reload(mergedNode.mergedWith);
        }
    }
}

