/*
 * Decompiled with CFR 0.152.
 */
package edu.iastate.ato.gui.panel;

import edu.iastate.anthill.indus.tree.TypedNode;
import edu.iastate.anthill.indus.tree.TypedTree;
import edu.iastate.ato.gui.MOEditor;
import edu.iastate.ato.gui.TypedTreePanel;
import edu.iastate.ato.po.OntologySchema;
import edu.iastate.ato.tree.ATOTreeNode;
import edu.iastate.ato.tree.ATOTreeRender;
import edu.iastate.ato.tree.DBTermCloneNode;
import edu.iastate.ato.tree.DbTermNode;
import edu.iastate.ato.tree.MetaTreeNode;
import edu.iastate.ato.tree.Term2Tree;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.JScrollPane;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class NavigationPanel
extends TypedTreePanel {
    Connection db;
    boolean topdown;
    Map<String, Term2Tree> relation2loader = new HashMap<String, Term2Tree>();

    public NavigationPanel(Connection db2, boolean topdown) {
        this.db = db2;
        this.topdown = topdown;
        this.jbInit();
    }

    public void jbInit() {
        ATOTreeRender treeRender = new ATOTreeRender();
        this.treeOntology.setTop(new TypedNode(""));
        this.treeOntology.addMouseListener(new TreeClickListener(this.treeOntology, this.topdown));
        this.treeOntology.setCellRenderer(treeRender);
        JScrollPane jScrollPane2 = new JScrollPane();
        jScrollPane2.getViewport().add(this.treeOntology);
        this.setLayout(new BorderLayout());
        this.add((Component)jScrollPane2, "Center");
    }

    public void onExpand() {
    }

    void update(ATOTreeNode selectedNode1) {
        if (selectedNode1 == null) {
            this.treeOntology.setTop(new TypedNode(""));
        } else if (selectedNode1 instanceof DbTermNode) {
            DbTermNode thisTerm = (DbTermNode)selectedNode1;
            if (thisTerm.getOid() == null) {
                return;
            }
            System.out.println("topdown: " + this.topdown);
            this.relation2loader.clear();
            TypedNode root = new TypedNode(thisTerm.getLocalName() + " ", 1000, (String)thisTerm.getComment());
            this.treeOntology.setTop(root);
            Vector<TreeNode> nodeToExpand = new Vector<TreeNode>();
            Vector v2 = OntologySchema.getPartialOrders(this.db);
            Iterator i$ = v2.iterator();
            while (i$.hasNext()) {
                String relation = (String)i$.next();
                System.out.println("build the " + relation + " tree");
                Term2Tree treeLoader = new Term2Tree(this.db, relation, this.topdown);
                treeLoader.showPackageInformation = true;
                this.relation2loader.put(relation, treeLoader);
                TypedNode node = treeLoader.makeDagFromTerm(thisTerm.getOid(), 1, null);
                MetaTreeNode meta = new MetaTreeNode((Object)relation, null);
                root.add(meta);
                while (node.getChildCount() > 0) {
                    TypedNode nn = (TypedNode)node.getChildAt(0);
                    meta.add(nn);
                }
                if (meta.getChildCount() <= 0) continue;
                nodeToExpand.add(meta.getChildAt(0));
            }
            this.treeOntology.repaint();
            i$ = nodeToExpand.iterator();
            while (i$.hasNext()) {
                TreeNode nn = (TreeNode)i$.next();
                this.treeOntology.expandNode(nn);
            }
        }
    }

    class TreeClickListener
    extends MouseAdapter {
        TypedTree tree;
        boolean topdown;

        public TreeClickListener(TypedTree tree, boolean topdown) {
            this.tree = tree;
            this.topdown = topdown;
        }

        public void mouseClicked(MouseEvent e2) {
            TreePath selPath = this.tree.getPathForLocation(e2.getX(), e2.getY());
            if (selPath == null) {
                return;
            }
            this.tree.setSelectionPath(selPath);
            TypedNode selectedNode = (TypedNode)selPath.getLastPathComponent();
            if (!(selectedNode instanceof DbTermNode)) {
                return;
            }
            String relation = null;
            for (TypedNode p2 = (TypedNode)selectedNode.getParent(); p2 != null; p2 = (TypedNode)p2.getParent()) {
                if (!(p2 instanceof MetaTreeNode)) continue;
                relation = p2.getLocalName();
                break;
            }
            if (e2.getClickCount() == 1) {
                if (selectedNode instanceof DBTermCloneNode) {
                    DbTermNode source = ((DBTermCloneNode)selectedNode).sourceNode;
                    this.tree.expandNode(source);
                    this.tree.setSelectionPath(TypedTree.getPath(source));
                    return;
                }
                if (selectedNode.getChildCount() == 0) {
                    Term2Tree tt = NavigationPanel.this.relation2loader.get(relation);
                    tt.buildDAG(1, (DbTermNode)selectedNode, null);
                }
            } else if (e2.getClickCount() == 2 && selectedNode instanceof DbTermNode) {
                MOEditor.theInstance.getPackageTree().AddTerm(((DbTermNode)selectedNode).getOid());
            }
        }
    }
}

