/*
 * Decompiled with CFR 0.152.
 */
package edu.iastate.ato.gui.wizard;

import edu.iastate.ato.gui.MOEditor;
import edu.iastate.ato.gui.OntologyServerInfo;
import edu.iastate.ato.gui.wizard.PX_Final;
import edu.iastate.ato.gui.wizard.SeverBuilder;
import edu.iastate.ato.po.OntologyServerBuilder;
import edu.iastate.utils.Debug;
import edu.iastate.utils.gui.wizard.WizardPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.SystemColor;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class P05_Publish
extends WizardPanel {
    SeverBuilder parent;
    Connection ontConn;
    PX_Final next;
    BorderLayout borderLayout1 = new BorderLayout();
    JLabel jLabel1 = new JLabel();
    JTextArea jTextArea1 = new JTextArea();
    JScrollPane jScrollPane1 = new JScrollPane();

    public P05_Publish(SeverBuilder parent, Connection ontConn) {
        try {
            this.parent = parent;
            this.ontConn = ontConn;
            this.next = new PX_Final(parent);
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void display() {
    }

    public boolean hasNext() {
        return true;
    }

    public boolean validateNext(List list) {
        try {
            if (this.ontConn == null || this.ontConn.isClosed()) {
                list.add("Ontology server is not connected");
                return false;
            }
            boolean good = OntologyServerBuilder.checkIntegrity(this.ontConn);
            if (!good) {
                list.add("Ontology database has missing table!, please rebuild them");
                return false;
            }
            Set ontologies = MOEditor.theInstance.serverList;
            boolean found = false;
            Iterator i$ = ontologies.iterator();
            while (i$.hasNext()) {
                OntologyServerInfo ont = (OntologyServerInfo)i$.next();
                if (!ont.url.equals(this.ontConn.getMetaData().getURL())) continue;
                Debug.trace("The given ontology server is registered before");
                found = true;
                break;
            }
            if (!found) {
                OntologyServerInfo newInfo = new OntologyServerInfo();
                newInfo.driver = "org.postgresql.Driver";
                newInfo.name = this.parent.p4_init.dbName + "@" + this.parent.p2_host.getHost();
                newInfo.url = this.ontConn.getMetaData().getURL();
                newInfo.user = this.parent.p4_init.user;
                newInfo.password = this.parent.p4_init.pass;
                newInfo.type = "POSTGRE";
                ontologies.add(newInfo);
                String str = "The Ontology server is registered, please click menu '" + MOEditor.theInstance.menuConfig.getText() + "'\n" + "to view the setting or load the ontology \n\n" + "You may publish the ontolgy server as \n" + "\n   URL: " + newInfo.url + "\n   JDBC driver:" + newInfo.driver + "\n   User: " + newInfo.user + "\n   Password: " + newInfo.password + "\n\nYou may login with user 'admin' and password 'admin'\n" + "Please go to User Management Center to change your password!";
                this.next.info.setText(str);
            }
            return true;
        }
        catch (SQLException ex) {
            list.add("Ontology server is not connected");
            return false;
        }
    }

    public WizardPanel next() {
        return this.next;
    }

    public boolean canFinish() {
        return false;
    }

    public boolean validateFinish(List list) {
        return false;
    }

    public void finish() {
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.jLabel1.setText("Step 4: Register Ontology Server Setting");
        this.jTextArea1.setBackground(SystemColor.menu);
        this.jTextArea1.setFont(new Font("Dialog", 0, 15));
        this.jTextArea1.setBorder(BorderFactory.createEtchedBorder());
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setText("Click Next to register the ontology server");
        this.jScrollPane1.getViewport().add(this.jTextArea1);
        this.add((Component)this.jScrollPane1, "Center");
        this.add((Component)this.jLabel1, "North");
    }
}

