/*
 * Decompiled with CFR 0.152.
 */
package edu.iastate.ato.gui.wizard;

import edu.iastate.ato.gui.wizard.P01_Welcome;
import edu.iastate.ato.gui.wizard.P02_Host;
import edu.iastate.ato.gui.wizard.P03_CreateDB;
import edu.iastate.ato.gui.wizard.P04_Initialize;
import edu.iastate.ato.gui.wizard.P05_Publish;
import edu.iastate.ato.po.OntologyServerBuilder;
import edu.iastate.utils.Debug;
import edu.iastate.utils.gui.GUIUtils;
import edu.iastate.utils.gui.wizard.Wizard;
import edu.iastate.utils.gui.wizard.WizardListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.SQLException;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class SeverBuilder
implements WizardListener {
    final JFrame frame = new JFrame("Ontology Server Building Wizard");
    Wizard wizard = new Wizard();
    P01_Welcome p1_welcome = new P01_Welcome(this);
    P02_Host p2_host;
    P03_CreateDB p3_createDB;
    P04_Initialize p4_init;
    P05_Publish p5_publish;

    public SeverBuilder() {
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                SeverBuilder.this.frame.dispose();
            }
        });
        this.wizard.addWizardListener(this);
        this.frame.setContentPane(this.wizard);
        this.frame.setSize(500, 400);
        GUIUtils.centerWithinParent(this.frame);
        this.frame.setVisible(true);
        this.wizard.start(this.p1_welcome);
    }

    public void wizardFinished(Wizard wizard) {
        this.frame.setVisible(false);
        this.frame.dispose();
    }

    public void wizardCancelled(Wizard wizard) {
        try {
            if (this.p4_init.db != null && !this.p4_init.db.isClosed()) {
                this.p4_init.db.close();
            }
        }
        catch (SQLException ex) {
            // empty catch block
        }
        if (this.p3_createDB != null) {
            String msg;
            int answer;
            if (!this.p3_createDB.isExistedDB() && (answer = JOptionPane.showConfirmDialog(this.frame, "Delete new created database '" + this.p3_createDB.getOntDB() + "'? ")) == 0) {
                msg = OntologyServerBuilder.deleteDatabase(this.p3_createDB.superUserConn, this.p3_createDB.getOntDB());
                Debug.trace("Delete database '" + this.p3_createDB.getOntDB() + "'\n\n" + msg);
            }
            if (!this.p3_createDB.isExistedUser() && (answer = JOptionPane.showConfirmDialog(this.frame, "Delete new created user '" + this.p3_createDB.getUser() + "'? ")) == 0) {
                msg = OntologyServerBuilder.deleteUser(this.p3_createDB.superUserConn, this.p3_createDB.getUser());
                Debug.trace("Delete user '" + this.p3_createDB.getUser() + "'\n\n" + msg);
            }
        }
        this.frame.setVisible(false);
        this.frame.dispose();
    }

    public void wizardPanelChanged(Wizard wizard) {
    }
}

