/*
 * Decompiled with CFR 0.152.
 */
package edu.iastate.ato.po;

import edu.iastate.ato.po.DbPackage;
import edu.iastate.ato.po.OntologyEdit;
import edu.iastate.ato.po.OntologySchema;
import edu.iastate.ato.shared.LongTask;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class DB2OBO
extends LongTask {
    public static final String PROPERTY_LEADING = "![attribute]";
    public static final String SCHEMA_LEADING = "![schema]";
    String prefix;
    Map<String, String> packageNameCache = new HashMap<String, String>();

    String makeHeader(String user) {
        String header = "format-version: 1.0\ndate: " + OntologyEdit.getTime() + "\n" + "saved-by: " + user + "\n" + "auto-generated-by: " + "Indus DAG editor" + "\n" + "default-namespace: ato\n\n";
        return header;
    }

    String makeTypedef(String relation) {
        return "[Typedef]\nid: " + relation + "\n" + "name: " + relation + "\n\n";
    }

    String makeComment(String comment) {
        return "comment: " + comment + "\n";
    }

    String makeTerm_Property(String prop, String value) {
        if (OntologySchema.isOBOProperty(prop)) {
            return prop + ": " + value + "\n";
        }
        return PROPERTY_LEADING + prop + ": " + value + "\n";
    }

    public String addPrefix(String id) {
        if (this.prefix != null && this.prefix.trim().length() > 0) {
            return this.prefix + ":" + id;
        }
        return id;
    }

    String makeTerm_Relation(String relation, String parent_id, String parent_name) {
        String str = "relationship: " + relation + " " + this.addPrefix(parent_id);
        if (parent_name != null) {
            str = str + " ! " + parent_name;
        }
        return str + "\n";
    }

    String makePackageRelation(String relation, String parent_id, String parent_name) {
        String str = "relationship: " + relation + " " + parent_id;
        if (parent_name != null) {
            str = str + " ! " + parent_name;
        }
        return str + "\n";
    }

    public void exportOBO(Connection db2, String fileName, String user, boolean withPrefix) {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(fileName));
            this.prefix = withPrefix ? OntologySchema.getPrefix(db2) : null;
            this.packageNameCache.clear();
            out.write(this.makeHeader(user));
            this.exportSchema(db2, out);
            this.exportPackages(db2, out);
            this.exportTerms(db2, out);
            out.close();
        }
        catch (IOException ex) {
            // empty catch block
        }
    }

    private void exportPackages(Connection db2, BufferedWriter out) throws IOException {
        String sql = "SELECT oid, pid, comment, author, modified FROM package";
        try {
            Statement stmt = db2.createStatement();
            ResultSet resultSet = stmt.executeQuery(sql);
            while (resultSet.next()) {
                String oid = resultSet.getString("oid");
                String pid = resultSet.getString("pid");
                String comment = resultSet.getString("comment");
                String author = resultSet.getString("author");
                String modified = resultSet.getString("modified");
                if (pid.equals("Global")) continue;
                out.write("[Package]\n");
                String str = "id: " + pid + "\n";
                str = str + "name: " + (comment == null ? "" : comment) + "\n";
                out.write(str);
                str = this.makeTerm_Property("author", author);
                out.write(str);
                str = this.makeTerm_Property("modified", modified);
                out.write(str);
                sql = "SELECT DISTINCT relation, package.pid AS parent, package.comment AS parent_name FROM pkg_relation, package WHERE pkg_relation.p1 = '" + oid + "' AND pkg_relation.p2 = package.oid";
                Statement stmt2 = db2.createStatement();
                ResultSet resultSet2 = stmt2.executeQuery(sql);
                while (resultSet2.next()) {
                    String relation = resultSet2.getString("relation");
                    String parent = resultSet2.getString("parent");
                    String parent_name = resultSet2.getString("parent_name");
                    str = this.makePackageRelation(relation, parent, parent_name);
                    out.write(str);
                }
                out.write("\n");
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    private String getPackageName(Connection db2, String pkg_oid) {
        String pkgName = this.packageNameCache.get(pkg_oid);
        if (pkgName == null) {
            pkgName = DbPackage.read((Connection)db2, (String)pkg_oid).pid;
            this.packageNameCache.put(pkg_oid, pkgName);
        }
        return pkgName;
    }

    void exportTerms(Connection db2, BufferedWriter out) {
        String sql = "SELECT oid, id, name, slm, package, author, modified, is_obsolete FROM term";
        try {
            System.out.println(sql);
            Statement stmt = db2.createStatement();
            ResultSet resultSet = stmt.executeQuery(sql);
            while (resultSet.next()) {
                String oid = resultSet.getString("oid");
                String id = resultSet.getString("id");
                String name = resultSet.getString("name");
                String author = resultSet.getString("author");
                String modified = resultSet.getString("modified");
                String is_obsolete = resultSet.getString("is_obsolete");
                String package_oid = resultSet.getString("package");
                String slm = resultSet.getString("slm");
                out.write("[Term]\n");
                String str = "id: " + this.addPrefix(id) + "\n";
                str = str + "name: " + (name == null ? "" : name) + "\n";
                out.write(str);
                if (is_obsolete.equalsIgnoreCase("true")) {
                    str = "is_obsolete: true\n";
                    out.write(str);
                }
                str = this.makeTerm_Property("author", author);
                out.write(str);
                str = this.makeTerm_Property("modified", modified);
                out.write(str);
                str = this.getPackageName(db2, package_oid);
                str = this.makeTerm_Property("package", str);
                out.write(str);
                str = this.makeTerm_Property("slm", slm);
                out.write(str);
                sql = "SELECT attribute, value FROM details WHERE term = '" + oid + "'";
                Statement stmt1 = db2.createStatement();
                ResultSet resultSet1 = stmt1.executeQuery(sql);
                while (resultSet1.next()) {
                    String attribute = resultSet1.getString("attribute");
                    String value = resultSet1.getString("value");
                    if (value == null || value.trim().length() <= 0) continue;
                    str = this.makeTerm_Property(attribute, value);
                    out.write(str);
                }
                sql = "SELECT DISTINCT relation, term.id AS parent, term.name AS parent_name FROM relation WHERE id = '" + oid + "' AND relation.pid = term.oid";
                Statement stmt2 = db2.createStatement();
                ResultSet resultSet2 = stmt2.executeQuery(sql);
                while (resultSet2.next()) {
                    String relation = resultSet2.getString("relation");
                    String parent = resultSet2.getString("parent");
                    String parent_name = resultSet2.getString("parent_name");
                    str = this.makeTerm_Relation(relation, parent, parent_name);
                    out.write(str);
                }
                out.write("\n");
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private void exportSchema(Connection db2, BufferedWriter out) throws IOException {
        String str;
        Vector<String> props = OntologySchema.getTermProperties(db2);
        Iterator<String> i$ = props.iterator();
        while (i$.hasNext()) {
            String attr = i$.next();
            String str2 = SCHEMA_LEADING + OntologySchema.TERM_PROPERTY + ":" + attr + "\n";
            out.write(str2);
        }
        String value = OntologySchema.getNamingPolicy(db2);
        if (value != null) {
            str = SCHEMA_LEADING + OntologySchema.NAMING_POLICY + ":" + value + "\n";
            out.write(str);
        }
        if ((value = OntologySchema.getPrefix(db2)) != null) {
            str = SCHEMA_LEADING + OntologySchema.PREFIX + ":" + value + "\n";
            out.write(str);
        }
        out.write("\n");
        Vector relations = OntologySchema.getPartialOrders(db2);
        Iterator i$2 = relations.iterator();
        while (i$2.hasNext()) {
            String relation = (String)i$2.next();
            String str3 = this.makeTypedef(relation);
            out.write(str3);
        }
    }
}

