/*
 * Decompiled with CFR 0.152.
 */
package edu.iastate.ato.po;

import edu.iastate.ato.po.OntologySchema;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.Vector;

public class DB2OWL {
    static String head = "<?xml version=\"1.0\"?>\n<rdf:RDF\n     xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"\n     xmlns:xsd=\"http://www.w3.org/2001/XMLSchema#\"\n     xmlns:rdfs=\"http://www.w3.org/2000/01/rdf-schema#\"\n     xmlns:owl=\"http://www.w3.org/2002/07/owl#\"\n     xmlns=\"http://www.owl-ontologies.com/unnamed.owl#\"\n     xml:base=\"http://www.owl-ontologies.com/unnamed.owl\">\n<owl:Ontology rdf:about=\"\"/>\n<owl:Class rdf:ID=\"Term\"/>\n<owl:DatatypeProperty rdf:ID=\"is_obsolete\">\n      <rdfs:range rdf:resource=\"http://www.w3.org/2001/XMLSchema#boolean\"/>\n      <rdfs:domain rdf:resource=\"#Term\"/>\n</owl:DatatypeProperty>\n";
    static String tail = " </rdf:RDF>";

    static String makeComment(String comment) {
        return "  <rdfs:comment rdf:datatype=\"http://www.w3.org/2001/XMLSchema#string\" >" + comment + "</rdfs:comment>\n";
    }

    static String makeSchema_Relation(String relation) {
        return "<owl:ObjectProperty rdf:ID=\"" + relation + "\">\n" + "  <rdfs:domain rdf:resource=\"#Term\"/>\n" + "</owl:ObjectProperty>\n";
    }

    static String makeSchema_Property(String prop) {
        return "<owl:DatatypeProperty rdf:ID=\"" + prop + "\">\n" + "  <rdfs:domain rdf:resource=\"#Term\"/>\n" + "</owl:DatatypeProperty>\n";
    }

    static String makeTerm_Relation(String relation, String parent) {
        return "  <" + relation + " rdf:resource=\"#" + parent + "\"/>\n";
    }

    static String makeTerm_Property(String prop, String value) {
        return "  <" + prop + " rdf:datatype=\"http://www.w3.org/2001/XMLSchema#string\">" + value + "</" + prop + ">\n";
    }

    public static void exportOWL(Connection db2, String newfile) {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(newfile));
            out.write(head);
            Vector relations = OntologySchema.getPartialOrders(db2);
            Iterator i$ = relations.iterator();
            while (i$.hasNext()) {
                String relation = (String)i$.next();
                String str = DB2OWL.makeSchema_Relation(relation);
                out.write(str);
            }
            Vector<String> properties = OntologySchema.getTermProperties(db2);
            Iterator<String> i$2 = properties.iterator();
            while (i$2.hasNext()) {
                String prop = i$2.next();
                String str = DB2OWL.makeSchema_Property(prop);
                out.write(str);
            }
            String sql = "SELECT oid, id, name, author, modified, is_obsolete FROM term";
            try {
                System.out.println(sql);
                Statement stmt = db2.createStatement();
                ResultSet resultSet = stmt.executeQuery(sql);
                while (resultSet.next()) {
                    String str;
                    String oid = resultSet.getString("oid");
                    String id = resultSet.getString("id");
                    String name = resultSet.getString("name");
                    String author = resultSet.getString("author");
                    String modified = resultSet.getString("modified");
                    String is_obsolete = resultSet.getString("is_obsolete");
                    out.write("<Term rdf:ID=\"" + id + "\">\n");
                    if (name != null) {
                        str = DB2OWL.makeComment("Comments: " + name);
                        out.write(str);
                    }
                    if (is_obsolete.equalsIgnoreCase("true")) {
                        str = "  <is_obsolete rdf:datatype=\"http://www.w3.org/2001/XMLSchema#boolean\">true</is_obsolete>\n";
                        out.write(str);
                    }
                    str = DB2OWL.makeComment("author: " + author);
                    out.write(str);
                    str = DB2OWL.makeComment("modified: " + modified);
                    out.write(str);
                    sql = "SELECT attribute, value FROM details WHERE term = '" + oid + "'";
                    Statement stmt1 = db2.createStatement();
                    ResultSet resultSet1 = stmt1.executeQuery(sql);
                    while (resultSet1.next()) {
                        String attribute = resultSet1.getString("attribute");
                        String value = resultSet1.getString("value");
                        str = DB2OWL.makeTerm_Property(attribute, value);
                        out.write(str);
                    }
                    sql = "SELECT DISTINCT relation, term.id AS parent FROM relation WHERE id = '" + oid + "' AND relation.pid = term.oid";
                    Statement stmt2 = db2.createStatement();
                    ResultSet resultSet2 = stmt2.executeQuery(sql);
                    while (resultSet2.next()) {
                        String relation = resultSet2.getString("relation");
                        String parent = resultSet2.getString("parent");
                        str = DB2OWL.makeTerm_Relation(relation, parent);
                        out.write(str);
                    }
                    out.write("</Term>\n");
                }
            }
            catch (SQLException e2) {
                System.err.println(sql);
                e2.printStackTrace();
            }
            out.write(tail);
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

