/*
 * Decompiled with CFR 0.152.
 */
package edu.iastate.ato.po;

import edu.iastate.ato.gui.MOEditor;
import edu.iastate.ato.po.OntologyEdit;
import edu.iastate.ato.po.OntologyQuerier;
import edu.iastate.utils.sql.JDBCUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;

/*
 * This class specifies class file version 47.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbTerm {
    public String oid;
    public String id;
    public String name;
    public String package_oid;
    public String slm;
    public String author;
    public String modified;
    public String is_obsolete = "false";

    public DbTerm(String oid, String id, String name, String package_oid, String slm, String author, String modified, String is_obsolete) {
        this.oid = oid;
        this.id = id;
        this.name = name;
        this.package_oid = package_oid;
        this.slm = slm;
        this.is_obsolete = is_obsolete;
        this.author = author;
        this.modified = modified;
    }

    public String toString() {
        String str = new StringBuffer().append("oid = ").append(this.oid).append(", id = ").append(this.id).append(", name = ").append(this.name).append(", package oid = ").append(this.package_oid).append(", slm = ").append(this.slm).append(", author = ").append(this.author).append(", modified = ").append(this.modified).append(", is_obsolete = ").append(this.is_obsolete).toString();
        return str;
    }

    public void print() {
        System.out.println(this.toString());
    }

    public static Vector<DbTerm> batchRead(Connection db2, String sqlSelection) {
        String sql = new StringBuffer().append("SELECT oid, id, name, package, slm, author, modified, is_obsolete FROM term WHERE oid IN (").append(sqlSelection).append(")").toString();
        try {
            System.out.println(sql);
            Statement stmt = db2.createStatement();
            ResultSet resultSet = stmt.executeQuery(sql);
            Vector<DbTerm> allTerms = new Vector<DbTerm>();
            while (resultSet.next()) {
                String oid = resultSet.getString("oid");
                String id = resultSet.getString("id");
                String name = resultSet.getString("name");
                String package_oid = resultSet.getString("package");
                String slm = resultSet.getString("slm");
                String author = resultSet.getString("author");
                String modified = resultSet.getString("modified");
                String obsolete = resultSet.getString("is_obsolete");
                DbTerm t2 = new DbTerm(oid, id, name, package_oid, slm, author, modified, obsolete);
                allTerms.add(t2);
            }
            return allTerms;
        }
        catch (SQLException e2) {
            System.err.println(sql);
            e2.printStackTrace();
            return null;
        }
    }

    public static DbTerm read(Connection db2, String oid) throws Exception {
        String sql = new StringBuffer().append("SELECT * FROM term WHERE oid = '").append(oid).append("'").toString();
        try {
            System.out.println(sql);
            Statement stmt = db2.createStatement();
            ResultSet resultSet = stmt.executeQuery(sql);
            if (resultSet.next()) {
                String id = resultSet.getString("id");
                String name = resultSet.getString("name");
                String package_oid = resultSet.getString("package");
                String slm = resultSet.getString("slm");
                String author = resultSet.getString("author");
                String modified = resultSet.getString("modified");
                String obsolete = resultSet.getString("is_obsolete");
                return new DbTerm(oid, id, name, package_oid, slm, author, modified, obsolete);
            }
            throw new Exception(new StringBuffer().append("No such term with oid ").append(oid).toString());
        }
        catch (SQLException e2) {
            System.err.println(sql);
            e2.printStackTrace();
            return null;
        }
    }

    public boolean write(Connection db2) {
        if (this.oid == null) {
            this.author = MOEditor.user.name;
            this.modified = OntologyEdit.getTime();
            String sql = new StringBuffer().append("INSERT INTO term (id, name, package, slm, author, modified, is_obsolete)VALUES (").append(JDBCUtils.toDBString(this.id)).append(", ").append(JDBCUtils.toDBString(this.name)).append(", ").append(JDBCUtils.toDBString(this.package_oid)).append(", ").append(JDBCUtils.toDBString(this.slm)).append(",").append(JDBCUtils.toDBString(this.author)).append(", ").append(JDBCUtils.toDBString(this.modified)).append(", ").append(JDBCUtils.toDBString(this.is_obsolete)).append(")").toString();
            JDBCUtils.updateDatabase(db2, sql);
            this.oid = OntologyQuerier.getTermOid(db2, this.id);
            String newID = MOEditor.theInstance.selectedNamingPolicy.makeNameWhenSaving(this.id);
            if (newID != null && !newID.equals(this.id)) {
                this.id = newID;
                sql = new StringBuffer().append("UPDATE term SET id = '").append(newID).append("' WHERE oid = '").append(this.oid).append("'").toString();
                JDBCUtils.updateDatabase(db2, sql);
            }
            return this.oid != null;
        }
        this.author = MOEditor.user.name;
        this.modified = OntologyEdit.getTime();
        String sql = new StringBuffer().append("UPDATE term SET id = ").append(JDBCUtils.toDBString(this.id)).append(", name = ").append(JDBCUtils.toDBString(this.name)).append(", package = ").append(JDBCUtils.toDBString(this.package_oid)).append(", slm = ").append(JDBCUtils.toDBString(this.slm)).append(", author = ").append(JDBCUtils.toDBString(this.author)).append(", modified = ").append(JDBCUtils.toDBString(this.modified)).append(", is_obsolete = ").append(JDBCUtils.toDBString(this.is_obsolete)).append(" WHERE oid = ").append(JDBCUtils.toDBString(this.oid)).toString();
        return JDBCUtils.updateDatabase(db2, sql);
    }
}

