/*
 * Decompiled with CFR 0.152.
 */
package edu.iastate.ato.po;

import edu.iastate.ato.po.TagValuePair;
import edu.iastate.ato.shared.AtoConstent;
import edu.iastate.ato.tree.PackageNode;
import edu.iastate.utils.lang.SortedVector;
import edu.iastate.utils.sql.JDBCUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

/*
 * This class specifies class file version 47.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OntologyQuerier
implements AtoConstent {
    public static Vector getAllPackages(Connection db2) {
        String sql = "SELECT oid FROM package";
        Vector<String> v2 = new Vector<String>();
        try {
            Statement stmt = db2.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                v2.add(rs.getString(1));
            }
        }
        catch (SQLException ex) {
            return null;
        }
        System.out.println(v2);
        return v2;
    }

    public static Vector<String> getAllTerms(Connection db2, String package_oid) {
        String sql = "SELECT oid FROM term";
        if (package_oid != null) {
            sql = new StringBuffer().append(sql).append(" WHERE package = '").append(package_oid).append("' ").toString();
        }
        System.out.println(sql);
        Vector<String> v2 = new Vector<String>();
        try {
            Statement stmt = db2.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                v2.add(rs.getString(1));
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            return null;
        }
        return v2;
    }

    public static Vector getChildrenPackage(Connection db2, String from_id) {
        String sql = new StringBuffer().append("SELECT p1 FROM pkg_relation WHERE p2 = '").append(from_id).append("' AND relation = '").append("nested_in").append("' ").toString();
        return JDBCUtils.getValues(db2, sql);
    }

    public static String getDirectParentPackage(Connection db2, String from_oid) {
        String sql = new StringBuffer().append("SELECT p2 FROM pkg_relation WHERE p1 = '").append(from_oid).append("' AND relation = '").append("nested_in").append("' ").toString();
        return JDBCUtils.getFirstValue(db2, sql);
    }

    public static Vector getAllParentPackage(Connection db2, String from_oid) {
        String sql = new StringBuffer().append("SELECT p2 FROM bj_super_pkg('").append(from_oid).append("', '").append("nested_in").append("')").toString();
        return JDBCUtils.getValues(db2, sql);
    }

    public static Vector getAllChildrenPackage(Connection db2, String from_oid) {
        String sql = new StringBuffer().append("SELECT p1 FROM bj_sub_pkg('").append(from_oid).append("', '").append("nested_in").append("')").toString();
        return JDBCUtils.getValues(db2, sql);
    }

    public static Vector getAllParentTerm(Connection db2, String from_oid, String relation) {
        String sql = new StringBuffer().append("SELECT pid FROM bj_super_term('").append(from_oid).append("', '").append(relation).append("')").toString();
        return JDBCUtils.getValues(db2, sql);
    }

    public static Vector getAllChildTerm(Connection db2, String from_oid, String relation) {
        String sql = new StringBuffer().append("SELECT id FROM bj_sub_term('").append(from_oid).append("', '").append(relation).append("')").toString();
        return JDBCUtils.getValues(db2, sql);
    }

    public static Vector getParentTerm(Connection db2, String from_id, String relation, boolean inHomePackageOnly, String hp_oid) {
        String relationTable = "relation";
        String childCol = "id";
        String parentCol = "pid";
        String relationCol = "relation";
        String relationType = relation;
        try {
            String sql = new StringBuffer().append("SELECT DISTINCT ").append(parentCol).append(" FROM ").append(relationTable).append(" WHERE ").append(childCol).append("='").append(from_id).append("'").toString();
            if (relationCol != null && relationType != null) {
                sql = new StringBuffer().append(sql).append(" AND ").append(relationCol).append(" ='").append(relationType).append("'").toString();
            }
            if (inHomePackageOnly) {
                sql = new StringBuffer().append(sql).append(" AND pid IN (SELECT oid FROM term WHERE package = '").append(hp_oid).append("')").toString();
            }
            System.out.println(sql);
            Statement stmt = db2.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            SortedVector vec = new SortedVector();
            while (rs.next()) {
                String str = rs.getString(parentCol);
                vec.add(str);
            }
            vec.sort();
            return vec;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static int getNeighborTermCount(Connection db2, boolean topdown, String from_id, String relation, String homePackage_oid) {
        String neighbor = topdown ? "id" : "pid";
        String me = topdown ? "pid" : "id";
        String sql = new StringBuffer().append("SELECT DISTINCT count(").append(neighbor).append(") FROM relation ").append(" WHERE ").append(me).append(" = '").append(from_id).append("'").append(" AND relation = '").append(relation).append("'").toString();
        if (homePackage_oid != null) {
            sql = new StringBuffer().append(sql).append(" AND ").append(neighbor).append(" IN (SELECT oid FROM term ").append(" WHERE package = '").append(homePackage_oid).append("')").toString();
        }
        return JDBCUtils.getCount(db2, sql);
    }

    public static Map<String, Integer> getBatchNeighborCount(Connection db2, boolean topdown, String sqlConditions, String relation, String homePackage_oid) {
        String neighbor = topdown ? "id" : "pid";
        String me = topdown ? "pid" : "id";
        String sql = new StringBuffer().append("SELECT DISTINCT count(").append(neighbor).append(") AS count, ").append(me).append(" AS oid FROM relation ").append(" WHERE ").append(me).append(" IN (").append(sqlConditions).append(")").append(" AND relation = '").append(relation).append("'").toString();
        if (homePackage_oid != null) {
            sql = new StringBuffer().append(sql).append(" AND ").append(neighbor).append(" IN (SELECT oid FROM term ").append(" WHERE package = '").append(homePackage_oid).append("')").toString();
        }
        sql = new StringBuffer().append(sql).append(" GROUP BY ").append(me).toString();
        try {
            System.out.println(sql);
            Statement stmt = db2.createStatement();
            ResultSet resultSet = stmt.executeQuery(sql);
            HashMap<String, Integer> m2 = new HashMap<String, Integer>();
            while (resultSet.next()) {
                int count = resultSet.getInt(1);
                String oid = resultSet.getString(2);
                m2.put(oid, new Integer(count));
            }
            return m2;
        }
        catch (SQLException e2) {
            e2.printStackTrace();
            return null;
        }
    }

    public static Vector getChildrenTerm(Connection db2, String from_id, String relation, boolean inHomePackageOnly, String homePackage_oid) {
        String relationTable = "relation";
        String childCol = "id";
        String parentCol = "pid";
        String relationCol = "relation";
        String relationType = relation;
        try {
            String sql = new StringBuffer().append("SELECT DISTINCT ").append(childCol).append(" FROM ").append(relationTable).append(" WHERE ").append(parentCol).append("='").append(from_id).append("'").toString();
            if (relationCol != null && relationType != null) {
                sql = new StringBuffer().append(sql).append(" AND ").append(relationCol).append(" ='").append(relationType).append("'").toString();
            }
            if (inHomePackageOnly) {
                sql = new StringBuffer().append(sql).append(" AND id IN (SELECT oid FROM term WHERE package = '").append(homePackage_oid).append("')").toString();
            }
            System.out.println(sql);
            Statement stmt = db2.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            SortedVector vec = new SortedVector();
            while (rs.next()) {
                String str = rs.getString(childCol).trim();
                vec.add(str);
            }
            vec.sort();
            return vec;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static String getDirectSubclassCount(Connection db2, String term_oid, String relation) {
        String sql = new StringBuffer().append("SELECT count(*) FROM (SELECT DISTINCT id FROM relation WHERE pid = '").append(term_oid).append("' AND relation = '").append(relation).append("') AS foo").toString();
        return JDBCUtils.getFirstValue(db2, sql);
    }

    public static String getDirectSuperclassCount(Connection db2, String term_oid, String relation) {
        String sql = new StringBuffer().append("SELECT count(*) FROM (SELECT DISTINCT pid FROM relation WHERE id = '").append(term_oid).append("' AND relation = '").append(relation).append("') AS foo").toString();
        return JDBCUtils.getFirstValue(db2, sql);
    }

    public static String getTermAuthor(Connection db2, String term_oid) {
        String sql = new StringBuffer().append("SELECT author FROM term WHERE oid = '").append(term_oid).append("'").toString();
        return JDBCUtils.getFirstValue(db2, sql);
    }

    public static String getTermModifiedTime(Connection db2, String term_oid) {
        String sql = new StringBuffer().append("SELECT modified FROM term WHERE oid = '").append(term_oid).append("'").toString();
        return JDBCUtils.getFirstValue(db2, sql);
    }

    public static String getHomePackage(Connection db2, String term_oid) {
        String sql = new StringBuffer().append("SELECT package FROM term WHERE oid = '").append(term_oid).append("'").toString();
        return JDBCUtils.getFirstValue(db2, sql);
    }

    public static String getOneFather(Connection db2, String term_oid, String relation, boolean inHomePackage) {
        String sql = new StringBuffer().append("SELECT r.pid FROM relation r  WHERE r.id = '").append(term_oid).append("' ").append(" AND r.relation = '").append(relation).append("' ").toString();
        if (inHomePackage) {
            sql = new StringBuffer().append(sql).append(" AND r.pid IN(SELECT term.oid FROM term WHERE package IN (SELECT package FROM term WHERE oid = '").append(term_oid).append("') )").toString();
        }
        return JDBCUtils.getFirstValue(db2, sql);
    }

    public static Vector getIsolatedTerms(Connection db2, String relation) {
        String sql = new StringBuffer().append("SELECT oid FROM term WHERE is_obsolete = 'false' AND oid NOT IN   (SELECT id FROM relation WHERE relation = '").append(relation).append("') AND ").append("  oid NOT IN ").append(" (SELECT pid FROM relation WHERE relation = '").append(relation).append("')").toString();
        return JDBCUtils.getValues(db2, sql);
    }

    public static Vector<TagValuePair> getTermAllProperty(Connection db2, String term_oid) {
        String sql = new StringBuffer().append("SELECT attribute, value FROM details WHERE term = '").append(term_oid).append("'").toString();
        Vector<String[]> v2 = JDBCUtils.getValues(db2, sql, 2);
        Vector<TagValuePair> result = new Vector<TagValuePair>();
        for (String[] pair : v2) {
            TagValuePair p2 = new TagValuePair(pair[0], pair[1]);
            result.add(p2);
        }
        return result;
    }

    public static String getTermProperty(Connection db2, String term_oid, String property) {
        String sql = new StringBuffer().append("SELECT value FROM details WHERE term = '").append(term_oid).append("' AND attribute = '").append(property).append("'").toString();
        String value = JDBCUtils.getFirstValue(db2, sql);
        return value;
    }

    public static String getPackageOid(Connection db2, String pid) {
        String sql = new StringBuffer().append("SELECT oid FROM package WHERE pid = '").append(pid).append("'").toString();
        return JDBCUtils.getFirstValue(db2, sql);
    }

    public static String getTermOid(Connection db2, String id) {
        String sql = new StringBuffer().append("SELECT oid FROM term WHERE id = '").append(id).append("'").toString();
        return JDBCUtils.getFirstValue(db2, sql);
    }

    public static Vector getObsoleteTerm(Connection db2, String pkg_oid) {
        String sql = "SELECT oid, id FROM term WHERE is_obsolete = 'true' ";
        if (pkg_oid != null) {
            sql = new StringBuffer().append(sql).append(" AND package = '").append(pkg_oid).append("' ").toString();
        }
        sql = new StringBuffer().append(sql).append("ORDER BY id").toString();
        return JDBCUtils.getValues(db2, sql);
    }

    public static int getObsoleteTermCount(Connection db2, PackageNode homePackage) {
        String sql = "SELECT count(oid) FROM term WHERE is_obsolete = 'true' ";
        if (homePackage != null) {
            String pkgOid = homePackage.getOid();
            sql = new StringBuffer().append(sql).append(" AND package = '").append(pkgOid).append("' ").toString();
        }
        return JDBCUtils.getCount(db2, sql);
    }

    public static Vector<String> getRootTerms(Connection db2, String relation, boolean topdown, boolean includeIsolatedTerm, PackageNode homePackage) {
        String sql = OntologyQuerier.getRootTermsSQL(db2, relation, topdown, includeIsolatedTerm, homePackage);
        return JDBCUtils.getValues(db2, sql);
    }

    public static String getRootTermsSQL(Connection db2, String relation, boolean topdown, boolean includeIsolatedTerm, PackageNode homePackage) {
        String sql = "";
        if (topdown) {
            String thePackage;
            sql = "SELECT oid  FROM term WHERE is_obsolete = 'false' AND ";
            if (homePackage != null) {
                thePackage = homePackage.getOid();
                sql = new StringBuffer().append(sql).append("package = '").append(thePackage).append("' AND ").toString();
            }
            sql = new StringBuffer().append(sql).append("oid NOT IN (SELECT id FROM relation WHERE relation.relation = '").append(relation).append("'").toString();
            if (homePackage != null) {
                thePackage = homePackage.getOid();
                sql = new StringBuffer().append(sql).append(" AND pid IN (SELECT oid FROM term WHERE package = '").append(thePackage).append("') ").toString();
            }
            sql = new StringBuffer().append(sql).append(") ").toString();
            if (!includeIsolatedTerm) {
                sql = new StringBuffer().append(sql).append("AND oid IN (SELECT pid FROM relation  WHERE relation.relation = '").append(relation).append("')").toString();
            }
            sql = new StringBuffer().append(sql).append(" ORDER BY id").toString();
        } else {
            String thePackage;
            sql = "SELECT oid FROM term WHERE is_obsolete = 'false' AND ";
            if (homePackage != null) {
                thePackage = homePackage.getOid();
                sql = new StringBuffer().append(sql).append("package = '").append(thePackage).append("' AND  ").toString();
            }
            sql = new StringBuffer().append(sql).append("oid NOT IN (SELECT pid FROM relation WHERE relation.relation = '").append(relation).append("'").toString();
            if (homePackage != null) {
                thePackage = homePackage.getOid();
                sql = new StringBuffer().append(sql).append(" AND id IN (SELECT id FROM term WHERE package = '").append(thePackage).append("') ").toString();
            }
            sql = new StringBuffer().append(sql).append(") ").toString();
            if (!includeIsolatedTerm) {
                sql = new StringBuffer().append(sql).append("AND oid IN (SELECT id FROM relation  WHERE relation.relation = '").append(relation).append("')").toString();
            }
            sql = new StringBuffer().append(sql).append(" ORDER BY id ").toString();
        }
        return sql;
    }

    public static boolean isVisible(Connection db2, String term_oid, String pkg_oid) {
        String sql = new StringBuffer().append("SELECT slm FROM term WHERE oid = '").append(term_oid).append("'").toString();
        String slm = JDBCUtils.getFirstValue(db2, sql);
        sql = new StringBuffer().append("SELECT package FROM term WHERE oid = '").append(term_oid).append("'").toString();
        String hp_oid = JDBCUtils.getFirstValue(db2, sql);
        if ("public".equals(slm)) {
            return true;
        }
        if ("private".equals(slm)) {
            return pkg_oid.equals(hp_oid);
        }
        if ("protected".equals(slm)) {
            return OntologyQuerier.isNestedIn(db2, hp_oid, pkg_oid) || pkg_oid.equals(hp_oid);
        }
        return false;
    }

    public static boolean isNestedIn(Connection db2, String pkg1_oid, String pkg2_oid) {
        String father = OntologyQuerier.getDirectParentPackage(db2, pkg1_oid);
        while (father != null) {
            if (father.equals(pkg2_oid)) {
                return true;
            }
            father = OntologyQuerier.getDirectParentPackage(db2, father);
        }
        return false;
    }

    public static Vector getTopLevelPackage(Connection db2) {
        String sql = "SELECT oid FROM package WHERE oid NOT IN (  SELECT p1 FROM pkg_relation WHERE relation = 'nested_in' AND p2 IS NOT NULL);";
        return JDBCUtils.getValues(db2, sql);
    }

    public static int getTermCount(Connection db2, String pkg_oid) {
        String sql = "SELECT count(*) FROM term";
        if (pkg_oid != null) {
            sql = new StringBuffer().append(sql).append(" WHERE package = '").append(pkg_oid).append("'").toString();
        }
        return JDBCUtils.getCount(db2, sql);
    }

    public static boolean isPackageExist(Connection db2, String oid) {
        return JDBCUtils.getCount(db2, "package", new StringBuffer().append("oid='").append(oid).append("'").toString()) > 0;
    }

    public static Vector getVisibleTerms(Connection db2, String package_oid) {
        String sql = "SELECT oid FROM term WHERE slm = 'public'";
        if (package_oid != null) {
            sql = new StringBuffer().append(sql).append(" AND package = '").append(package_oid).append("' ").toString();
        }
        Vector<String> v2 = new Vector<String>();
        try {
            Statement stmt = db2.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                v2.add(rs.getString(1));
            }
        }
        catch (SQLException ex) {
            return null;
        }
        System.out.println(v2);
        return v2;
    }

    public static String getAuthorEmail(Connection db2, String package_oid) {
        String sql = new StringBuffer().append("SELECT users.email FROM package, users WHERE package.author = users.id AND oid = '").append(package_oid).append("' ").toString();
        return JDBCUtils.getFirstValue(db2, sql);
    }
}

