/*
 * Decompiled with CFR 0.152.
 */
package edu.iastate.ato.po;

import edu.iastate.ato.gui.MOEditor;
import edu.iastate.ato.gui.OntologyServerInfo;
import edu.iastate.ato.po.OntologySchema;
import edu.iastate.ato.po.naming.BasicNamingPolicy;
import edu.iastate.utils.Debug;
import edu.iastate.utils.sql.JDBCUtils;
import edu.iastate.utils.sql.LocalDBConnection;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Vector;

public class OntologyServerBuilder {
    public static String createUser(Connection db2, String user, String pass) {
        String sql = "CREATE USER " + user + " WITH PASSWORD '" + pass + "'";
        return JDBCUtils.updateDatabaseM(db2, sql);
    }

    public static String deleteUser(Connection db2, String user) {
        String sql = "DROP USER " + user;
        return JDBCUtils.updateDatabaseM(db2, sql);
    }

    public static String createDatabase(Connection db2, String dbName, String owner) {
        String sql = "CREATE DATABASE " + dbName + " OWNER " + owner;
        return JDBCUtils.updateDatabaseM(db2, sql);
    }

    public static Connection createDatabase(Connection db2, String dbName, String owner, String password) throws Exception {
        String sql = "CREATE DATABASE " + dbName + " OWNER " + owner;
        boolean suc = true;
        try {
            System.out.println("     " + sql);
            PreparedStatement updatest = db2.prepareStatement(sql);
            updatest.executeUpdate();
            updatest.close();
        }
        catch (SQLException ex) {
            suc = false;
            throw ex;
        }
        if (suc) {
            LocalDBConnection ds = new LocalDBConnection();
            DatabaseMetaData dmt = db2.getMetaData();
            ds.setDriver("org.postgresql.Driver");
            String url = dmt.getURL();
            int pos = url.indexOf("://");
            pos = url.indexOf("/", pos + 3);
            String host = url.substring(0, pos);
            ds.setUrl(host + "/" + dbName);
            ds.setUser(owner);
            ds.setPassword(password);
            System.out.println(ds);
            ds.connect();
            return ds.db;
        }
        return null;
    }

    public static String clearDatabase(Connection db2, boolean deleteAdmin) {
        String sql = "DELETE FROM auto_id; DELETE FROM details; DELETE FROM package; DELETE FROM pkg_relation; DELETE FROM online; DELETE FROM privilege; DELETE FROM relation; DELETE FROM schema; DELETE FROM term; DELETE FROM users " + (deleteAdmin ? ";" : " WHERE role <> 'admin';") + "DELETE FROM editing; ";
        JDBCUtils.updateDatabaseM(db2, sql);
        return OntologyServerBuilder.initData(db2);
    }

    public static String deleteDatabase(Connection db2, String dbName) {
        String sql = "DROP DATABASE " + dbName;
        String message = JDBCUtils.updateDatabaseM(db2, sql);
        return message;
    }

    public static String createTables(Connection db2, String user) {
        String sql = "CREATE TABLE auto_id\n(\n  id serial NOT NULL,\n  term_oid varchar(255),\n  CONSTRAINT auto_id_pkey PRIMARY KEY (id)\n) \nWITHOUT OIDS;\nALTER TABLE auto_id OWNER TO $user$;\n\nCREATE TABLE details\n(\n  term varchar(255),\n  attribute varchar(255),\n  value text,\n  author varchar(255),\n  modified varchar(32)\n) \nWITHOUT OIDS;\nALTER TABLE details OWNER TO $user$;\nCOMMENT ON COLUMN details.term IS 'term oid';\n\nCREATE TABLE editing\n(\n  package varchar(256),\n  usr varchar(256)\n) \nWITHOUT OIDS;\nALTER TABLE editing OWNER TO $user$;\nGRANT ALL ON TABLE editing TO $user$;\nCOMMENT ON COLUMN editing.package IS 'package oid';\n\nCREATE TABLE online\n(\nuser_id varchar(256) NOT NULL,\nhost varchar(32) NOT NULL,\nport varchar(8) NOT NULL,\nlogin_time varchar(32) NOT NULL\n) \nWITHOUT OIDS;\nALTER TABLE online OWNER TO ato;\nCOMMENT ON TABLE online IS 'Who it online';\nCREATE TABLE package\n(\n  pid varchar(255) NOT NULL,\n  \"comment\" varchar(256),\n  author varchar(255),\n  modified varchar(32),\n  CONSTRAINT package_pkey PRIMARY KEY (pid)\n) \nWITH OIDS;\nALTER TABLE package OWNER TO $user$;\n\nCREATE TABLE pkg_relation\n(\n  p1 varchar(255) NOT NULL,\n  relation varchar(255) NOT NULL,\n  p2 varchar(255) NOT NULL,\n  author varchar(256),\n  modified varchar(32),\n  CONSTRAINT pkg_relation_pkey PRIMARY KEY (p1, relation, p2)\n) \nWITHOUT OIDS;\nALTER TABLE pkg_relation OWNER TO $user$;\n\nCREATE TABLE privilege\n(\n  package_oid varchar(32),\n  user_id varchar(255),\n  rights varchar(8)\n) \nWITH OIDS;\nALTER TABLE privilege OWNER TO $user$;\n\nCREATE TABLE relation\n(\n  id varchar(255) NOT NULL,\n  pid varchar(255) NOT NULL,\n  relation varchar(255) NOT NULL,\n  author varchar(256),\n  modified varchar(32)\n) \nWITH OIDS;\nALTER TABLE relation OWNER TO $user$;\nCOMMENT ON COLUMN relation.id IS 'the child term oid\n';\nCOMMENT ON COLUMN relation.pid IS 'the parent term oid';\n\nCREATE TABLE \"schema\"\n(\n  \"type\" varchar(32) NOT NULL,\n  name varchar(256) NOT NULL,\n  CONSTRAINT schema_pkey PRIMARY KEY (\"type\", name)\n) \nWITHOUT OIDS;\nALTER TABLE \"schema\" OWNER TO $user$;\n\n\nCREATE TABLE term\n(\n  id varchar(255) NOT NULL,\n  name varchar(255),\n  package varchar(255),\n  slm varchar(10),\n  author varchar(256),\n  modified varchar,\n  is_obsolete varchar(5) DEFAULT 'false'::character varying,\n  CONSTRAINT term_pkey PRIMARY KEY (id)\n) \nWITH OIDS;\nALTER TABLE term OWNER TO $user$;\n\nCREATE TABLE users\n(\n  id varchar(255) NOT NULL,\n  role varchar(32) NOT NULL,\n  name varchar(255),\n  institution varchar(255),\n  email varchar(32) NOT NULL,\n  pass varchar(32) NOT NULL,\n  create_date varchar(32),\n  CONSTRAINT user_pkey PRIMARY KEY (id)\n) \nWITHOUT OIDS;\nALTER TABLE users OWNER TO $user$;\nGRANT ALL ON TABLE users TO $user$;";
        sql = sql.replaceAll("\\$user\\$", user);
        return JDBCUtils.updateDatabaseM(db2, sql);
    }

    public static String createFunctions(Connection db2, String user) {
        String sql = "CREATE OR REPLACE FUNCTION bj_sub_pkg(\"varchar\", \"varchar\")\n  RETURNS SETOF pkg_relation AS\n$BODY$\n\nDECLARE \n   _row      pkg_relation%ROWTYPE;\n   _id       ALIAS FOR $1;\n   _relation ALIAS FOR $2;\n\nBEGIN\n\n    SELECT INTO _row * FROM pkg_relation WHERE p2 = _id;\n\n    WHILE FOUND LOOP\n        RETURN NEXT _row;\n        SELECT INTO _row * FROM pkg_relation WHERE p2 = _row.p1 and relation = _relation;\n    END LOOP;\n    RETURN;\nEND\n\n$BODY$\n  LANGUAGE 'plpgsql' VOLATILE;\nALTER FUNCTION bj_sub_pkg(\"varchar\", \"varchar\") OWNER TO $user$;\n\nCREATE OR REPLACE FUNCTION bj_sub_term(\"varchar\", \"varchar\")\n  RETURNS SETOF relation AS\n$BODY$\n\nDECLARE \n   _row      relation%ROWTYPE;\n   _id       ALIAS FOR $1;\n   _relation ALIAS FOR $2;\n\nBEGIN\n\n    SELECT INTO _row * FROM relation WHERE pid = _id;\n\n    WHILE FOUND LOOP\n        RETURN NEXT _row;\n        SELECT INTO _row * FROM relation \n        WHERE pid = _row.id and relation = _relation;\n    END LOOP;\n    RETURN;\nEND\n\n$BODY$\n  LANGUAGE 'plpgsql' VOLATILE;\nALTER FUNCTION bj_sub_term(\"varchar\", \"varchar\") OWNER TO $user$;\n\n\nCREATE OR REPLACE FUNCTION bj_super_pkg(\"varchar\", \"varchar\")\n  RETURNS SETOF pkg_relation AS\n$BODY$\n\nDECLARE \n   _row      pkg_relation%ROWTYPE;\n   _id       ALIAS FOR $1;\n   _relation ALIAS FOR $2;\n\nBEGIN\n\n    SELECT INTO _row * FROM pkg_relation WHERE p1 = _id;\n\n    WHILE  FOUND LOOP\n        RETURN NEXT _row;\n        SELECT INTO _row * FROM pkg_relation WHERE p1 = _row.p2 and relation = _relation;\n    END LOOP;\n    RETURN;\nEND\n\n$BODY$\n  LANGUAGE 'plpgsql' VOLATILE;\nALTER FUNCTION bj_super_pkg(\"varchar\", \"varchar\") OWNER TO $user$;\n\nCREATE OR REPLACE FUNCTION bj_super_term(\"varchar\", \"varchar\")\n  RETURNS SETOF relation AS\n$BODY$\n\nDECLARE \n   _row      relation%ROWTYPE;\n   _id       ALIAS FOR $1;\n   _relation ALIAS FOR $2;\n\nBEGIN\n\n    SELECT INTO _row * FROM relation WHERE id = _id;\n\n    WHILE FOUND LOOP\n        RETURN NEXT _row;\n        SELECT INTO _row * FROM relation \n        WHERE id = _row.pid and relation = _relation;\n    END LOOP;\n    RETURN;\nEND\n\n$BODY$\n  LANGUAGE 'plpgsql' VOLATILE;\nALTER FUNCTION bj_super_term(\"varchar\", \"varchar\") OWNER TO $user$;";
        sql = sql.replaceAll("\\$user\\$", user);
        return JDBCUtils.updateDatabaseM(db2, sql);
    }

    public static String initData(Connection db2) {
        String sql = "SELECT count(id) FROM users WHERE id = 'admin'";
        int adminCount = JDBCUtils.getCount(db2, sql);
        sql = "INSERT INTO users (id, role, name, email, pass) VALUES ('guest','guest','guest','null', 'guest'); \nINSERT INTO package (pid) VALUES ('Global');\nINSERT INTO schema (type, name) VALUES ('" + OntologySchema.NAMING_POLICY + "','" + BasicNamingPolicy.policyName + "');" + "INSERT INTO schema (type, name) VALUES ('" + OntologySchema.PARTIAL_ORDER + "','is_a');";
        if (adminCount == 0) {
            sql = sql + "INSERT INTO users (id, role, name, email, pass) VALUES ('admin','admin','admin','null', 'admin'); \n";
        }
        return JDBCUtils.updateDatabaseM(db2, sql);
    }

    public static boolean checkIntegrity(Connection db2) {
        Vector allTables = JDBCUtils.getAllTable(db2);
        return allTables.contains("auto_id") && allTables.contains("details") && allTables.contains("editing") && allTables.contains("package") && allTables.contains("pkg_relation") && allTables.contains("privilege") && allTables.contains("relation") && allTables.contains("schema") && allTables.contains("term") && allTables.contains("users");
    }

    public static void main(String[] args) {
        LocalDBConnection ds = MOEditor.getConnection(OntologyServerInfo.getAtoOntology());
        ds.connect();
        try {
            OntologyServerBuilder.deleteDatabase(ds.db, "test2");
            Connection db2 = OntologyServerBuilder.createDatabase(ds.db, "test2", "ato", "ato");
            if (db2 != null) {
                OntologyServerBuilder.createTables(db2, "testuser");
                OntologyServerBuilder.createFunctions(db2, "testuser");
                OntologyServerBuilder.initData(db2);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Debug.trace(ex.getMessage());
        }
        ds.disconnect();
    }
}

