/*
 * Decompiled with CFR 0.152.
 */
package edu.iastate.ato.po.naming;

import edu.iastate.ato.po.OntologyEdit;
import edu.iastate.ato.po.naming.NamingPolicy;
import java.sql.Connection;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class AutomaticNamingPolicy
extends NamingPolicy {
    String namingPattern = "0000000";
    NumberFormat formatter = new DecimalFormat(this.namingPattern);
    Connection db;
    protected static String policyName = "Automatic Naming Policy";

    public AutomaticNamingPolicy(Connection db2) {
        this.enableRename = false;
        this.uniqueRequired = true;
        this.db = db2;
    }

    public String makeNameWhenSaving(String term_id) {
        String auto_id = OntologyEdit.applyID(this.db, term_id);
        int id = Integer.parseInt(auto_id);
        String s2 = this.formatter.format(id);
        return s2;
    }

    public String getExplanation() {
        String str = "* Policy name: " + policyName;
        str = str + "\n* Rename enabled: " + this.enableRename;
        str = str + "\n* Unique name required: " + this.uniqueRequired;
        str = str + "\n* New created term will have a temporary name";
        str = str + "\n* Term name is assigned when term is saved";
        return str;
    }

    public String getPolicyName() {
        return policyName;
    }

    public String makeNameWhenCreating(String baseName) {
        return this.makeTimeStampName();
    }

    public boolean isNameValid(String name) {
        return true;
    }
}

