/*
 * Decompiled with CFR 0.152.
 */
package edu.iastate.ato.tree;

import edu.iastate.anthill.indus.iterator.DBTreeNode;
import java.awt.Color;
import java.sql.Connection;
import java.util.HashMap;

public abstract class ATOTreeNode
extends DBTreeNode {
    private boolean readOnly = true;
    String oid;
    public static final short UNMODIFIED = 0;
    public static final short MODIFIED = 1;
    public static final short DELETED_NODE = 2;
    public static final short DELETED_UPEDGE = 3;
    public static final short MERGED = 4;
    public static final short ROOT = 1000;
    public static final short SPECIES = 1001;
    public static final short CLASS = 1002;
    public static final short TYPE = 1003;
    public static final short TRAIT = 1004;
    public static final short PACKAGE = 1005;
    public static final short PUBLIC_TERM = 1006;
    public static final short PRIVATE_TERM = 1007;
    public static final short PROTECTED_TERM = 1008;
    public static final short META = 10000;
    public short status = 0;

    public abstract String getViewMode();

    public abstract void save(Connection var1);

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean r2) {
        this.readOnly = r2;
    }

    public String status2string() {
        if (this.status == 0) {
            return "Unmodified";
        }
        if (this.status == 1) {
            return "Modified";
        }
        if (this.status == 2) {
            return "Deleted with all relations";
        }
        if (this.status == 3) {
            return "Relation to parent deleted";
        }
        return null;
    }

    public static String type2slm(short type) {
        if (type == 1006) {
            return "public";
        }
        if (type == 1007) {
            return "private";
        }
        if (type == 1008) {
            return "protected";
        }
        return null;
    }

    public static short slm2type(String slm) {
        if (slm == null) {
            return 0;
        }
        if (slm.equals("public")) {
            return 1006;
        }
        if (slm.equals("private")) {
            return 1007;
        }
        if (slm.equals("protected")) {
            return 1008;
        }
        return 0;
    }

    public ATOTreeNode(Object id, Object externalText, short type) {
        super(id, externalText);
        this.comment = externalText;
        this.setType(type);
    }

    public boolean isDeleted() {
        return this.status == 2 || this.status == 3;
    }

    public boolean isMerged() {
        return this.status == 4;
    }

    public boolean isChanged() {
        return this.status != 0;
    }

    public Color getColor() {
        if (this.isReadOnly()) {
            return Color.lightGray;
        }
        HashMap<Short, Color> m2 = new HashMap<Short, Color>();
        m2.put(new Short(0), Color.black);
        m2.put(new Short(1), Color.red);
        m2.put(new Short(4), Color.red);
        m2.put(new Short(2), Color.cyan);
        m2.put(new Short(3), Color.blue);
        this.color = (Color)m2.get(new Short(this.status));
        return this.color;
    }

    public void rename(String newName) {
        this.setUserObject(newName);
        this.status = 1;
    }
}

