/*
 * Decompiled with CFR 0.152.
 */
package edu.iastate.ato.tree;

import edu.iastate.anthill.indus.tree.TypedNode;
import edu.iastate.ato.gui.MOEditor;
import edu.iastate.ato.gui.packageview.PackageTree;
import edu.iastate.ato.po.DbPackage;
import edu.iastate.ato.po.OntologyQuerier;
import edu.iastate.ato.shared.IconLib;
import edu.iastate.ato.tree.ATOTreeNode;
import edu.iastate.ato.tree.DbTermNode;
import edu.iastate.ato.tree.MetaTreeNode;
import edu.iastate.ato.tree.Term2Tree;
import edu.iastate.utils.Debug;
import edu.iastate.utils.lang.StopWatch;
import java.sql.Connection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;

public class PackageNode
extends ATOTreeNode {
    private DbPackage thisPackage;
    public boolean expanded = false;
    public MetaTreeNode obsoleteNodes;
    int max = 200;
    public Term2Tree treeLoader;
    int termNumber = -1;
    private String viewMode = null;

    public void markDeleted() {
        this.status = (short)2;
        Vector<DbTermNode> terms = PackageTree.getTermsInPackage(this);
        Iterator<DbTermNode> i$ = terms.iterator();
        while (i$.hasNext()) {
            DbTermNode term = i$.next();
            term.status = (short)2;
        }
        PackageNode superPkg = (PackageNode)this.getParent();
        for (int i2 = 0; i2 < this.getChildCount(); ++i2) {
            TypedNode n2 = (TypedNode)this.getChildAt(i2);
            if (!(n2 instanceof PackageNode)) continue;
            superPkg.add(n2);
            ((PackageNode)n2).status = 1;
        }
    }

    public boolean hasSubPackage() {
        int n2 = this.getChildCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            ATOTreeNode child = (ATOTreeNode)this.getChildAt(i2);
            if (!(child instanceof PackageNode)) continue;
            return true;
        }
        return false;
    }

    public void clearPackage() {
        ATOTreeNode child;
        int n2 = this.getChildCount();
        HashSet<ATOTreeNode> toRemove = new HashSet<ATOTreeNode>();
        for (int i2 = 0; i2 < n2; ++i2) {
            child = (ATOTreeNode)this.getChildAt(i2);
            if (child instanceof PackageNode) continue;
            toRemove.add(child);
        }
        Iterator i$ = toRemove.iterator();
        while (i$.hasNext()) {
            child = (ATOTreeNode)i$.next();
            child.removeFromParent();
        }
        this.expanded = false;
    }

    public void expand(Connection db2, JProgressBar progress) {
        if (this.status == 2) {
            Debug.trace("Cannot expand a delete package");
            return;
        }
        this.updateTermNumber(db2);
        int cutoff = -1;
        if (this.termNumber > this.max) {
            int answer = JOptionPane.showConfirmDialog(null, "Package have too many terms (>" + this.max + "), will you only expand the top level terms ? \n" + "(You can further expand term with '+' sign with double click)");
            if (answer == 0) {
                cutoff = 0;
            } else if (answer == 2) {
                return;
            }
        }
        this.clearPackage();
        this.updateTermNumber(db2);
        this.treeLoader = new Term2Tree(db2, this.getViewMode(), true);
        this.treeLoader.setProgress(progress);
        StopWatch w2 = new StopWatch();
        w2.start();
        this.treeLoader.makeDagFromRootsQuick(this, cutoff, true, this);
        w2.stop();
        System.out.println(w2.print());
        int n2 = OntologyQuerier.getObsoleteTermCount(db2, this);
        this.obsoleteNodes = new MetaTreeNode((Object)("Obsolete(" + n2 + ")"), null);
        this.add(this.obsoleteNodes);
        this.expanded = true;
    }

    public String getOid() {
        return this.thisPackage.oid;
    }

    public void updateTermNumber(Connection db2) {
        this.termNumber = OntologyQuerier.getTermCount(db2, this.getOid());
    }

    public PackageNode(DbPackage thisPackage) {
        super((Object)thisPackage.pid, thisPackage.comment, (short)1005);
        this.thisPackage = thisPackage;
    }

    public String getViewMode() {
        return this.viewMode;
    }

    public DbPackage getThisPackage() {
        return this.thisPackage;
    }

    public void setViewMode(String viewMode) {
        this.viewMode = viewMode;
    }

    public String toString() {
        String str = super.toString();
        if (this.termNumber >= 0) {
            str = str + "(" + this.termNumber + ")";
        }
        if (this.viewMode != null) {
            str = str + " [" + this.viewMode + " View]";
        }
        return str;
    }

    public void setUserObject(Object newObj) {
        super.setUserObject(newObj);
        this.thisPackage.pid = (String)newObj;
    }

    public void setComment(Object c2) {
        super.setComment(c2);
        this.thisPackage.comment = (String)c2;
    }

    public int compareTo(Object o2) {
        return 0;
    }

    public void save(Connection db2) {
        this.thisPackage.write(db2, MOEditor.user.name, false);
    }

    public String getLocalName() {
        return this.getUserObject().toString();
    }

    public String status2string() {
        if (this.getOid() == null) {
            return "New Created and not Saved";
        }
        return super.status2string();
    }

    public Icon getIcon() {
        if (this.expanded) {
            return IconLib.iconPackageOpen;
        }
        return IconLib.iconPackage;
    }
}

