/*
 * Decompiled with CFR 0.152.
 */
package edu.iastate.utils.gui;

import edu.iastate.utils.gui.DragDropListener;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class DNDTree
extends JTree
implements DropTargetListener,
DragSourceListener,
DragGestureListener {
    private DropTarget dropTarget = null;
    private DragSource dragSource = null;
    private DefaultMutableTreeNode selnode = null;
    private DefaultMutableTreeNode dropnode = null;
    private DefaultTreeModel treemodel = null;
    DragDropListener dragDropListener;
    public boolean enableDragDrop = false;

    public void addDrageDropListener(DragDropListener dragDropListener) {
        this.dragDropListener = dragDropListener;
    }

    public DNDTree(TreeNode node) {
        super(node);
        this.treemodel = (DefaultTreeModel)this.getModel();
        this.dropTarget = new DropTarget(this, this);
        this.dragSource = new DragSource();
        this.dragSource.createDefaultDragGestureRecognizer(this, 2, this);
    }

    public DNDTree() {
        this.treemodel = (DefaultTreeModel)this.getModel();
        this.dropTarget = new DropTarget(this, this);
        this.dragSource = new DragSource();
        this.dragSource.createDefaultDragGestureRecognizer(this, 2, this);
    }

    public DNDTree(TreeModel model) {
        super(model);
        this.treemodel = (DefaultTreeModel)model;
        this.dropTarget = new DropTarget(this, this);
        this.dragSource = new DragSource();
        this.dragSource.createDefaultDragGestureRecognizer(this, 2, this);
    }

    public void dragEnter(DropTargetDragEvent event) {
        event.acceptDrag(2);
    }

    public void dragExit(DropTargetEvent event) {
    }

    public void dragOver(DropTargetDragEvent event) {
        if (!this.enableDragDrop) {
            return;
        }
        Point droppoint = event.getLocation();
        TreePath droppath = this.getClosestPathForLocation(droppoint.x, droppoint.y);
        DefaultMutableTreeNode n2 = (DefaultMutableTreeNode)droppath.getLastPathComponent();
        this.setSelectionPath(this.path(n2));
    }

    public void drop(DropTargetDropEvent event) {
        if (!this.enableDragDrop) {
            return;
        }
        try {
            Transferable transferable = event.getTransferable();
            if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                event.acceptDrop(2);
                String s2 = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                Object occur = event.getSource();
                Point droppoint = event.getLocation();
                TreePath droppath = this.getClosestPathForLocation(droppoint.x, droppoint.y);
                this.dropnode = (DefaultMutableTreeNode)droppath.getLastPathComponent();
                event.getDropTargetContext().dropComplete(true);
            } else {
                event.rejectDrop();
            }
        }
        catch (IOException exception) {
            event.rejectDrop();
        }
        catch (UnsupportedFlavorException ufException) {
            event.rejectDrop();
        }
    }

    public void dropActionChanged(DropTargetDragEvent event) {
    }

    public void dragGestureRecognized(DragGestureEvent event) {
        if (!this.enableDragDrop) {
            return;
        }
        this.selnode = null;
        this.dropnode = null;
        TreePath selected = this.getSelectionPath();
        if (selected != null) {
            TreePath treepath = selected;
            this.selnode = (DefaultMutableTreeNode)treepath.getLastPathComponent();
            if (this.dragDropListener != null && !this.dragDropListener.canDrag(this.selnode)) {
                return;
            }
            StringSelection text = new StringSelection(((Object)selected).toString());
            this.dragSource.startDrag(event, DragSource.DefaultMoveDrop, text, this);
        }
    }

    private TreePath path(TreeNode node) {
        ArrayList<TreeNode> list = new ArrayList<TreeNode>();
        while (node != null) {
            list.add(node);
            node = node.getParent();
        }
        Collections.reverse(list);
        TreePath path = new TreePath(list.toArray());
        return path;
    }

    public void dragDropEnd(DragSourceDropEvent event) {
        if (!this.enableDragDrop) {
            return;
        }
        if (event.getDropSuccess()) {
            try {
                if (this.dropnode.equals(this.selnode) || this.selnode.isNodeDescendant(this.dropnode)) {
                    System.out.println("drag>=drop");
                } else if (this.dragDropListener != null) {
                    this.dragDropListener.onDrop(this.selnode, this.dropnode);
                } else {
                    JOptionPane.showMessageDialog(this, "Node " + this.selnode + " is droped on " + this.dropnode);
                }
            }
            catch (IllegalArgumentException iae) {
                throw new IllegalArgumentException(iae.toString());
            }
            this.repaint();
        }
    }

    public void dragEnter(DragSourceDragEvent event) {
    }

    public void dragExit(DragSourceEvent event) {
    }

    public void dragOver(DragSourceDragEvent event) {
    }

    public void dropActionChanged(DragSourceDragEvent event) {
    }

    public void setDragDropListener(DragDropListener dragDropListener) {
        this.dragDropListener = dragDropListener;
    }

    public void setEnableDragDrop(boolean enableDragDrop) {
        this.enableDragDrop = enableDragDrop;
    }
}

