/*
 * Decompiled with CFR 0.152.
 */
package edu.iastate.utils.gui;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MenuComponent;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.geom.Rectangle2D;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;

public class GUIUtils {
    public static void centerWithinParent(Window wind) {
        if (wind == null) {
            throw new IllegalArgumentException("null Window passed");
        }
        Container parent = wind.getParent();
        if (parent != null && parent.isVisible()) {
            GUIUtils.center(wind, new Rectangle(parent.getLocationOnScreen(), parent.getSize()));
        } else {
            GUIUtils.centerWithinScreen(wind);
        }
    }

    public static void centerWithinDesktop(JInternalFrame frame) {
        if (frame == null) {
            throw new IllegalArgumentException("null JInternalFrame passed");
        }
        JDesktopPane parent = frame.getDesktopPane();
        if (parent != null && parent.isVisible()) {
            GUIUtils.center(frame, new Rectangle(new Point(0, 0), parent.getSize()));
        }
    }

    public static void centerWithinScreen(Window wind) {
        if (wind == null) {
            throw new IllegalArgumentException("null Window passed");
        }
        Toolkit toolKit = Toolkit.getDefaultToolkit();
        Rectangle rcScreen = new Rectangle(toolKit.getScreenSize());
        Dimension windSize = wind.getSize();
        Dimension parentSize = new Dimension(rcScreen.width, rcScreen.height);
        if (windSize.height > parentSize.height) {
            windSize.height = parentSize.height;
        }
        if (windSize.width > parentSize.width) {
            windSize.width = parentSize.width;
        }
        GUIUtils.center(wind, rcScreen);
    }

    public static Frame getOwningFrame(Component comp) {
        if (comp == null) {
            throw new IllegalArgumentException("null Component passed");
        }
        if (comp instanceof Frame) {
            return (Frame)comp;
        }
        return GUIUtils.getOwningFrame(SwingUtilities.windowForComponent(comp));
    }

    public static boolean isToolWindow(JInternalFrame frame) {
        if (frame == null) {
            throw new IllegalArgumentException("null JInternalFrame passed");
        }
        Object obj = frame.getClientProperty("JInternalFrame.isPalette");
        return obj != null && obj == Boolean.TRUE;
    }

    public static void makeToolWindow(JInternalFrame frame, boolean isToolWindow) {
        if (frame == null) {
            throw new IllegalArgumentException("null JInternalFrame passed");
        }
        frame.putClientProperty("JInternalFrame.isPalette", isToolWindow ? Boolean.TRUE : Boolean.FALSE);
    }

    public static void setJButtonSizesTheSame(JButton[] btns) {
        if (btns == null) {
            throw new IllegalArgumentException("null JButton[] passed");
        }
        Dimension maxSize = new Dimension(0, 0);
        for (int i2 = 0; i2 < btns.length; ++i2) {
            JButton btn = btns[i2];
            FontMetrics fm = btn.getFontMetrics(btn.getFont());
            Rectangle2D bounds = fm.getStringBounds(btn.getText(), btn.getGraphics());
            int boundsHeight = (int)bounds.getHeight();
            int boundsWidth = (int)bounds.getWidth();
            maxSize.width = boundsWidth > maxSize.width ? boundsWidth : maxSize.width;
            maxSize.height = boundsHeight > maxSize.height ? boundsHeight : maxSize.height;
        }
        Insets insets = btns[0].getInsets();
        maxSize.width += insets.left + insets.right;
        maxSize.height += insets.top + insets.bottom;
        for (int i3 = 0; i3 < btns.length; ++i3) {
            JButton btn = btns[i3];
            btn.setPreferredSize(maxSize);
        }
    }

    public static JInternalFrame[] getOpenToolWindows(JInternalFrame[] frames) {
        if (frames == null) {
            throw new IllegalArgumentException("null JInternalFrame[] passed");
        }
        ArrayList<JInternalFrame> framesList = new ArrayList<JInternalFrame>();
        for (int i2 = 0; i2 < frames.length; ++i2) {
            JInternalFrame fr = frames[i2];
            if (!GUIUtils.isToolWindow(fr) || fr.isClosed()) continue;
            framesList.add(frames[i2]);
        }
        return framesList.toArray(new JInternalFrame[framesList.size()]);
    }

    public static JInternalFrame[] getOpenNonToolWindows(JInternalFrame[] frames) {
        if (frames == null) {
            throw new IllegalArgumentException("null JInternalFrame[] passed");
        }
        ArrayList<JInternalFrame> framesList = new ArrayList<JInternalFrame>();
        for (int i2 = 0; i2 < frames.length; ++i2) {
            JInternalFrame fr = frames[i2];
            if (GUIUtils.isToolWindow(fr) || fr.isClosed()) continue;
            framesList.add(frames[i2]);
        }
        return framesList.toArray(new JInternalFrame[framesList.size()]);
    }

    public static JInternalFrame[] getNonMinimizedNonToolWindows(JInternalFrame[] frames) {
        if (frames == null) {
            throw new IllegalArgumentException("null JInternalFrame[] passed");
        }
        ArrayList<JInternalFrame> framesList = new ArrayList<JInternalFrame>();
        for (int i2 = 0; i2 < frames.length; ++i2) {
            JInternalFrame fr = frames[i2];
            if (GUIUtils.isToolWindow(fr) || fr.isClosed() || fr.isIcon()) continue;
            framesList.add(frames[i2]);
        }
        return framesList.toArray(new JInternalFrame[framesList.size()]);
    }

    public static boolean isWithinParent(Component wind) {
        if (wind == null) {
            throw new IllegalArgumentException("Null Component passed");
        }
        Container parent = wind.getParent();
        Rectangle parentRect = null;
        parentRect = parent != null ? new Rectangle(parent.getSize()) : new Rectangle(Toolkit.getDefaultToolkit().getScreenSize());
        Rectangle windowBounds = wind.getBounds();
        return windowBounds.x <= parentRect.width - 20 && windowBounds.y <= parentRect.height - 20 && windowBounds.x + windowBounds.width >= 20 && windowBounds.y + windowBounds.height >= 20;
    }

    public static void showModally(JInternalFrame frame) {
        frame.setVisible(true);
        if (!frame.isShowing()) {
            for (Container parent = frame.getParent(); parent != null; parent = parent.getParent()) {
                if (parent.isVisible()) continue;
                parent.setVisible(true);
            }
        }
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                EventQueue theQueue = frame.getToolkit().getSystemEventQueue();
                while (frame.isShowing()) {
                    AWTEvent event = theQueue.getNextEvent();
                    Object src = event.getSource();
                    if (src instanceof Component) {
                        ((Component)src).dispatchEvent(event);
                        continue;
                    }
                    if (src instanceof MenuComponent) {
                        ((MenuComponent)src).dispatchEvent(event);
                        continue;
                    }
                    System.err.println("unable to dispatch event: " + event);
                }
            } else {
                while (frame.isShowing()) {
                    frame.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static void center(Component wind, Rectangle rect) {
        if (wind == null || rect == null) {
            throw new IllegalArgumentException("null Window or Rectangle passed");
        }
        Dimension windSize = wind.getSize();
        int x2 = (rect.width - windSize.width) / 2 + rect.x;
        int y2 = (rect.height - windSize.height) / 2 + rect.y;
        if (y2 < rect.y) {
            y2 = rect.y;
        }
        wind.setLocation(x2, y2);
    }

    public static void sortAllRowsBy(DefaultTableModel model, int colIndex, boolean ascending) {
        Vector<Vector> data = model.getDataVector();
        ColumnSorter sorter = new ColumnSorter(colIndex, ascending);
        Collections.sort(data, sorter);
        model.fireTableStructureChanged();
    }

    public static void updateComboBox(JComboBox theBox, Object[] newdata) {
        Object oldSelction = theBox.getSelectedItem();
        theBox.removeAllItems();
        for (int i2 = 0; i2 < newdata.length; ++i2) {
            theBox.addItem(newdata[i2]);
        }
        if (oldSelction != null) {
            theBox.setSelectedItem(oldSelction);
        }
    }

    public static Icon loadIcon(String filename) {
        try {
            URL fileURL = ClassLoader.getSystemClassLoader().getResource(filename);
            ImageIcon icon = new ImageIcon(fileURL);
            return icon;
        }
        catch (Exception ex) {
            try {
                ImageIcon icon = new ImageIcon(filename);
                return icon;
            }
            catch (Exception ex1) {
                return null;
            }
        }
    }

    public static Image loadImage(String filename) {
        ImageIcon icon = (ImageIcon)GUIUtils.loadIcon(filename);
        return icon.getImage();
    }

    public static void iconify(Frame frame) {
        int state = frame.getExtendedState();
        frame.setExtendedState(state |= 1);
    }

    public static void deiconify(Frame frame) {
        int state = frame.getExtendedState();
        frame.setExtendedState(state &= 0xFFFFFFFE);
    }

    public static void minimize(Frame frame) {
        int state = frame.getExtendedState();
        frame.setExtendedState(state &= 0xFFFFFFF9);
    }

    public static void maximize(Frame frame) {
        int state = frame.getExtendedState();
        frame.setExtendedState(state |= 6);
    }

    public static JFrame getRootFrame(Component control) {
        JFrame frame = (JFrame)SwingUtilities.getRoot(control);
        return frame;
    }

    public static Dimension getClientRegionSize(JFrame frame) {
        Insets insets = frame.getInsets();
        int w2 = frame.getWidth() - insets.left - insets.right;
        int h2 = frame.getHeight() - insets.top - insets.bottom;
        return new Dimension(w2, h2);
    }

    public static class ColumnSorter
    implements Comparator {
        int colIndex;
        boolean ascending;

        ColumnSorter(int colIndex, boolean ascending) {
            this.colIndex = colIndex;
            this.ascending = ascending;
        }

        public int compare(Object a2, Object b2) {
            Vector v1 = (Vector)a2;
            Vector v2 = (Vector)b2;
            Object o1 = v1.get(this.colIndex);
            Object o2 = v2.get(this.colIndex);
            if (o1 instanceof String && ((String)o1).length() == 0) {
                o1 = null;
            }
            if (o2 instanceof String && ((String)o2).length() == 0) {
                o2 = null;
            }
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            if (o1 instanceof Comparable) {
                if (this.ascending) {
                    return ((Comparable)o1).compareTo(o2);
                }
                return ((Comparable)o2).compareTo(o1);
            }
            if (this.ascending) {
                return o1.toString().compareTo(o2.toString());
            }
            return o2.toString().compareTo(o1.toString());
        }
    }
}

