/*
 * Decompiled with CFR 0.152.
 */
package edu.iastate.utils.gui;

import edu.iastate.utils.gui.DNDTree;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class JTreeEx
extends DNDTree {
    protected static TreePath find2(JTree tree, TreePath parent, Object[] nodes, int depth, int mode) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)parent.getLastPathComponent();
        Object onTree = node;
        Object toCompare = nodes[depth];
        if (mode == 0) {
            onTree = node;
            toCompare = nodes[depth];
        } else if (mode == 1) {
            onTree = node.toString();
            toCompare = nodes[depth].toString();
        } else if (mode == 2) {
            onTree = node.getUserObject();
            toCompare = nodes[depth] instanceof DefaultMutableTreeNode ? ((DefaultMutableTreeNode)nodes[depth]).getUserObject() : nodes[depth];
        }
        if (onTree.equals(toCompare)) {
            if (depth == nodes.length - 1) {
                return parent;
            }
            if (node.getChildCount() >= 0) {
                Enumeration<TreeNode> e2 = node.children();
                while (e2.hasMoreElements()) {
                    TreeNode n2 = e2.nextElement();
                    TreePath path = parent.pathByAddingChild(n2);
                    TreePath result = JTreeEx.find2(tree, path, nodes, depth + 1, mode);
                    if (result == null) continue;
                    return result;
                }
            }
        }
        return null;
    }

    public static TreePath findByName(JTree tree, String[] names) {
        TreeNode root = (TreeNode)tree.getModel().getRoot();
        return JTreeEx.find2(tree, new TreePath(root), names, 0, 1);
    }

    public static TreePath getPath(TreeNode node) {
        ArrayList<TreeNode> list = new ArrayList<TreeNode>();
        while (node != null) {
            list.add(node);
            node = node.getParent();
        }
        Collections.reverse(list);
        return new TreePath(list.toArray());
    }

    public TreeNode getSelectedNode() {
        TreePath path = this.getSelectionPath();
        if (path != null) {
            TreeNode n2 = (TreeNode)path.getLastPathComponent();
            return n2;
        }
        return null;
    }

    public JTreeEx(TreeNode node) {
        super(node);
    }

    public JTreeEx() {
    }

    public JTreeEx(DefaultTreeModel model) {
        super(model);
    }

    public static DefaultMutableTreeNode findFirst(JTree tree, Object value) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)tree.getModel().getRoot();
        Enumeration<TreeNode> e2 = root.breadthFirstEnumeration();
        while (e2.hasMoreElements()) {
            DefaultMutableTreeNode n2 = (DefaultMutableTreeNode)e2.nextElement();
            if (!n2.getUserObject().equals(value)) continue;
            return n2;
        }
        return null;
    }

    public static TreePath find(JTree tree, Object[] nodes) {
        TreeNode root = (TreeNode)tree.getModel().getRoot();
        return JTreeEx.find2(tree, new TreePath(root), nodes, 0, 0);
    }

    public static TreePath findByUserObject(JTree tree, Object[] names) {
        TreeNode root = (TreeNode)tree.getModel().getRoot();
        return JTreeEx.find2(tree, new TreePath(root), names, 0, 2);
    }

    public static Set findAncestor(TreeNode node) {
        HashSet<Object> ss = new HashSet<Object>();
        TreePath path = JTreeEx.getPath(node);
        Object[] ancestor = path.getPath();
        ss.addAll(Arrays.asList(ancestor));
        ss.remove(node);
        return ss;
    }

    public static Set findAllOffspring(TreeNode node) {
        HashSet<TreeNode> ss = new HashSet<TreeNode>();
        if (node.getChildCount() > 0) {
            Enumeration<? extends TreeNode> e2 = node.children();
            while (e2.hasMoreElements()) {
                TreeNode n2 = e2.nextElement();
                ss.add(n2);
                ss.addAll(JTreeEx.findAllOffspring(n2));
            }
            ss.remove(node);
        }
        return ss;
    }

    public DefaultMutableTreeNode selectFirst(Object value) {
        DefaultMutableTreeNode node;
        if (value != null && (node = JTreeEx.findFirst((JTree)this, value)) != null) {
            TreePath path = JTreeEx.getPath(node);
            this.setSelectionPath(path);
            return node;
        }
        return null;
    }

    public void expandPath(TreeNode node) {
        TreePath path = JTreeEx.getPath(node);
        this.expandPath(path);
        this.scrollPathToVisible(path);
    }

    public void expandNode(TreeNode node) {
        if (node == null) {
            return;
        }
        this.expandPath(node);
    }

    public void CollapsePath(TreeNode node) {
        this.collapsePath(JTreeEx.getPath(node));
    }

    public static DefaultMutableTreeNode findFirst(JTree tree, String name) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)tree.getModel().getRoot();
        Enumeration<TreeNode> e2 = root.breadthFirstEnumeration();
        while (e2.hasMoreElements()) {
            DefaultMutableTreeNode n2 = (DefaultMutableTreeNode)e2.nextElement();
            if (n2.getUserObject().toString().compareTo(name) != 0) continue;
            return n2;
        }
        return null;
    }

    public void expandNode(String node) {
        this.expandNode(JTreeEx.findFirst((JTree)this, node));
    }

    public void expandPath(String node) {
        this.expandPath(JTreeEx.getPath(JTreeEx.findFirst((JTree)this, node)));
    }

    public DefaultTreeModel getModel() {
        return (DefaultTreeModel)super.getModel();
    }

    public void moveNode(MutableTreeNode n1, MutableTreeNode n2) {
        if (n1.getParent() != null) {
            this.getModel().removeNodeFromParent(n1);
        }
        this.getModel().insertNodeInto(n1, n2, 0);
        System.out.println("move " + n1 + " ->" + n2);
    }

    public void delete(MutableTreeNode n2) {
        this.getModel().removeNodeFromParent(n2);
    }

    public /* synthetic */ TreeModel getModel() {
        return this.getModel();
    }
}

