/*
 * Decompiled with CFR 0.152.
 */
package edu.iastate.utils.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class LabelledItemPanel
extends JPanel {
    private int myNextItemRow = 0;
    public int itemInterval = 10;

    public LabelledItemPanel() {
        this.init();
    }

    public LabelledItemPanel(int itermInterval) {
        this.itemInterval = itermInterval;
        this.init();
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        this.myNextItemRow = 0;
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 99;
        constraints.insets = new Insets(this.itemInterval, 0, 0, 0);
        constraints.weighty = 1.0;
        constraints.fill = 3;
        JLabel verticalFillLabel = new JLabel();
        this.add((Component)verticalFillLabel, constraints);
    }

    public void addItem(String labelText, JComponent item) {
        JLabel label = new JLabel(labelText);
        this.addItem(label, item);
    }

    public void addItem(JComponent labelItem, JComponent item) {
        GridBagConstraints labelConstraints = new GridBagConstraints();
        labelConstraints.gridx = 0;
        labelConstraints.gridy = this.myNextItemRow;
        labelConstraints.insets = new Insets(this.itemInterval, this.itemInterval, 0, 0);
        labelConstraints.anchor = 12;
        labelConstraints.fill = 0;
        this.add((Component)labelItem, labelConstraints);
        GridBagConstraints itemConstraints = new GridBagConstraints();
        itemConstraints.gridx = 1;
        itemConstraints.gridy = this.myNextItemRow++;
        itemConstraints.insets = new Insets(this.itemInterval, this.itemInterval, 0, this.itemInterval);
        itemConstraints.weightx = 1.0;
        itemConstraints.anchor = 17;
        itemConstraints.fill = 2;
        this.add((Component)item, itemConstraints);
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        LabelledItemPanel myContentPane = new LabelledItemPanel();
        myContentPane.setBorder(BorderFactory.createEtchedBorder());
        myContentPane.addItem("Customer Code", (JComponent)new JTextField());
        myContentPane.addItem("Name", (JComponent)new JTextField());
        myContentPane.addItem("Address", (JComponent)new JScrollPane(new JTextArea(3, 20), 22, 31));
        frame.setContentPane(myContentPane);
        frame.pack();
        frame.setVisible(true);
    }

    public void clear() {
        this.removeAll();
        this.init();
    }
}

