/*
 * Decompiled with CFR 0.152.
 */
package edu.iastate.utils.gui;

import edu.iastate.utils.gui.LabelledItemPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class StandardDialog
extends JDialog {
    private static final int COMPONENT_SPACING = 10;
    private boolean myIsDialogCancelled = true;
    private Container myUserContentPane;
    protected JButton okButton;
    protected JButton cancelButton;
    protected JPanel buttonPanel = new JPanel();
    public final JPanel internalContentPane = new JPanel();

    public StandardDialog() {
        this.init();
    }

    public StandardDialog(Frame parent, String title) {
        super(parent, title);
        this.init();
    }

    public StandardDialog(Dialog parent, String title) {
        super(parent, title);
        this.init();
    }

    private void init() {
        this.setModal(true);
        this.setDefaultCloseOperation(0);
        this.internalContentPane.setLayout(new BorderLayout(10, 10));
        this.internalContentPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        AbstractAction okAction = new AbstractAction("Ok"){

            public void actionPerformed(ActionEvent actionEvent) {
                if (StandardDialog.this.isValidData()) {
                    StandardDialog.this.myIsDialogCancelled = false;
                    StandardDialog.this.dispose();
                }
            }
        };
        AbstractAction cancelAction = new AbstractAction("Cancel"){

            public void actionPerformed(ActionEvent actionEvent) {
                StandardDialog.this.myIsDialogCancelled = true;
                StandardDialog.this.dispose();
            }
        };
        this.buttonPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.okButton = new JButton(okAction);
        this.cancelButton = new JButton(cancelAction);
        this.buttonPanel.add(this.okButton);
        this.buttonPanel.add(this.cancelButton);
        this.internalContentPane.add((Component)this.buttonPanel, "South");
        this.setContentPane(new JPanel(new BorderLayout()));
        super.setContentPane(this.internalContentPane);
        WindowAdapter windowAdapter = new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                StandardDialog.this.myIsDialogCancelled = true;
                StandardDialog.this.dispose();
            }
        };
        this.addWindowListener(windowAdapter);
    }

    public Container getContentPane() {
        return this.myUserContentPane;
    }

    public void setContentPane(Container contentPane) {
        this.myUserContentPane = contentPane;
        super.getContentPane().add((Component)this.myUserContentPane, "Center");
    }

    public boolean hasUserCancelled() {
        return this.myIsDialogCancelled;
    }

    protected boolean isValidData() {
        return true;
    }

    public static void main(String[] args) {
        StandardDialog dlg = new StandardDialog();
        LabelledItemPanel myContentPane = new LabelledItemPanel();
        myContentPane.setBorder(BorderFactory.createEtchedBorder());
        myContentPane.addItem("Customer Code", (JComponent)new JTextField());
        myContentPane.addItem("Name", (JComponent)new JTextField());
        myContentPane.addItem("Address", (JComponent)new JScrollPane(new JTextArea(3, 20), 22, 31));
        dlg.setContentPane(myContentPane);
        dlg.setSize(300, 200);
        dlg.setVisible(true);
        if (!dlg.hasUserCancelled()) {
            // empty if block
        }
    }
}

