/*
 * Decompiled with CFR 0.152.
 */
package edu.iastate.utils.gui.wizard;

import edu.iastate.utils.gui.wizard.ErrorMessageBox;
import edu.iastate.utils.gui.wizard.NullWizardPanel;
import edu.iastate.utils.gui.wizard.WizardContext;
import edu.iastate.utils.gui.wizard.WizardListener;
import edu.iastate.utils.gui.wizard.WizardPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class Wizard
extends JPanel
implements ActionListener {
    public static final String BACK_I18N = "BACK_I18N";
    public static final String NEXT_I18N = "NEXT_I18N";
    public static final String FINISH_I18N = "FINISH_I18N";
    public static final String CANCEL_I18N = "CANCEL_I18N";
    public static final String HELP_I18N = "HELP_I18N";
    public static final Dimension WIZARD_WINDOW_SIZE = new Dimension(450, 200);
    private final JButton backButton = new JButton("<< back");
    private final JButton nextButton = new JButton("next >>");
    private final JButton finishButton = new JButton("finish");
    private final JButton cancelButton = new JButton("cancel");
    private final JButton helpButton = new JButton("help");
    private final HashMap listeners = new HashMap();
    private Stack previous = null;
    private WizardPanel current = null;
    private WizardContext ctx = null;
    private Map i18n = null;

    public Wizard(Map i18n) {
        this.i18n = i18n;
        this.init();
        this.applyI18N(this.i18n);
    }

    public Wizard() {
        this.init();
    }

    private void init() {
        this.nextButton.addActionListener(this);
        this.backButton.addActionListener(this);
        this.finishButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.helpButton.addActionListener(this);
        this.nextButton.setEnabled(false);
        this.backButton.setEnabled(false);
        this.finishButton.setEnabled(false);
        this.cancelButton.setEnabled(false);
        this.helpButton.setEnabled(false);
        this.setLayout(new BorderLayout());
        JPanel navButtons = new JPanel();
        navButtons.setLayout(new FlowLayout(2));
        navButtons.add(this.backButton);
        navButtons.add(this.nextButton);
        navButtons.add(this.finishButton);
        JPanel cancelButtons = new JPanel();
        cancelButtons.setLayout(new FlowLayout(0));
        cancelButtons.add(this.cancelButton);
        cancelButtons.add(this.helpButton);
        JPanel buttons = new JPanel();
        buttons.setLayout(new BorderLayout());
        buttons.add((Component)navButtons, "East");
        buttons.add((Component)cancelButtons, "West");
        this.add((Component)buttons, "South");
        this.setMinimumSize(WIZARD_WINDOW_SIZE);
        this.setPreferredSize(WIZARD_WINDOW_SIZE);
    }

    public void setI18NMap(Map map) {
        this.i18n = map;
        this.applyI18N(this.i18n);
    }

    private void applyI18N(Map map) {
        if (map.size() > 0) {
            this.nextButton.setText((String)map.get(NEXT_I18N));
            this.backButton.setText((String)map.get(BACK_I18N));
            this.finishButton.setText((String)map.get(FINISH_I18N));
            this.cancelButton.setText((String)map.get(CANCEL_I18N));
            this.helpButton.setText((String)map.get(HELP_I18N));
            this.backButton.setActionCommand("<< back");
            this.nextButton.setActionCommand("next >>");
            this.finishButton.setActionCommand("finish");
            this.cancelButton.setActionCommand("cancel");
            this.helpButton.setActionCommand("help");
        }
    }

    public void addWizardListener(WizardListener listener) {
        this.listeners.put(listener, listener);
    }

    public void removeWizardListener(WizardListener listener) {
        this.listeners.remove(listener);
    }

    public void start(WizardPanel wp) {
        this.previous = new Stack();
        this.ctx = new WizardContext();
        wp.setWizardContext(this.ctx);
        this.setPanel(wp);
        this.updateButtons();
    }

    public void actionPerformed(ActionEvent ae) {
        String ac = ae.getActionCommand();
        if ("<< back".equals(ac)) {
            this.back();
        } else if ("next >>".equals(ac)) {
            this.next();
        } else if ("finish".equals(ac)) {
            this.finish();
        } else if ("cancel".equals(ac)) {
            this.cancel();
        } else if ("help".equals(ac)) {
            this.help();
        }
    }

    private void setPanel(WizardPanel wp) {
        if (null != this.current) {
            this.remove(this.current);
        }
        this.current = wp;
        if (null == this.current) {
            this.current = new NullWizardPanel();
        }
        this.add((Component)this.current, "Center");
        Iterator iter = this.listeners.values().iterator();
        while (iter.hasNext()) {
            WizardListener listener = (WizardListener)iter.next();
            listener.wizardPanelChanged(this);
        }
        this.setVisible(true);
        this.revalidate();
        this.updateUI();
        this.current.display();
    }

    private void updateButtons() {
        this.cancelButton.setEnabled(true);
        this.helpButton.setEnabled(this.current.hasHelp());
        this.backButton.setEnabled(this.previous.size() > 0);
        this.nextButton.setEnabled(this.current.hasNext());
        this.finishButton.setEnabled(this.current.canFinish());
    }

    private void back() {
        WizardPanel wp = (WizardPanel)this.previous.pop();
        this.setPanel(wp);
        this.updateButtons();
    }

    private void next() {
        ArrayList list = new ArrayList();
        if (this.current.validateNext(list)) {
            this.previous.push(this.current);
            WizardPanel wp = this.current.next();
            if (null != wp) {
                wp.setWizardContext(this.ctx);
            }
            this.setPanel(wp);
            this.updateButtons();
        } else {
            this.showErrorMessages(list);
        }
    }

    private void finish() {
        ArrayList list = new ArrayList();
        if (this.current.validateFinish(list)) {
            this.current.finish();
            Iterator iter = this.listeners.values().iterator();
            while (iter.hasNext()) {
                WizardListener listener = (WizardListener)iter.next();
                listener.wizardFinished(this);
            }
        } else {
            this.showErrorMessages(list);
        }
    }

    private void cancel() {
        Iterator iter = this.listeners.values().iterator();
        while (iter.hasNext()) {
            WizardListener listener = (WizardListener)iter.next();
            listener.wizardCancelled(this);
        }
    }

    private void help() {
        this.current.help();
    }

    private void showErrorMessages(ArrayList list) {
        Window w2 = SwingUtilities.windowForComponent(this);
        Object frame = null;
        ErrorMessageBox errorMsgBox = null;
        errorMsgBox = w2 instanceof Frame ? new ErrorMessageBox((Frame)w2) : (w2 instanceof Dialog ? new ErrorMessageBox((Dialog)w2) : new ErrorMessageBox());
        errorMsgBox.showErrorMessages(list);
    }

    public void enableNext(boolean enabled) {
        this.nextButton.setEnabled(enabled);
    }
}

