/*
 * Decompiled with CFR 0.152.
 */
package edu.iastate.utils.io;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;

public abstract class FileUtils {
    private FileUtils() {
    }

    public static String readFile(String filePath) throws FileNotFoundException, SecurityException, IOException {
        return FileUtils.readFile(new File(filePath));
    }

    public static String readFile(File file) throws FileNotFoundException, SecurityException, IOException {
        String result = null;
        FileReader t_frPageReader = new FileReader(file);
        BufferedReader t_frPageBufferedReader = new BufferedReader(t_frPageReader);
        char[] t_acFileContents = new char[(int)file.length()];
        t_frPageBufferedReader.read(t_acFileContents, 0, t_acFileContents.length);
        t_frPageBufferedReader.close();
        t_frPageReader.close();
        result = new String(t_acFileContents);
        return result;
    }

    public static String readFileIfPossible(String filePath) {
        String result = new String();
        try {
            result = FileUtils.readFile(filePath);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (SecurityException securityException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public static String readFileIfPossible(File file) {
        String result = new String();
        try {
            result = FileUtils.readFile(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (SecurityException securityException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public static boolean writeFileIfPossible(String filePath, String contents) {
        return FileUtils.writeFileIfPossible(new File(filePath), contents);
    }

    public static boolean writeFileIfPossible(File file, String contents) {
        boolean result = false;
        try {
            FileUtils.writeFile(file, contents);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (SecurityException securityException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public static void writeFile(String filePath, String contents) throws FileNotFoundException, SecurityException, IOException {
        FileUtils.writeFile(new File(filePath), contents);
    }

    public static void writeFile(File file, String contents) throws FileNotFoundException, SecurityException, IOException {
        if (file != null && contents != null) {
            FileWriter t_fwWriter = new FileWriter(file);
            PrintWriter t_pwWriter = new PrintWriter(t_fwWriter);
            t_pwWriter.println(contents);
            t_pwWriter.close();
            t_fwWriter.close();
        }
    }

    public static void copy(String filePath, String destinationPath) throws FileNotFoundException, SecurityException, IOException {
        FileUtils.copy(new File(filePath), new File(destinationPath));
    }

    public static void copy(File original, File destination) throws FileNotFoundException, SecurityException, IOException {
        FileWriter t_FileWriter = new FileWriter(destination);
        t_FileWriter.write(FileUtils.readFile(original));
        t_FileWriter.close();
    }

    public static boolean copyIfPossible(String originalPath, String destinationPath) {
        return FileUtils.copyIfPossible(new File(originalPath), new File(destinationPath));
    }

    public static boolean copyIfPossible(File original, File destination) {
        boolean result = false;
        try {
            FileUtils.copy(original, destination);
            result = true;
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (SecurityException securityException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public static void move(File originalFile, File destinationFile) throws FileNotFoundException, SecurityException, IOException {
        FileUtils.copy(originalFile, destinationFile);
        originalFile.delete();
    }

    public static void move(String filePath, String destinationPath) throws FileNotFoundException, SecurityException, IOException {
        FileUtils.move(new File(filePath), new File(destinationPath));
    }

    public static boolean moveIfPossible(File originalFile, File destinationFile) {
        boolean result = false;
        try {
            FileUtils.move(originalFile, destinationFile);
            result = true;
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (SecurityException securityException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public static boolean moveIfPossible(String filePath, String destinationPath) {
        return FileUtils.moveIfPossible(new File(filePath), new File(destinationPath));
    }

    public static String findExtension(String fullname) {
        String localName;
        int ii;
        String extensionName = "";
        int jj = fullname.lastIndexOf("/");
        if (jj == -1) {
            jj = fullname.lastIndexOf("\\");
        }
        if (jj == -1) {
            jj = 0;
        }
        if ((ii = (localName = fullname.substring(jj == 0 ? 0 : jj + 1)).lastIndexOf(".", jj)) != -1) {
            extensionName = localName.substring(ii + 1);
            System.out.println(extensionName);
        }
        return extensionName;
    }

    public static String findName(String fullname) {
        String fileName = null;
        int end = fullname.lastIndexOf(".");
        int begin = 0;
        if (fullname.lastIndexOf("/") != -1) {
            begin = fullname.lastIndexOf("/");
        } else if (fullname.lastIndexOf("\\") != -1) {
            begin = fullname.lastIndexOf("\\");
        }
        if (end != -1) {
            fileName = fullname.substring(begin, end);
        }
        return fileName;
    }

    public static boolean appendFile(String fullname, String text) {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(fullname, true));
            out.write(text);
            out.flush();
            out.close();
        }
        catch (IOException e2) {
            return false;
        }
        return true;
    }

    public static boolean isFileExists(String fullname) {
        boolean exists = new File(fullname).exists();
        return exists;
    }

    public static byte[] getBytesFromFile(File file) throws IOException {
        int offset;
        FileInputStream is = new FileInputStream(file);
        long length = file.length();
        if (length > Integer.MAX_VALUE) {
            // empty if block
        }
        byte[] bytes = new byte[(int)length];
        int numRead = 0;
        for (offset = 0; offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
        }
        if (offset < bytes.length) {
            throw new IOException("Could not completely read file " + file.getName());
        }
        ((InputStream)is).close();
        return bytes;
    }

    public static File writeToTempFile(String prefix, String suffix, String contens, boolean deleteOnExit) {
        try {
            if (prefix == null) {
                prefix = "temporary";
            }
            File temp = File.createTempFile(prefix, suffix);
            if (deleteOnExit) {
                temp.deleteOnExit();
            }
            BufferedWriter out = new BufferedWriter(new FileWriter(temp));
            out.write(contens);
            out.close();
            return temp;
        }
        catch (IOException e2) {
            return null;
        }
    }
}

