/*
 * Decompiled with CFR 0.152.
 */
package edu.iastate.utils.log;

import edu.iastate.utils.io.FileUtils;
import edu.iastate.utils.string.SimpleXMLParser;
import java.io.File;
import java.io.IOException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public abstract class Config {
    public Document configXML;
    public String configFile = "config.xml";
    String charset = "UTF-8";

    public Config(String configFileName, boolean isSave) {
        try {
            this.configFile = configFileName;
            if (isSave) {
                this.createNew();
            } else if (!FileUtils.isFileExists(this.configFile)) {
                this.createNew();
            } else {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                this.configXML = factory.newDocumentBuilder().parse(new File(this.configFile));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static String Encode(String str) {
        try {
            Deflater compressor = new Deflater();
            byte[] plainText = str.getBytes("UTF-8");
            byte[] output = new byte[1024];
            compressor.setInput(plainText);
            compressor.finish();
            int compressedDataLength = compressor.deflate(output);
            StringBuffer ss = new StringBuffer();
            for (int i2 = 0; i2 < compressedDataLength; ++i2) {
                ss.append(new Byte(output[i2]) + "_");
            }
            return ss.toString();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    static String Decode(String str) {
        try {
            Inflater decompressor = new Inflater();
            if (str == null || str.length() == 0) {
                return "";
            }
            String[] bb2 = str.split("_");
            byte[] plainText = new byte[bb2.length - 1];
            for (int i2 = 0; i2 < plainText.length; ++i2) {
                plainText[i2] = Byte.parseByte(bb2[i2]);
            }
            decompressor.setInput(plainText);
            byte[] result = new byte[1024];
            int resultLength = decompressor.inflate(result);
            decompressor.end();
            String outputString = new String(result, 0, resultLength, "UTF-8");
            return outputString;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static void setPropertyCipher(Element parent, String tag, String value) {
        Config.setProperty(parent, tag, Config.Encode(value));
    }

    public static void setProperty(Element parent, String tag, String value) {
        try {
            Document doc = parent.getOwnerDocument();
            Element n2 = (Element)XPathAPI.selectSingleNode(parent, tag);
            if (n2 != null) {
                parent.removeChild(n2);
            }
            Element tagNode = doc.createElement(tag);
            tagNode.appendChild(doc.createTextNode(value));
            parent.appendChild(tagNode);
        }
        catch (DOMException ex) {
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
    }

    public static String getPropertyCipher(Node parent, String tag) {
        return Config.Decode(Config.getProperty(parent, tag));
    }

    public static String getProperty(Node parent, String tag) {
        try {
            Text elem;
            Node n2 = XPathAPI.selectSingleNode(parent, tag);
            if (n2 != null && (elem = (Text)n2.getFirstChild()) != null) {
                return elem.getData().toString();
            }
        }
        catch (DOMException ex) {
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
        return "";
    }

    public static int getPropertyInt(Node parent, String tag) {
        try {
            return Integer.parseInt(Config.getProperty(parent, tag));
        }
        catch (NumberFormatException ex) {
            return 0;
        }
    }

    public static boolean getPropertyBoolean(Node parent, String tag) {
        return Boolean.getBoolean(Config.getProperty(parent, tag));
    }

    protected Node addChildTag(Node parent, String newTag) {
        Element newChild = this.configXML.createElement(newTag);
        return parent.appendChild(newChild);
    }

    protected void createBlankNew() {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            this.configXML = builder.newDocument();
        }
        catch (FactoryConfigurationError ex) {
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
    }

    public void save(Object obj) {
        this.objToXML(obj);
        String xml = this.getXML();
        try {
            FileUtils.writeFile(this.configFile, xml);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void load(Object obj) {
        this.xmlToObj(obj);
    }

    public String getXML() {
        return SimpleXMLParser.documentToString(this.configXML, this.charset);
    }

    public Element findNode(Node contextNode, String xpath) {
        Element node = null;
        try {
            node = contextNode == null ? (Element)XPathAPI.selectSingleNode(this.configXML, xpath) : (Element)XPathAPI.selectSingleNode(contextNode, xpath);
        }
        catch (TransformerException ex) {
            // empty catch block
        }
        return node;
    }

    protected abstract void createNew();

    protected abstract void objToXML(Object var1);

    protected abstract void xmlToObj(Object var1);

    public void setCharset(String charset) {
        this.charset = charset;
    }
}

