/*
 * Decompiled with CFR 0.152.
 */
package edu.iastate.utils.sql;

import com.borland.dbswing.DBDisposeMonitor;
import com.borland.dbswing.JdbNavToolBar;
import com.borland.dbswing.JdbStatusLabel;
import com.borland.dbswing.JdbTable;
import com.borland.dbswing.TableScrollPane;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.sql.dataset.ConnectionDescriptor;
import com.borland.dx.sql.dataset.Database;
import com.borland.dx.sql.dataset.QueryDataSet;
import com.borland.dx.sql.dataset.QueryDescriptor;
import edu.iastate.utils.gui.GUIUtils;
import edu.iastate.utils.sql.SQLDialog;
import edu.iastate.utils.sql.pgJDBCUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.Connection;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class DBViewer
extends JDialog {
    TableScrollPane tableScrollPane1 = new TableScrollPane();
    protected JdbStatusLabel jStatusLabel = new JdbStatusLabel();
    protected JdbTable dataTable = new JdbTable(){

        public boolean isCellEditable(int row, int column) {
            return DBViewer.this.isTableCellEditable(row, column);
        }
    };
    protected MyNavToolBar dbNavToolbar = new MyNavToolBar();
    protected Database CacheDB = new Database();
    protected QueryDataSet query = new QueryDataSet();
    protected DBDisposeMonitor dbDisposeMonitor = new DBDisposeMonitor();
    protected Connection db;
    protected JPanel toolbar = new JPanel();
    protected JButton jButtonAdvanceSQL = new JButton();
    boolean showSQLButton = false;
    String connectionURL;
    String userName;
    String password;
    boolean promptPassword;
    String driver;
    String sql = "";
    protected JComboBox datasourceList = new JComboBox();

    public boolean beforeToolebarAction(ActionEvent e2) {
        return true;
    }

    public void afterToolebarAction(ActionEvent e2) {
    }

    public boolean isTableCellEditable(int row, int column) {
        return true;
    }

    public DBViewer(JFrame aFrame, boolean showSQLButton, String title, String connectionURL, String userName, String password, boolean promptPassword, String driver) throws HeadlessException {
        super((Frame)aFrame, true);
        this.showSQLButton = showSQLButton;
        this.connectionURL = connectionURL;
        this.userName = userName;
        this.password = password;
        this.promptPassword = promptPassword;
        this.driver = driver;
        if (title != null) {
            this.setTitle(title);
        }
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.jStatusLabel.setText("Status");
        try {
            this.CacheDB.setConnection(new ConnectionDescriptor(this.connectionURL, this.userName, this.password, this.promptPassword, this.driver));
            this.CacheDB.setDatabaseName("");
            this.dbDisposeMonitor.setDataAwareComponentContainer(this);
            this.db = this.CacheDB.getJdbcConnection();
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
        this.dataTable.setFont(new Font("DialogInput", 0, 11));
        this.dataTable.setAutoResizeMode(4);
        this.dataTable.setEditable(false);
        this.jButtonAdvanceSQL.setText("Advanced Query...");
        this.jButtonAdvanceSQL.setVisible(this.showSQLButton);
        this.jButtonAdvanceSQL.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                DBViewer.this.jButtonAdvancedQueryAction(e2);
            }
        });
        this.tableScrollPane1.getViewport().add((Component)this.dataTable, null);
        JPanel p2 = new JPanel();
        p2.setLayout(new BorderLayout());
        p2.add((Component)this.tableScrollPane1, "Center");
        p2.add((Component)this.jStatusLabel, "South");
        p2.add((Component)this.toolbar, "North");
        this.toolbar.add((Component)this.dbNavToolbar, null);
        this.datasourceList.addItemListener(new MySchemaListener());
        this.readDatasource();
        this.dbNavToolbar.add((Component)this.datasourceList, -1);
        this.toolbar.add((Component)this.jButtonAdvanceSQL, null);
        this.getContentPane().add((Component)p2, "Center");
        this.setSize(800, 600);
    }

    public void refresh() {
        DataSet ds = this.dataTable.getDataSet();
        if (ds != null && ds.isOpen()) {
            ds.refresh();
        }
    }

    public void setSQL(String newSQL) {
        if (newSQL == null) {
            this.query.setQuery(new QueryDescriptor(this.CacheDB, this.sql, null, true, 0));
            this.dataTable.setDataSet(null);
        } else {
            try {
                this.query.closeStatement();
                if (this.dataTable.getDataSet() != null && this.dataTable.getDataSet().isOpen()) {
                    this.dataTable.getDataSet().close();
                }
                this.query.setQuery(new QueryDescriptor(this.CacheDB, newSQL, null, true, 0));
                this.dataTable.setDataSet(this.query);
                this.sql = newSQL;
            }
            catch (Exception ex) {
                ex.printStackTrace(System.err);
            }
        }
    }

    void readDatasource() {
        Vector v2 = pgJDBCUtils.getAllTable(this.CacheDB.getJdbcConnection());
        GUIUtils.updateComboBox(this.datasourceList, v2.toArray());
    }

    void jButtonAdvancedQueryAction(ActionEvent e2) {
        SQLDialog dlg = new SQLDialog(this.sql);
        GUIUtils.centerWithinScreen(dlg);
        dlg.setVisible(true);
        if (dlg.getSQL() != null) {
            this.sql = dlg.getSQL();
            System.out.println(this.sql);
            try {
                this.query.closeStatement();
                this.query.setQuery(new QueryDescriptor(this.CacheDB, this.sql, null, true, 0));
                this.dataTable.setDataSet(this.query);
            }
            catch (Exception ex) {
                ex.printStackTrace(System.err);
            }
        }
    }

    public static void main(String[] args) throws HeadlessException {
        DBViewer dlg = new DBViewer(null, true, "test", "jdbc:postgresql://boole.cs.iastate.edu/indus", "indus", "indus", false, "org.postgresql.Driver");
        dlg.setVisible(true);
    }

    class MySchemaListener
    implements ItemListener {
        MySchemaListener() {
        }

        public void itemStateChanged(ItemEvent evt) {
            Object item = evt.getItem();
            if (evt.getStateChange() == 1) {
                DBViewer.this.setSQL("SELECT * FROM " + item.toString() + ";");
                DBViewer.this.refresh();
            }
        }
    }

    public class MyNavToolBar
    extends JdbNavToolBar {
        public void actionPerformed(ActionEvent e2) {
            if (DBViewer.this.beforeToolebarAction(e2)) {
                super.actionPerformed(e2);
                DBViewer.this.afterToolebarAction(e2);
            }
        }
    }
}

