/*
 * Decompiled with CFR 0.152.
 */
package edu.iastate.utils.sql;

import edu.iastate.utils.gui.LabelledItemPanel;
import edu.iastate.utils.sql.LocalDBConnection;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class JDBCConfigPanel
extends JPanel {
    public JTextField dbName = new JTextField();
    public JTextField dbMachineURL = new JTextField();
    public JTextField dbJdbcDriver = new JTextField();
    public JTextField dbUserID = new JTextField();
    public JPasswordField dbUserPwd = new JPasswordField();
    protected BorderLayout borderLayout1 = new BorderLayout();
    protected JButton btnTest = new JButton("Test Connection");
    protected String[] items = new String[]{"ORACLE", "MYSQL", "POSTGRE"};
    protected JComboBox dbType = new JComboBox<String>(this.items);
    protected JPanel paneButton = new JPanel();
    protected LabelledItemPanel myContentPane = new LabelledItemPanel();
    protected boolean useName = false;

    public void onTest(ActionEvent evt) {
        String driver = this.dbJdbcDriver.getText();
        try {
            Class.forName(driver);
        }
        catch (ClassNotFoundException ex) {
            String info = "JDBC driver " + driver + " is not found, connection failed";
            JOptionPane.showMessageDialog(this, info);
            return;
        }
        String good = "Given data source is connectable";
        String bad = "Given data source is NOT connectable";
        String info = this.connectable() ? good : bad;
        JOptionPane.showMessageDialog(this, info);
    }

    public LocalDBConnection getConnectionSetting() {
        LocalDBConnection ds = new LocalDBConnection();
        ds.setUrl(this.dbMachineURL.getText());
        ds.setUser(this.dbUserID.getText());
        ds.setPassword(new String(this.dbUserPwd.getPassword()));
        ds.setDriver(this.dbJdbcDriver.getText());
        return ds;
    }

    public boolean connectable() {
        LocalDBConnection ds = this.getConnectionSetting();
        boolean c2 = ds.connect();
        ds.disconnect();
        return c2;
    }

    protected void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.myContentPane.setBorder(BorderFactory.createEtchedBorder());
        if (this.useName) {
            this.myContentPane.addItem("Database Name", (JComponent)this.dbName);
        }
        this.myContentPane.addItem("Database Type", (JComponent)this.dbType);
        this.dbType.addItemListener(new DbTypeListListener());
        this.myContentPane.addItem("DB Machine URL", (JComponent)this.dbMachineURL);
        this.myContentPane.addItem("JDBC Driver", (JComponent)this.dbJdbcDriver);
        this.myContentPane.addItem("User ID", (JComponent)this.dbUserID);
        this.myContentPane.addItem("Password", (JComponent)this.dbUserPwd);
        this.myContentPane.setBorder(BorderFactory.createEtchedBorder());
        this.add((Component)this.myContentPane, "Center");
        this.add((Component)this.paneButton, "South");
        this.paneButton.add(this.btnTest);
    }

    class DbTypeListListener
    implements ItemListener {
        Map dbType2URL = new HashMap();
        Map dbType2Driver = new HashMap();

        DbTypeListListener() {
            this.dbType2URL.put("ORACLE", "jdbc:oracle:thin:@host:1521:YOUR_DB_NAME");
            this.dbType2Driver.put("ORACLE", "oracle.jdbc.driver.OracleDriver");
            this.dbType2URL.put("POSTGRE", "jdbc:postgresql://host:5432/YOUR_DB_NAME");
            this.dbType2Driver.put("POSTGRE", "org.postgresql.Driver");
            this.dbType2URL.put("MYSQL", "jdbc:mysql://host:3306/YOUR_DB_NAME");
            this.dbType2Driver.put("MYSQL", "org.gjt.mm.mysql.Driver");
        }

        public void itemStateChanged(ItemEvent evt) {
            JComboBox cb2 = (JComboBox)evt.getSource();
            Object item = evt.getItem();
            if (cb2 == JDBCConfigPanel.this.dbType && evt.getStateChange() == 1) {
                String dbTypeStr = (String)JDBCConfigPanel.this.dbType.getSelectedItem();
                if (dbTypeStr == null) {
                    return;
                }
                if (JDBCConfigPanel.this.dbMachineURL.getText() == null || JDBCConfigPanel.this.dbMachineURL.getText().trim().length() == 0 || JDBCConfigPanel.this.dbMachineURL.getText().endsWith("YOUR_DB_NAME")) {
                    JDBCConfigPanel.this.dbMachineURL.setText((String)this.dbType2URL.get(dbTypeStr));
                }
                JDBCConfigPanel.this.dbJdbcDriver.setText((String)this.dbType2Driver.get(dbTypeStr));
            }
        }
    }
}

