/*
 * Decompiled with CFR 0.152.
 */
package edu.iastate.utils.string;

import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TaggedText
implements CharSequence {
    String tag;
    Vector content;
    String leafText = null;
    boolean isLeaf = false;

    public TaggedText() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public TaggedText(String leafText) {
        this.tag = null;
        this.content = null;
        this.leafText = leafText;
        this.isLeaf = true;
    }

    public TaggedText(String tag, Vector content) {
        this.tag = tag;
        this.content = content == null ? new Vector() : content;
        this.leafText = null;
        this.isLeaf = false;
    }

    public int length() {
        return this.toString().length();
    }

    public char charAt(int index) {
        return this.toString().charAt(index);
    }

    public CharSequence subSequence(int start, int end) {
        return this.toString().subSequence(start, end);
    }

    public String toString() {
        return this.internalToXML();
    }

    public void addChild(String tag, String value) {
        if (!this.isLeaf) {
            Vector<TaggedText> newChildContent = new Vector<TaggedText>();
            newChildContent.add(new TaggedText(value));
            TaggedText newChild = new TaggedText(tag, newChildContent);
            this.content.add(newChild);
        }
    }

    public void addChild(TaggedText newChild) {
        if (!this.isLeaf) {
            if (newChild.isLeaf) {
                for (int i2 = 0; i2 < this.content.size(); ++i2) {
                    if (!((TaggedText)this.content.elementAt((int)i2)).isLeaf) continue;
                    this.content.remove(i2);
                    break;
                }
            }
            this.content.add(newChild);
        }
    }

    public String toXML() {
        String preface = "<?xml version =\"1.0\" encoding=\"ISO-8859-1\"?>";
        return preface + this.internalToXML();
    }

    String internalToXML() {
        if (this.isLeaf) {
            return this.leafText == null ? "" : this.leafText;
        }
        if (this.content == null) {
            return "<" + this.tag + "></" + this.tag + ">";
        }
        StringBuffer buf = new StringBuffer();
        buf.append("<" + this.tag + ">");
        for (int i2 = 0; i2 < this.content.size(); ++i2) {
            buf.append(((TaggedText)this.content.elementAt(i2)).internalToXML());
        }
        buf.append("</" + this.tag + ">");
        return buf.toString();
    }

    public TaggedText getChildByTag(String tag) {
        for (int i2 = 0; i2 < this.content.size(); ++i2) {
            TaggedText t2 = (TaggedText)this.content.elementAt(i2);
            if (!t2.tag.equals(tag)) continue;
            return t2;
        }
        return null;
    }

    public Vector getAllChildren() {
        return this.content;
    }

    public void fromXML(CharSequence inputStr) {
        String topPattern = "(?s)<(\\S+?).*?>(.*)</\\1>";
        Pattern top = Pattern.compile(topPattern);
        Matcher matcher = top.matcher(inputStr);
        this.content = new Vector();
        boolean matchFound = matcher.find();
        if (matchFound) {
            this.tag = matcher.group(1);
            String nested = matcher.group(2);
            String nestedPattern = "(?s)<(\\S+?)>(.*?)</\\1>";
            Pattern nestedContent = Pattern.compile(nestedPattern);
            matcher = nestedContent.matcher(nested);
            this.isLeaf = false;
            boolean found = false;
            while (matcher.find()) {
                TaggedText tt = new TaggedText();
                tt.fromXML(matcher.group(0));
                this.addChild(tt);
                found = true;
            }
            if (!found) {
                this.content.add(new TaggedText(nested));
            }
        } else {
            this.tag = null;
            this.content = null;
            this.leafText = ((Object)inputStr).toString();
            this.isLeaf = true;
        }
    }

    String getLeading(int times) {
        String leading = "";
        for (int i2 = 0; i2 < times; ++i2) {
            leading = leading + "    ";
        }
        return leading;
    }

    public String print(int level) {
        if (this.isLeaf) {
            return this.getLeading(level) + this.leafText + "\n";
        }
        StringBuffer head = new StringBuffer();
        if (level == 0) {
            head.append("<?xml version =\"1.0\" encoding=\"ISO-8859-1\"?>\n");
        }
        head.append(this.getLeading(level) + "<" + this.tag + ">\n");
        for (int i2 = 0; i2 < this.content.size(); ++i2) {
            TaggedText tt = (TaggedText)this.content.elementAt(i2);
            head.append(tt.print(level + 1));
        }
        head.append(this.getLeading(level) + "</" + this.tag + ">\n");
        return head.toString();
    }

    private void jbInit() throws Exception {
    }

    public String getTag() {
        return this.tag;
    }

    public Vector getContent() {
        return this.content;
    }

    public static void test() {
        String str = "<r><allnodes><node>1</node><node>2</node></allnodes><edge><no></no></edge></r>";
        TaggedText tt = new TaggedText();
        tt.fromXML(str);
        System.out.println(tt.print(0));
        System.out.println(tt);
    }
}

