/*
 * Decompiled with CFR 0.152.
 */
package edu.iastate.utils.undo;

import edu.iastate.utils.undo.EditingAction;
import java.util.Stack;

public class UndoRedoStack {
    Stack<EditingAction> undoStack = new Stack();
    Stack<EditingAction> redoStack = new Stack();
    int limit = 1000;

    public String toString() {
        String str = "Undo Stack: " + this.undoStack + "\n" + "Redo Stack: " + this.redoStack;
        return str;
    }

    public int getUndoSteps() {
        return this.undoStack.size();
    }

    public int getRedoSteps() {
        return this.redoStack.size();
    }

    public String topUndo() {
        if (this.undoStack.empty()) {
            return null;
        }
        EditingAction action = this.undoStack.peek();
        return action == null ? null : action.summary;
    }

    public String topRedo() {
        if (this.redoStack.empty()) {
            return null;
        }
        EditingAction action = this.redoStack.peek();
        return action == null ? null : action.summary;
    }

    public void addAction(EditingAction action) {
        if (this.undoStack.size() >= this.limit) {
            this.undoStack.removeElementAt(0);
        }
        this.undoStack.add(action);
        this.redoStack.clear();
    }

    public EditingAction undo() {
        EditingAction action = this.undoStack.pop();
        this.redoStack.push(action);
        action.undo();
        return action;
    }

    public EditingAction redo() {
        EditingAction action = this.redoStack.pop();
        this.undoStack.push(action);
        action.redo();
        return action;
    }

    public boolean canUndo() {
        return !this.undoStack.empty();
    }

    public boolean canRedo() {
        return !this.redoStack.empty();
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public int getLimit() {
        return this.limit;
    }

    public void clear() {
        this.undoStack.clear();
        this.redoStack.clear();
    }
}

