/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.templates;

import java.util.Enumeration;
import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xalan.templates.AVT;
import org.apache.xalan.templates.ElemTemplateElement;
import org.apache.xalan.templates.ElemUse;
import org.apache.xalan.templates.NamespaceAlias;
import org.apache.xalan.templates.StylesheetRoot;
import org.apache.xalan.transformer.ResultTreeHandler;
import org.apache.xalan.transformer.TransformerImpl;
import org.apache.xml.utils.StringVector;
import org.apache.xpath.XPathContext;
import org.xml.sax.SAXException;

public class ElemLiteralResult
extends ElemUse {
    private boolean isLiteralResultAsStylesheet = false;
    private Vector m_avts = null;
    private Vector m_xslAttr = null;
    private String m_namespace;
    private String m_localName;
    private String m_rawName;
    private StringVector m_ExtensionElementURIs;
    private String m_version;
    private StringVector m_excludeResultPrefixes;

    public void setIsLiteralResultAsStylesheet(boolean b2) {
        this.isLiteralResultAsStylesheet = b2;
    }

    public boolean getIsLiteralResultAsStylesheet() {
        return this.isLiteralResultAsStylesheet;
    }

    public void compose(StylesheetRoot sroot) throws TransformerException {
        super.compose(sroot);
        StylesheetRoot.ComposeState cstate = sroot.getComposeState();
        Vector vnames = cstate.getVariableNames();
        if (null != this.m_avts) {
            int nAttrs = this.m_avts.size();
            int i2 = nAttrs - 1;
            while (i2 >= 0) {
                AVT avt = (AVT)this.m_avts.elementAt(i2);
                avt.fixupVariables(vnames, cstate.getGlobalsSize());
                --i2;
            }
        }
    }

    public void addLiteralResultAttribute(AVT avt) {
        if (null == this.m_avts) {
            this.m_avts = new Vector();
        }
        this.m_avts.addElement(avt);
    }

    public void addLiteralResultAttribute(String att) {
        if (null == this.m_xslAttr) {
            this.m_xslAttr = new Vector();
        }
        this.m_xslAttr.addElement(att);
    }

    public void setXmlSpace(AVT avt) {
        this.addLiteralResultAttribute(avt);
        String val = avt.getSimpleString();
        if (val.equals("default")) {
            super.setXmlSpace(2);
        } else if (val.equals("preserve")) {
            super.setXmlSpace(1);
        }
    }

    public AVT getLiteralResultAttribute(String name) {
        if (null != this.m_avts) {
            int nAttrs = this.m_avts.size();
            int i2 = nAttrs - 1;
            while (i2 >= 0) {
                AVT avt = (AVT)this.m_avts.elementAt(i2);
                if (avt.getRawName().equals(name)) {
                    return avt;
                }
                --i2;
            }
        }
        return null;
    }

    public boolean containsExcludeResultPrefix(String prefix, String uri) {
        if (uri == null || null == this.m_excludeResultPrefixes && null == this.m_ExtensionElementURIs) {
            return super.containsExcludeResultPrefix(prefix, uri);
        }
        if (prefix.length() == 0) {
            prefix = "#default";
        }
        if (this.m_excludeResultPrefixes != null) {
            int i2 = 0;
            while (i2 < this.m_excludeResultPrefixes.size()) {
                if (uri.equals(this.getNamespaceForPrefix(this.m_excludeResultPrefixes.elementAt(i2)))) {
                    return true;
                }
                ++i2;
            }
        }
        if (this.m_ExtensionElementURIs != null && this.m_ExtensionElementURIs.contains(uri)) {
            return true;
        }
        return super.containsExcludeResultPrefix(prefix, uri);
    }

    public void resolvePrefixTables() throws TransformerException {
        NamespaceAlias nsa;
        super.resolvePrefixTables();
        StylesheetRoot stylesheet = this.getStylesheetRoot();
        if (null != this.m_namespace && this.m_namespace.length() > 0 && null != (nsa = stylesheet.getNamespaceAliasComposed(this.m_namespace))) {
            this.m_namespace = nsa.getResultNamespace();
            String resultPrefix = nsa.getStylesheetPrefix();
            this.m_rawName = null != resultPrefix && resultPrefix.length() > 0 ? resultPrefix + ":" + this.m_localName : this.m_localName;
        }
        if (null != this.m_avts) {
            int n2 = this.m_avts.size();
            int i2 = 0;
            while (i2 < n2) {
                NamespaceAlias nsa2;
                AVT avt = (AVT)this.m_avts.elementAt(i2);
                String ns = avt.getURI();
                if (null != ns && ns.length() > 0 && null != (nsa2 = stylesheet.getNamespaceAliasComposed(this.m_namespace))) {
                    String namespace = nsa2.getResultNamespace();
                    String resultPrefix = nsa2.getStylesheetPrefix();
                    String rawName = avt.getName();
                    if (null != resultPrefix && resultPrefix.length() > 0) {
                        rawName = resultPrefix + ":" + rawName;
                    }
                    avt.setURI(namespace);
                    avt.setRawName(rawName);
                }
                ++i2;
            }
        }
    }

    boolean needToCheckExclude() {
        if (null == this.m_excludeResultPrefixes && null == this.m_prefixTable && this.m_ExtensionElementURIs == null) {
            return false;
        }
        if (null == this.m_prefixTable) {
            this.m_prefixTable = new Vector();
        }
        return true;
    }

    public void setNamespace(String ns) {
        if (null == ns) {
            ns = "";
        }
        this.m_namespace = ns;
    }

    public String getNamespace() {
        return this.m_namespace;
    }

    public void setLocalName(String localName) {
        this.m_localName = localName;
    }

    public String getLocalName() {
        return this.m_localName;
    }

    public void setRawName(String rawName) {
        this.m_rawName = rawName;
    }

    public String getRawName() {
        return this.m_rawName;
    }

    public String getPrefix() {
        int len = this.m_rawName.length() - this.m_localName.length() - 1;
        return len > 0 ? this.m_rawName.substring(0, len) : "";
    }

    public void setExtensionElementPrefixes(StringVector v2) {
        this.m_ExtensionElementURIs = v2;
    }

    public String getExtensionElementPrefix(int i2) throws ArrayIndexOutOfBoundsException {
        if (null == this.m_ExtensionElementURIs) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.m_ExtensionElementURIs.elementAt(i2);
    }

    public int getExtensionElementPrefixCount() {
        return null != this.m_ExtensionElementURIs ? this.m_ExtensionElementURIs.size() : 0;
    }

    public boolean containsExtensionElementURI(String uri) {
        if (null == this.m_ExtensionElementURIs) {
            return false;
        }
        return this.m_ExtensionElementURIs.contains(uri);
    }

    public int getXSLToken() {
        return 77;
    }

    public String getNodeName() {
        return this.m_rawName;
    }

    public void setVersion(String v2) {
        this.m_version = v2;
    }

    public String getVersion() {
        return this.m_version;
    }

    public void setExcludeResultPrefixes(StringVector v2) {
        this.m_excludeResultPrefixes = v2;
    }

    private boolean excludeResultNSDecl(String prefix, String uri) throws TransformerException {
        if (null != this.m_excludeResultPrefixes) {
            return this.containsExcludeResultPrefix(prefix, uri);
        }
        return false;
    }

    public void execute(TransformerImpl transformer) throws TransformerException {
        try {
            ResultTreeHandler rhandler = transformer.getResultTreeHandler();
            rhandler.startPrefixMapping(this.getPrefix(), this.getNamespace());
            this.executeNSDecls(transformer);
            rhandler.startElement(this.getNamespace(), this.getLocalName(), this.getRawName(), null);
            try {
                super.execute(transformer);
                if (null != this.m_avts) {
                    int nAttrs = this.m_avts.size();
                    int i2 = nAttrs - 1;
                    while (i2 >= 0) {
                        int sourceNode;
                        XPathContext xctxt;
                        AVT avt = (AVT)this.m_avts.elementAt(i2);
                        String stringedValue = avt.evaluate(xctxt = transformer.getXPathContext(), sourceNode = xctxt.getCurrentNode(), this);
                        if (null != stringedValue) {
                            rhandler.addAttribute(avt.getURI(), avt.getName(), avt.getRawName(), "CDATA", stringedValue);
                        }
                        --i2;
                    }
                }
                transformer.executeChildTemplates((ElemTemplateElement)this, true);
                Object var10_10 = null;
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                rhandler.endElement(this.getNamespace(), this.getLocalName(), this.getRawName());
                this.unexecuteNSDecls(transformer);
                rhandler.endPrefixMapping(this.getPrefix());
                throw throwable;
            }
            rhandler.endElement(this.getNamespace(), this.getLocalName(), this.getRawName());
            this.unexecuteNSDecls(transformer);
            rhandler.endPrefixMapping(this.getPrefix());
            {
            }
        }
        catch (SAXException se) {
            throw new TransformerException(se);
        }
    }

    public Enumeration enumerateLiteralResultAttributes() {
        return null == this.m_avts ? null : this.m_avts.elements();
    }
}

