/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.utils;

import java.io.PrintStream;
import java.io.PrintWriter;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import org.apache.xml.utils.SAXSourceLocator;
import org.apache.xml.utils.WrappedRuntimeException;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DefaultErrorHandler
implements ErrorHandler,
ErrorListener {
    PrintWriter m_pw;

    public DefaultErrorHandler(PrintWriter pw) {
        this.m_pw = pw;
    }

    public DefaultErrorHandler(PrintStream pw) {
        this.m_pw = new PrintWriter(pw, true);
    }

    public DefaultErrorHandler() {
        this.m_pw = new PrintWriter(System.err, true);
    }

    public void warning(SAXParseException exception) throws SAXException {
        DefaultErrorHandler.printLocation(this.m_pw, exception);
        this.m_pw.println("Parser warning: " + exception.getMessage());
    }

    public void error(SAXParseException exception) throws SAXException {
        throw exception;
    }

    public void fatalError(SAXParseException exception) throws SAXException {
        throw exception;
    }

    public void warning(TransformerException exception) throws TransformerException {
        DefaultErrorHandler.printLocation(this.m_pw, (Throwable)exception);
        this.m_pw.println(exception.getMessage());
    }

    public void error(TransformerException exception) throws TransformerException {
        throw exception;
    }

    public void fatalError(TransformerException exception) throws TransformerException {
        throw exception;
    }

    public static void ensureLocationSet(TransformerException exception) {
        SourceLocator locator = null;
        Throwable cause = exception;
        do {
            SourceLocator causeLocator;
            if (cause instanceof SAXParseException) {
                locator = new SAXSourceLocator((SAXParseException)cause);
                continue;
            }
            if (!(cause instanceof TransformerException) || null == (causeLocator = cause.getLocator())) continue;
            locator = causeLocator;
        } while (null != (cause = cause instanceof TransformerException ? cause.getCause() : (cause instanceof SAXException ? ((SAXException)cause).getException() : null)));
        exception.setLocator(locator);
    }

    public static void printLocation(PrintStream pw, TransformerException exception) {
        DefaultErrorHandler.printLocation(new PrintWriter(pw), (Throwable)exception);
    }

    public static void printLocation(PrintWriter pw, Throwable exception) {
        SourceLocator locator = null;
        Throwable cause = exception;
        do {
            SourceLocator causeLocator;
            if (cause instanceof SAXParseException) {
                locator = new SAXSourceLocator((SAXParseException)cause);
                continue;
            }
            if (!(cause instanceof TransformerException) || null == (causeLocator = ((TransformerException)cause).getLocator())) continue;
            locator = causeLocator;
        } while (null != (cause = cause instanceof TransformerException ? ((TransformerException)cause).getCause() : (cause instanceof WrappedRuntimeException ? ((WrappedRuntimeException)cause).getException() : (cause instanceof SAXException ? ((SAXException)cause).getException() : null))));
        if (null != locator) {
            String id = locator.getPublicId() != locator.getPublicId() ? locator.getPublicId() : (null != locator.getSystemId() ? locator.getSystemId() : "SystemId Unknown");
            pw.print(id + "; Line " + locator.getLineNumber() + "; Column " + locator.getColumnNumber() + "; ");
        } else {
            pw.print("(Location of error unknown)");
        }
    }
}

