/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.axes;

import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xml.dtm.DTMIterator;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.WrappedRuntimeException;
import org.apache.xpath.Expression;
import org.apache.xpath.VariableStack;
import org.apache.xpath.XPathContext;
import org.apache.xpath.axes.AxesWalker;
import org.apache.xpath.axes.WalkingIterator;
import org.apache.xpath.compiler.Compiler;

public class FilterExprWalker
extends AxesWalker {
    private Expression m_expr;
    private transient DTMIterator m_nodeSet;

    FilterExprWalker(WalkingIterator locPathIterator) {
        super(locPathIterator, 20);
    }

    public void init(Compiler compiler, int opPos, int stepType) throws TransformerException {
        super.init(compiler, opPos, stepType);
        switch (stepType) {
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                this.m_expr = compiler.compile(opPos);
                break;
            }
            default: {
                this.m_expr = compiler.compile(opPos + 2);
            }
        }
    }

    public void setRoot(int root) {
        XPathContext xctxt = this.m_lpi.getXPathContext();
        PrefixResolver savedResolver = xctxt.getNamespaceContext();
        try {
            block5: {
                try {
                    xctxt.pushCurrentNode(root);
                    xctxt.setNamespaceContext(this.m_lpi.getPrefixResolver());
                    if (this.m_lpi.getIsTopLevel()) {
                        VariableStack vars = this.m_lpi.m_execContext.getVarStack();
                        int savedStart = vars.getStackFrame();
                        vars.setStackFrame(this.m_lpi.m_stackFrame);
                        this.m_nodeSet = this.m_expr.asIterator(xctxt, root);
                        vars.setStackFrame(savedStart);
                        break block5;
                    }
                    this.m_nodeSet = this.m_expr.asIterator(xctxt, root);
                }
                catch (TransformerException se) {
                    throw new WrappedRuntimeException(se);
                }
            }
            Object var7_7 = null;
            xctxt.popCurrentNode();
            xctxt.setNamespaceContext(savedResolver);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            xctxt.popCurrentNode();
            xctxt.setNamespaceContext(savedResolver);
            throw throwable;
        }
        super.setRoot(root);
    }

    public Object clone() throws CloneNotSupportedException {
        FilterExprWalker clone = (FilterExprWalker)super.clone();
        if (null != this.m_nodeSet) {
            clone.m_nodeSet = (DTMIterator)this.m_nodeSet.clone();
        }
        return clone;
    }

    public short acceptNode(int n2) {
        try {
            if (this.getPredicateCount() > 0) {
                this.countProximityPosition(0);
                if (!this.executePredicates(n2, this.m_lpi.getXPathContext())) {
                    return 3;
                }
            }
            return 1;
        }
        catch (TransformerException se) {
            throw new RuntimeException(se.getMessage());
        }
    }

    public int getNextNode() {
        if (null != this.m_nodeSet) {
            return this.m_nodeSet.nextNode();
        }
        return -1;
    }

    public int getLastPos(XPathContext xctxt) {
        return this.m_nodeSet.getLength();
    }

    public void fixupVariables(Vector vars, int globalsSize) {
        super.fixupVariables(vars, globalsSize);
        this.m_expr.fixupVariables(vars, globalsSize);
    }

    public boolean isDocOrdered() {
        return this.m_nodeSet.isDocOrdered();
    }

    public int getAxis() {
        return this.m_nodeSet.getAxis();
    }
}

